/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.Chatty;
import chatty.Helper;
import chatty.gui.emoji.EmojiUtil;
import chatty.util.CombinedEmoticon;
import chatty.util.CombinedIterator;
import chatty.util.LogUtil;
import chatty.util.MiscUtil;
import chatty.util.StringUtil;
import chatty.util.TwitchEmotesApi;
import chatty.util.api.CachedImage;
import chatty.util.api.CheerEmoticon;
import chatty.util.api.CheersUtil;
import chatty.util.api.EmotesetManager;
import chatty.util.api.Emoticon;
import chatty.util.api.EmoticonFavorites;
import chatty.util.api.EmoticonUpdate;
import chatty.util.api.IgnoredEmotes;
import chatty.util.settings.Settings;
import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Timer;

public class Emoticons {
    private static final Logger LOGGER = Logger.getLogger(Emoticons.class.getName());
    private static final Map<String, String> EMOTICONS_MAP = new HashMap<String, String>();
    private final Map<String, Set<Emoticon>> emoticonsByEmoteset = new HashMap<String, Set<Emoticon>>();
    private final Set<Emoticon> customEmotes = new HashSet<Emoticon>();
    private final Map<String, Emoticon> customEmotesById = new HashMap<String, Emoticon>();
    private final Set<Emoticon> emoji = new TreeSet<Emoticon>(new Comparator<Emoticon>(){

        @Override
        public int compare(Emoticon s1, Emoticon s2) {
            int cmp = Integer.compare(s2.code.length(), s1.code.length());
            return cmp != 0 ? cmp : s1.code.compareTo(s2.code);
        }
    });
    private final Set<Emoticon> globalTwitchEmotes = new HashSet<Emoticon>();
    private final Map<String, Set<Emoticon>> followerEmotes = new HashMap<String, Set<Emoticon>>();
    private final CheersUtil cheers = new CheersUtil();
    private final Set<Emoticon> otherGlobalEmotes = new HashSet<Emoticon>();
    private final Set<Emoticon> localEmotes = new HashSet<Emoticon>();
    private final Set<Emoticon> smilies = new HashSet<Emoticon>();
    private final HashMap<String, Emoticon> twitchEmotesById = new HashMap();
    private final HashMap<String, Set<Emoticon>> streamEmoticons = new HashMap();
    private final Map<String, Emoticon> combinedEmotes = new HashMap<String, Emoticon>();
    private final GlobalEmotes usableGlobalEmotes = new GlobalEmotes();
    private final Map<String, Set<Emoticon>> usableStreamEmotes = new HashMap<String, Set<Emoticon>>();
    private Set<String> localEmotesets = new HashSet<String>();
    private static final Set<Emoticon> EMPTY_SET;
    private final IgnoredEmotes ignoredEmotes = new IgnoredEmotes();
    private final EmoticonFavorites favorites = new EmoticonFavorites();
    private EmotesetManager localEmotesetManager;
    private static final int DEFAULT_IMAGE_EXPIRE_MINUTES = 240;
    private static final int FASTER_IMAGE_EXPIRE_MINUTES = 60;
    private final Map<String, Set<TwitchEmotesApi.EmotesetInfo>> twitchEmotesByStream = new HashMap<String, Set<TwitchEmotesApi.EmotesetInfo>>();
    private final Map<String, TwitchEmotesApi.EmotesetInfo> infoBySet = new HashMap<String, TwitchEmotesApi.EmotesetInfo>();
    private static final List<String> TURBO_EMOTESETS;
    private static final Pattern SPLIT_EMOTESETS;
    private volatile Map<Pattern, String> emojiReplacement;

    public Emoticons() {
        Timer timer = new Timer(3600000, e -> {
            int imageExpireMinutes = 240;
            if (LogUtil.getMemoryPercentageOfMax() > 80) {
                imageExpireMinutes = 60;
            }
            int removedCount = 0;
            removedCount += Emoticons.clearOldEmoticonImages(this.twitchEmotesById.values(), imageExpireMinutes);
            removedCount += Emoticons.clearOldEmoticonImages(this.otherGlobalEmotes, imageExpireMinutes);
            for (Set<Emoticon> emotes : this.streamEmoticons.values()) {
                removedCount += Emoticons.clearOldEmoticonImages(emotes, imageExpireMinutes);
            }
            LOGGER.info(String.format("Cleared %d unused emoticon images (%dm)", removedCount, imageExpireMinutes));
        });
        timer.setRepeats(true);
        timer.start();
    }

    public Set<TwitchEmotesApi.EmotesetInfo> getSetsByStream(String stream) {
        return this.twitchEmotesByStream.get(stream);
    }

    public TwitchEmotesApi.EmotesetInfo getInfoBySet(String set) {
        return this.infoBySet.get(set);
    }

    public void updateEmoticons(EmoticonUpdate update) {
        this.removeEmoticons(update);
        if (!update.emotesToAdd.isEmpty()) {
            this.addEmoticons(update.emotesToAdd);
        }
        if (update.source == EmoticonUpdate.Source.HELIX_CHANNEL) {
            HashSet<TwitchEmotesApi.EmotesetInfo> sets = new HashSet<TwitchEmotesApi.EmotesetInfo>();
            String stream = null;
            for (Emoticon emote : update.emotesToAdd) {
                TwitchEmotesApi.EmotesetInfo info = new TwitchEmotesApi.EmotesetInfo(emote.emoteset, emote.getStream(), null, emote.getEmotesetInfo());
                sets.add(info);
                stream = emote.getStream();
            }
            if (stream != null) {
                this.twitchEmotesByStream.put(stream, sets);
            }
        }
        if (update.setInfos != null) {
            for (TwitchEmotesApi.EmotesetInfo info : update.setInfos) {
                this.infoBySet.put(info.emoteset_id, info);
            }
        }
    }

    private void removeEmoticons(EmoticonUpdate update) {
        if (update.typeToRemove == null) {
            return;
        }
        int removedCount = 0;
        if (update.typeToRemove == Emoticon.Type.FFZ || update.typeToRemove == Emoticon.Type.BTTV || update.typeToRemove == Emoticon.Type.SEVENTV) {
            Iterator<Emoticon> it;
            if (update.roomToRemove == null) {
                it = this.otherGlobalEmotes.iterator();
            } else {
                if (!this.streamEmoticons.containsKey(update.roomToRemove)) {
                    return;
                }
                it = this.streamEmoticons.get(update.roomToRemove).iterator();
            }
            while (it.hasNext()) {
                Emoticon emote = it.next();
                if (emote.type != update.typeToRemove || update.subTypeToRemove != null && emote.subType != update.subTypeToRemove) continue;
                it.remove();
                this.usableGlobalEmotes.remove(emote);
                if (update.roomToRemove != null && this.usableStreamEmotes.containsKey(update.roomToRemove)) {
                    this.usableStreamEmotes.get(update.roomToRemove).remove(emote);
                }
                ++removedCount;
            }
        }
        if (update.typeToRemove == Emoticon.Type.TWITCH && update.setsToRemove != null) {
            for (String set : update.setsToRemove) {
                Set<Emoticon> removed = this.emoticonsByEmoteset.remove(set);
                if (removed != null) {
                    removedCount += removed.size();
                    removed.forEach(e -> this.usableGlobalEmotes.remove((Emoticon)e));
                }
                this.followerEmotes.remove(set);
            }
        }
        if (update.typeToRemove == Emoticon.Type.CUSTOM2) {
            removedCount += this.localEmotes.size();
            for (Emoticon emote : this.localEmotes) {
                this.usableGlobalEmotes.remove(emote);
            }
            this.localEmotes.clear();
        }
        if (removedCount >= 0) {
            LOGGER.info(String.format(Locale.ROOT, "Removed %d emotes (%s/%s/%s/%s)", new Object[]{removedCount, update.typeToRemove, update.subTypeToRemove, update.roomToRemove, update.setsToRemove}));
        }
    }

    public void addEmoticons(Set<Emoticon> newEmoticons) {
        for (Emoticon emote : newEmoticons) {
            Set<String> channelRestrictions = emote.getStreamRestrictions();
            if (channelRestrictions != null) {
                for (String channel : channelRestrictions) {
                    if (!this.streamEmoticons.containsKey(channel)) {
                        this.streamEmoticons.put(channel, new HashSet());
                    }
                    this.addEmote((Collection<Emoticon>)this.streamEmoticons.get(channel), emote);
                }
            } else if (emote.hasGlobalEmoteset()) {
                if (emote.type == Emoticon.Type.TWITCH) {
                    this.addEmote(this.globalTwitchEmotes, emote);
                } else if (emote.type == Emoticon.Type.CUSTOM2) {
                    this.addEmote(this.localEmotes, emote);
                } else {
                    this.addEmote(this.otherGlobalEmotes, emote);
                }
            } else if (emote.subType == Emoticon.SubType.FOLLOWER) {
                MiscUtil.getSetFromMap(this.followerEmotes, emote.emoteset).remove(emote);
                MiscUtil.getSetFromMap(this.followerEmotes, emote.emoteset).add(emote);
                MiscUtil.getSetFromMap(this.emoticonsByEmoteset, emote.emoteset).remove(emote);
                MiscUtil.getSetFromMap(this.emoticonsByEmoteset, emote.emoteset).add(emote);
            } else {
                String emoteset = emote.emoteset;
                if (!this.emoticonsByEmoteset.containsKey(emoteset)) {
                    this.emoticonsByEmoteset.put(emoteset, new HashSet());
                }
                this.addEmote((Collection<Emoticon>)this.emoticonsByEmoteset.get(emoteset), emote);
            }
            if (emote.type != Emoticon.Type.TWITCH || emote.stringId == null) continue;
            this.twitchEmotesById.put(emote.stringId, emote);
        }
        LOGGER.info(String.format("Added %d emotes. Now %d emotesets, %d channels, %d Twitch Global, %d Other Global.", newEmoticons.size(), this.emoticonsByEmoteset.size(), this.streamEmoticons.size(), this.globalTwitchEmotes.size(), this.otherGlobalEmotes.size()));
        this.findFavorites();
    }

    private void addEmote(Collection<Emoticon> collection, Emoticon emote) {
        if (!emote.hasStreamRestrictions()) {
            if (emote.hasGlobalEmoteset() || this.localEmotesets.contains(emote.emoteset)) {
                this.usableGlobalEmotes.remove(emote);
                this.usableGlobalEmotes.add(emote);
            }
        } else if (emote.hasGlobalEmoteset() || this.localEmotesets.contains(emote.emoteset)) {
            for (String stream : emote.getStreamRestrictions()) {
                this.getUsableStreamEmotesSet(stream).remove(emote);
                this.getUsableStreamEmotesSet(stream).add(emote);
            }
        }
        collection.remove(emote);
        collection.add(emote);
    }

    public void addTempEmoticon(Emoticon emote) {
        this.twitchEmotesById.put(emote.stringId, emote);
    }

    public void setSmilies(Set<Emoticon> emotes) {
        this.smilies.clear();
        if (emotes != null) {
            this.smilies.addAll(emotes);
            LOGGER.info("Set " + this.smilies.size() + " smilies");
        }
    }

    public Set<Emoticon> getSmilies() {
        if (this.smilies != null) {
            return this.smilies;
        }
        return EMPTY_SET;
    }

    public void setLocalEmotes(Collection<Emoticon> emotes) {
        EmoticonUpdate.Builder b = new EmoticonUpdate.Builder(new HashSet<Emoticon>(emotes));
        b.setTypeToRemove(Emoticon.Type.CUSTOM2);
        this.updateEmoticons(b.build());
    }

    public Set<Emoticon> getCustomLocalEmotes() {
        return this.localEmotes;
    }

    public boolean canAddCustomLocal(Emoticon emote) {
        return !(emote.type != Emoticon.Type.TWITCH && emote.type != Emoticon.Type.CUSTOM2 || emote.subType != null && emote.subType != Emoticon.SubType.REGULAR || emote.stringId == null);
    }

    public boolean isCustomLocal(Emoticon emote) {
        if (emote.type == Emoticon.Type.CUSTOM2) {
            return true;
        }
        for (Emoticon presentEmote : this.localEmotes) {
            if (!presentEmote.stringId.equals(emote.stringId)) continue;
            return true;
        }
        return false;
    }

    private static int clearOldEmoticonImages(Collection<Emoticon> emotes, int imageExpireMinutes) {
        int removedCount = 0;
        for (Emoticon emote : emotes) {
            removedCount += emote.clearOldImages(imageExpireMinutes);
        }
        return removedCount;
    }

    public Set<Emoticon> getCustomEmotes() {
        return this.customEmotes;
    }

    public Emoticon getCustomEmoteById(String id) {
        return this.customEmotesById.get(id);
    }

    public Set<Emoticon> getEmoji() {
        return this.emoji;
    }

    public Set<Emoticon> getGlobalTwitchEmotes() {
        return this.globalTwitchEmotes;
    }

    public Set<CheerEmoticon> getCheerEmotes() {
        return this.cheers.get();
    }

    public String getCheerEmotesString(String stream) {
        return this.cheers.getString(stream);
    }

    public Set<Emoticon> getOtherGlobalEmotes() {
        return this.otherGlobalEmotes;
    }

    public HashMap<String, Emoticon> getEmoticonsById() {
        return this.twitchEmotesById;
    }

    public Set<Emoticon> getEmoticonsBySet(String emoteSet) {
        Set<Emoticon> result = this.emoticonsByEmoteset.get(emoteSet);
        if (result == null) {
            result = EMPTY_SET;
        }
        return result;
    }

    public Set<Emoticon> getEmoticonsByStream(String stream) {
        Set<Emoticon> result = this.streamEmoticons.get(stream);
        if (result == null) {
            result = EMPTY_SET;
        }
        return result;
    }

    public Emoticon getCombinedEmote(List<Emoticon> emotes, CachedImage.ImageType imageType) {
        String code = CombinedEmoticon.getCode(emotes = new ArrayList<Emoticon>(emotes));
        Emoticon emote = this.combinedEmotes.get(code);
        if (emote != null) {
            return emote;
        }
        emote = CombinedEmoticon.create(emotes, code, imageType);
        this.combinedEmotes.put(code, emote);
        return emote;
    }

    public Set<Emoticon> getUsableGlobalTwitchEmotes() {
        return this.usableGlobalEmotes.getTwitch();
    }

    public void setLocalEmotesetManager(EmotesetManager manager) {
        this.localEmotesetManager = manager;
    }

    public Set<Emoticon> getUsableFollowerEmotes(String stream) {
        if (this.localEmotesetManager != null && !StringUtil.isNullOrEmpty(stream)) {
            Set<String> emotesets = this.localEmotesetManager.getEmotesetsByChannel(Helper.toChannel(stream));
            HashSet<Emoticon> result = new HashSet<Emoticon>();
            for (String set : emotesets) {
                result.addAll((Collection<Emoticon>)this.followerEmotes.getOrDefault(set, EMPTY_SET));
            }
            return result;
        }
        return EMPTY_SET;
    }

    public Set<Emoticon> getUsableGlobalOtherEmotes() {
        return this.usableGlobalEmotes.getOther();
    }

    public Collection<Emoticon> getUsableEmotesByStream(String stream) {
        Collection result = this.usableStreamEmotes.get(stream);
        return result == null ? EMPTY_SET : result;
    }

    public void updateLocalEmotes(Set<String> emotesets) {
        if (!this.localEmotesets.equals(emotesets)) {
            this.localEmotesets = emotesets;
            Iterator<Emoticon> it = this.usableGlobalEmotes.iterator();
            while (it.hasNext()) {
                Emoticon emote = it.next();
                if (emote.hasGlobalEmoteset() || this.localEmotesets.contains(emote.emoteset)) continue;
                it.remove();
            }
            for (String emoteset : emotesets) {
                for (Emoticon emote : this.getEmoticonsBySet(emoteset)) {
                    this.usableGlobalEmotes.add(emote);
                }
            }
        }
        if (!this.localEmotesets.equals(emotesets)) {
            this.localEmotesets = emotesets;
            for (Map.Entry<String, Set<Emoticon>> entry : this.usableStreamEmotes.entrySet()) {
                Iterator<Emoticon> itStream = entry.getValue().iterator();
                while (itStream.hasNext()) {
                    Emoticon emote = itStream.next();
                    if (emote.hasGlobalEmoteset() || this.localEmotesets.contains(emote.emoteset)) continue;
                    itStream.remove();
                }
            }
            for (Map.Entry<String, Set<Emoticon>> entry : this.streamEmoticons.entrySet()) {
                String stream = entry.getKey();
                for (Emoticon emote : entry.getValue()) {
                    if (!emote.hasGlobalEmoteset() && !this.localEmotesets.contains(emote.emoteset)) continue;
                    this.getUsableStreamEmotesSet(stream).add(emote);
                }
            }
        }
    }

    private Set<Emoticon> getUsableStreamEmotesSet(String stream) {
        if (!this.usableStreamEmotes.containsKey(stream)) {
            this.usableStreamEmotes.put(stream, new TreeSet<Emoticon>(new SortEmotesByTypeAndCode()));
        }
        return this.usableStreamEmotes.get(stream);
    }

    public Set<String> getLocalEmotesets() {
        return this.localEmotesets;
    }

    public static boolean isTurboEmoteset(String emoteset) {
        if (emoteset == null) {
            return false;
        }
        return TURBO_EMOTESETS.contains(emoteset);
    }

    public static Set<String> parseEmotesets(String input) {
        String[] split;
        if (input == null) {
            return null;
        }
        HashSet<String> result = null;
        for (String set : split = SPLIT_EMOTESETS.split(input)) {
            if (set.trim().isEmpty()) continue;
            if (result == null) {
                result = new HashSet<String>();
            }
            result.add(set);
        }
        return result;
    }

    public String getLabelByEmoteset(String emoteset) {
        if (Emoticons.isTurboEmoteset(emoteset)) {
            return "Turbo/Prime Emotes";
        }
        return null;
    }

    public void setIgnoredEmotes(Collection<String> ignoredEmotes) {
        this.ignoredEmotes.setData(ignoredEmotes);
    }

    public void setEmoteIgnored(Emoticon emote, int context, Settings settings) {
        this.ignoredEmotes.add(emote, context);
        settings.putList("ignoredEmotes", this.ignoredEmotes.getData());
    }

    public Collection<IgnoredEmotes.Item> getIgnoredEmoteMatches(Emoticon emote) {
        return this.ignoredEmotes.getMatches(emote);
    }

    public boolean isEmoteIgnored(Emoticon emote, int context) {
        return this.ignoredEmotes.isIgnored(emote, context);
    }

    public String getEmoteInfo(String emoteCode) {
        if (emoteCode == null) {
            return "No emote specified.";
        }
        Set<Emoticon> found = this.findMatchingEmoticons(emoteCode);
        if (found.isEmpty()) {
            return "No matching emote found.";
        }
        StringBuilder b = new StringBuilder();
        b.append("Found ").append(found.size());
        if (found.size() == 1) {
            b.append(" emote");
        } else {
            b.append(" emotes");
        }
        b.append(" for '").append(emoteCode).append("': ");
        String sep = "";
        for (Emoticon emote : found) {
            Set<String> streams = emote.getStreamRestrictions();
            b.append(sep + "'" + emote.code + "' / Type: " + (Object)((Object)emote.type) + " / " + (emote.hasGlobalEmoteset() ? "Usable by everyone" : "Emoteset: " + emote.emoteset + " (" + this.getLabelByEmoteset(emote.emoteset) + ")") + (streams == null ? " / Usable in all channels" : " / Only usable in: " + streams));
            sep = " ### ";
        }
        return b.toString();
    }

    public Set<Emoticon> findMatchingEmoticons(String emoteCode) {
        HashSet<Emoticon> found = new HashSet<Emoticon>();
        found.addAll(this.findMatchingEmoticons(emoteCode, this.emoticonsByEmoteset.values()));
        found.addAll(this.findMatchingEmoticons(emoteCode, this.streamEmoticons.values()));
        return found;
    }

    public Set<Emoticon> findMatchingEmoticons(String emoteCode, Collection<Set<Emoticon>> values) {
        HashSet<Emoticon> found = new HashSet<Emoticon>();
        for (Collection collection : values) {
            for (Emoticon emote : collection) {
                if (!emote.getMatcher(emoteCode).matches()) continue;
                found.add(emote);
            }
        }
        return found;
    }

    public static final Set<Emoticon> filterByType(Set<Emoticon> emotes, Emoticon.Type type) {
        HashSet<Emoticon> filtered = new HashSet<Emoticon>();
        for (Emoticon emote : emotes) {
            if (emote.type != type) continue;
            filtered.add(emote);
        }
        return filtered;
    }

    public boolean equalsByCode(String setA, String setB) {
        Set<Emoticon> a = this.getEmoticonsBySet(setA);
        Set<Emoticon> b = this.getEmoticonsBySet(setB);
        return Emoticons.equalsByCode(a, b);
    }

    public static final boolean equalsByCode(Collection<Emoticon> a, Collection<Emoticon> b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (Emoticon emoteA : a) {
            boolean found = false;
            for (Emoticon emoteB : b) {
                if (!emoteA.code.equals(emoteB.code)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static final String toWriteable(String emoteCode) {
        String writeable = EMOTICONS_MAP.get(emoteCode);
        if (writeable == null) {
            return emoteCode;
        }
        return writeable;
    }

    public static final String toRegex(String emoteCode) {
        for (Map.Entry<String, String> entry : EMOTICONS_MAP.entrySet()) {
            if (!entry.getValue().equals(emoteCode) && !emoteCode.matches(entry.getKey())) continue;
            return entry.getKey();
        }
        return emoteCode;
    }

    public void addFavorite(Emoticon emote) {
        this.favorites.addFavorite(emote);
    }

    public void removeFavorite(Emoticon emote) {
        this.favorites.removeFavorite(emote);
    }

    public void removeFavorites(Collection<EmoticonFavorites.Favorite> toRemove) {
        this.favorites.removeFavorites(toRemove);
    }

    public boolean isFavorite(Emoticon emote) {
        return this.favorites.isFavorite(emote);
    }

    public Set<Emoticon> getFavorites() {
        return this.favorites.getFavorites();
    }

    public Collection<EmoticonFavorites.Favorite> getNotFoundFavorites() {
        return this.favorites.getNotFound();
    }

    public void loadFavoritesFromSettings(Settings settings) {
        this.favorites.loadFavoritesFromSettings(settings);
        this.findFavorites();
    }

    private void findFavorites() {
        this.favorites.find(this.twitchEmotesById, this.otherGlobalEmotes, this.emoji, this.customEmotes, this.localEmotes);
    }

    public Set<String> getFavoritesNonGlobalEmotesets() {
        return this.favorites.getNonGlobalEmotesets();
    }

    public void saveFavoritesToSettings(Settings settings) {
        this.favorites.saveFavoritesToSettings(settings);
    }

    public void loadCustomEmotes() {
        this.customEmotes.clear();
        this.customEmotesById.clear();
        Path file = Chatty.getPath(Chatty.PathType.SETTINGS).resolve("emotes.txt");
        try (BufferedReader r = Files.newBufferedReader(file, Charset.forName("UTF-8"));){
            String line;
            int countLoaded = 0;
            boolean firstLine = true;
            while ((line = r.readLine()) != null) {
                if (firstLine) {
                    line = StringUtil.removeUTF8BOM(line);
                    firstLine = false;
                }
                if (!this.loadCustomEmote(line)) continue;
                ++countLoaded;
            }
            LOGGER.info("Loaded " + countLoaded + " custom emotes");
            this.findFavorites();
        }
        catch (IOException ex) {
            LOGGER.info("Didn't load custom emotes: " + ex);
        }
    }

    private boolean loadCustomEmote(String line) {
        if (line.startsWith("#")) {
            return false;
        }
        String code = null;
        boolean literal = true;
        String url = null;
        String emoteset = Emoticon.SET_NONE;
        String id = null;
        Dimension size = null;
        String streamRestriction = null;
        String[] split = line.trim().split("\\s+");
        for (int i = 0; i < split.length; ++i) {
            String item = split[i];
            if (item.startsWith("re:") && item.length() > "re:".length()) {
                literal = false;
                code = item.substring("re:".length());
                continue;
            }
            if (item.startsWith("id:")) {
                id = item.substring("id:".length());
                continue;
            }
            if (item.startsWith("set:")) {
                emoteset = item.substring("set:".length());
                continue;
            }
            if (item.startsWith("chan:") && item.length() > "chan:".length()) {
                streamRestriction = Helper.toStream(item.substring("chan:".length()));
                continue;
            }
            if (item.startsWith("size:")) {
                try {
                    String[] sizes = item.substring("size:".length()).split("x");
                    int width = Integer.parseInt(sizes[0]);
                    int height = Integer.parseInt(sizes[1]);
                    size = new Dimension(width, height);
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException sizes) {}
                continue;
            }
            if (code == null) {
                code = item;
                continue;
            }
            if (url != null) continue;
            url = item;
            if (item.startsWith("http")) continue;
            try {
                Path path = Chatty.getPath(Chatty.PathType.SETTINGS).resolve(Paths.get(url, new String[0]));
                url = path.toUri().toURL().toString();
                continue;
            }
            catch (MalformedURLException ex) {
                url = null;
            }
        }
        if (code != null && url != null) {
            Emoticon.Builder b = new Emoticon.Builder(Emoticon.Type.CUSTOM, code);
            b.addUrl(1, url);
            b.setLiteral(literal).setEmoteset(emoteset);
            b.setStringId(id);
            if (size != null) {
                b.setSize(size.width, size.height);
            }
            b.addStreamRestriction(streamRestriction);
            Emoticon emote = b.build();
            this.customEmotes.add(emote);
            if (id != null) {
                this.customEmotesById.put(id, emote);
            }
            return true;
        }
        return false;
    }

    public String getCustomEmotesInfo() {
        if (this.customEmotes.isEmpty()) {
            return "No custom emotes loaded";
        }
        StringBuilder b = new StringBuilder(this.customEmotes.size() + " custom emotes loaded:\n");
        for (Emoticon emote : this.customEmotes) {
            ArrayList<String> info = new ArrayList<String>();
            if (emote.hasStreamRestrictions()) {
                info.add("#" + emote.getStreamRestrictions().iterator().next());
            }
            if (emote.emoteset != null) {
                info.add("set:" + emote.emoteset);
            }
            if (emote.stringId != null) {
                info.add("id:" + emote.stringId);
            }
            b.append("\"" + emote.code + "\" ");
            if (info.size() > 0) {
                b.append(info);
            }
            b.append("\n   ");
            b.append(emote.url);
            b.append("\n");
        }
        b.delete(b.length() - 1, b.length());
        return b.toString();
    }

    public static TagEmotes parseEmotesTag(String tag) {
        String[] emotes;
        HashMap<Integer, TagEmote> result = new HashMap<Integer, TagEmote>();
        if (tag == null) {
            return null;
        }
        for (String emote : emotes = tag.split("/")) {
            int idEnd = emote.indexOf(":");
            if (idEnd <= 0) continue;
            try {
                String[] emoteRanges;
                String id = emote.substring(0, idEnd);
                for (String range : emoteRanges = emote.substring(idEnd + 1).split(",")) {
                    String[] rangeSplit = range.split("-");
                    int start = Integer.parseInt(rangeSplit[0]);
                    int end = Integer.parseInt(rangeSplit[1]);
                    if (end <= start || start < 0) continue;
                    result.put(start, new TagEmote(id, end));
                }
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        return new TagEmotes(result);
    }

    public static void main(String[] args) {
        System.out.println(Emoticons.parseEmotesTag("131:1-2,4-5/43:1-7"));
        HashSet<Emoticon> a = new HashSet<Emoticon>();
        HashSet<Emoticon> b = new HashSet<Emoticon>();
        a.add(Emoticons.testBuild("abc"));
        b.add(Emoticons.testBuild("abc"));
        b.add(Emoticons.testBuild("abcd"));
        System.out.println(Emoticons.equalsByCode(a, b));
    }

    private static Emoticon testBuild(String code) {
        Emoticon.Builder b = new Emoticon.Builder(Emoticon.Type.TWITCH, code);
        return b.build();
    }

    public void addEmoji(String sourceId) {
        this.emoji.clear();
        this.emoji.addAll(EmojiUtil.makeEmoticons(sourceId));
        HashMap<Pattern, String> replacements = new HashMap<Pattern, String>();
        for (Emoticon e : this.emoji) {
            if (e.stringId != null) {
                replacements.put(Pattern.compile(e.stringId, 16), e.code);
            }
            if (e.stringIdAlias == null) continue;
            replacements.put(Pattern.compile(e.stringIdAlias, 16), e.code);
        }
        this.emojiReplacement = replacements;
    }

    public String emojiReplace(String input) {
        for (Pattern p : this.emojiReplacement.keySet()) {
            Matcher m = p.matcher(input);
            if (!m.find()) continue;
            input = p.matcher(input).replaceAll(this.emojiReplacement.get(p));
        }
        return input;
    }

    public void setCheerEmotes(Set<CheerEmoticon> newCheerEmotes) {
        this.cheers.add(newCheerEmotes);
        LOGGER.info("Found " + newCheerEmotes.size() + " cheer emotes");
    }

    public void setCheerState(String state) {
        this.cheers.setState(state);
    }

    public void setCheerBackground(Color color) {
        this.cheers.setBackgroundColor(color);
    }

    static {
        EMOTICONS_MAP.put("B-?\\)", "B)");
        EMOTICONS_MAP.put("R-?\\)", "R)");
        EMOTICONS_MAP.put("\\:-?D", ":D");
        EMOTICONS_MAP.put("\\;-?\\)", ";)");
        EMOTICONS_MAP.put("\\:-?(o|O)", ":O");
        EMOTICONS_MAP.put("\\:-?\\)", ":)");
        EMOTICONS_MAP.put("\\;-?(p|P)", ";p");
        EMOTICONS_MAP.put("[oO](_|\\.)[oO]", "O_o");
        EMOTICONS_MAP.put(">\\(", ">(");
        EMOTICONS_MAP.put("\\:-?(?:\\/|\\\\)(?!\\/)", ":/");
        EMOTICONS_MAP.put("\\:-?\\(", ":(");
        EMOTICONS_MAP.put("\\:-?(p|P)", ":p");
        EMOTICONS_MAP.put("\\:-?[z|Z|\\|]", ":|");
        EMOTICONS_MAP.put(":-?(?:7|L)", ":7");
        EMOTICONS_MAP.put("\\:>", ":>");
        EMOTICONS_MAP.put("\\:-?(S|s)", ":S");
        EMOTICONS_MAP.put("#-?[\\\\/]", "#/");
        EMOTICONS_MAP.put("<\\]", "<]");
        EMOTICONS_MAP.put("\\:-?[\\\\/]", ":\\");
        EMOTICONS_MAP.put("\\:-?\\)", ":)");
        EMPTY_SET = Collections.unmodifiableSet(new HashSet());
        TURBO_EMOTESETS = Arrays.asList("33", "42", "457", "793", "19194");
        SPLIT_EMOTESETS = Pattern.compile(",");
    }

    private static class GlobalEmotes {
        private final Set<Emoticon> twitch = new HashSet<Emoticon>();
        private final Set<Emoticon> other = new HashSet<Emoticon>();

        private GlobalEmotes() {
        }

        public void add(Emoticon emote) {
            if (emote.type == Emoticon.Type.TWITCH || emote.type == Emoticon.Type.CUSTOM2) {
                this.twitch.add(emote);
            } else {
                this.other.add(emote);
            }
        }

        public void remove(Emoticon emote) {
            this.twitch.remove(emote);
            this.other.remove(emote);
        }

        public Set<Emoticon> getTwitch() {
            return this.twitch;
        }

        public Set<Emoticon> getOther() {
            return this.other;
        }

        public Iterator<Emoticon> iterator() {
            return new CombinedIterator<Emoticon>(this.twitch, this.other);
        }
    }

    private static class SortEmotesByTypeAndCode
    implements Comparator<Emoticon> {
        private SortEmotesByTypeAndCode() {
        }

        @Override
        public int compare(Emoticon o1, Emoticon o2) {
            int compareType = o1.type.compareTo(o2.type);
            if (compareType != 0) {
                return compareType;
            }
            return o1.code.compareTo(o2.code);
        }
    }

    public static class TagEmote {
        public final String id;
        public final int end;

        public TagEmote(String id, int end) {
            this.id = id;
            this.end = end;
        }

        public String toString() {
            return ">" + this.id + ":" + this.end;
        }
    }

    public static class TagEmotes {
        public final Map<Integer, TagEmote> emotes;

        public TagEmotes(Map<Integer, TagEmote> emotes) {
            this.emotes = emotes;
        }

        public String toString() {
            return this.emotes.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TagEmotes other = (TagEmotes)obj;
            return Objects.equals(this.emotes, other.emotes);
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + Objects.hashCode(this.emotes);
            return hash;
        }

        public int getLargestIndex() {
            if (this.emotes == null || this.emotes.isEmpty()) {
                return -1;
            }
            return Collections.max(this.emotes.keySet());
        }
    }
}

