/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.api.Follower;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FollowerInfo {
    public final Follower.Type type;
    public final List<Follower> followers;
    public final int total;
    public final int totalPoints;
    public final long time;
    public final String stream;
    public final boolean requestError;
    public final String requestErrorDescription;

    public FollowerInfo(Follower.Type type, String stream, List<Follower> followers, int total, int totalPoints) {
        this.type = type;
        this.followers = Collections.unmodifiableList(followers);
        this.total = total;
        this.totalPoints = totalPoints;
        this.time = System.currentTimeMillis();
        this.stream = stream;
        this.requestError = false;
        this.requestErrorDescription = null;
    }

    public FollowerInfo(Follower.Type type, String stream, String error) {
        this.type = type;
        this.followers = null;
        this.total = -1;
        this.totalPoints = -1;
        this.time = System.currentTimeMillis();
        this.stream = stream;
        this.requestError = true;
        this.requestErrorDescription = error;
    }

    public String toString() {
        return this.total + " " + this.followers;
    }

    public Collection<Follower> getNewFollowers() {
        ArrayList<Follower> result = new ArrayList<Follower>();
        for (Follower f : this.followers) {
            if (!f.newFollower) continue;
            result.add(f);
        }
        return result;
    }

    public List<String> getUsernames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Follower f : this.followers) {
            result.add(f.name);
        }
        return result;
    }

    public FollowerInfo replaceFollowers(List<Follower> updatedFollowers) {
        return new FollowerInfo(this.type, this.stream, updatedFollowers, this.total, this.totalPoints);
    }

    public boolean hasFollowers() {
        return this.followers != null && !this.followers.isEmpty();
    }
}

