/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.DateTime;
import chatty.util.Debugging;
import chatty.util.JSONUtil;
import chatty.util.StringUtil;
import chatty.util.api.Follower;
import chatty.util.api.FollowerInfo;
import chatty.util.api.TwitchApi;
import chatty.util.api.TwitchApiResultListener;
import chatty.util.api.UserInfo;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class FollowerManager {
    private static final Logger LOGGER = Logger.getLogger(FollowerManager.class.getName());
    private static final int REQUEST_DELAY = 60;
    private final Map<String, FollowerInfo> cached = new HashMap<String, FollowerInfo>();
    private final Set<String> requested = new HashSet<String>();
    private final Map<String, Map<String, Follower>> alreadyFollowed = new HashMap<String, Map<String, Follower>>();
    private final Map<String, Integer> errors = new HashMap<String, Integer>();
    private static final int CACHED_SINGLE_EXPIRE_TIME = 1800000;
    private final Map<String, Map<String, Follower>> cachedSingle = new HashMap<String, Map<String, Follower>>();
    private final Follower.Type type;
    private final TwitchApi api;
    private final TwitchApiResultListener listener;
    private static final Instant OLD_FOLLOW_API_OFF = ZonedDateTime.of(2023, 8, 3, 0, 0, 0, 0, ZoneId.of("-07:00")).toInstant();

    public FollowerManager(Follower.Type type, TwitchApi api, TwitchApiResultListener listener) {
        this.type = type;
        this.api = api;
        this.listener = listener;
    }

    private boolean hasNewFollowers(List<Follower> followers) {
        return !followers.isEmpty() && followers.get((int)0).newFollower;
    }

    private void error(String stream, int amount) {
        Integer current = this.errors.get(stream);
        if (current == null) {
            current = 0;
        }
        if (current > 10) {
            current = 10;
        }
        this.errors.put(stream, current + amount);
    }

    private void noError(String stream) {
        this.errors.remove(stream);
    }

    protected synchronized void request(String streamName, boolean forceRefresh) {
        if (streamName == null || streamName.isEmpty()) {
            return;
        }
        String stream = StringUtil.toLowerCase(streamName);
        FollowerInfo cachedInfo = this.cached.get(stream);
        if (cachedInfo == null || this.checkTimePassed(cachedInfo) || forceRefresh) {
            this.api.userIDs.getUserIDsAsap(r -> {
                if (!r.hasError()) {
                    String streamId = r.getId(stream);
                    if (this.type == Follower.Type.FOLLOWER) {
                        this.api.requests.requestFollowersNew(streamId, stream);
                    } else if (this.type == Follower.Type.SUBSCRIBER) {
                        this.api.requests.requestSubscribers(streamId, stream);
                    }
                } else {
                    FollowerInfo errorResult = new FollowerInfo(this.type, stream, "Could not resolve id");
                    this.sendResult(this.type, errorResult);
                    this.cached.put(stream, errorResult);
                }
            }, stream);
        } else {
            this.sendResult(this.type, cachedInfo);
        }
    }

    private boolean checkTimePassed(FollowerInfo info) {
        Integer errorCount = this.errors.get(info.stream);
        if (errorCount == null) {
            errorCount = 0;
        }
        return System.currentTimeMillis() - info.time > (long)(60000 + 60000 * errorCount / 2);
    }

    protected void received(int responseCode, String stream, String json) {
        FollowerInfo result = null;
        if (this.type == Follower.Type.FOLLOWER) {
            result = this.parseFollowers(stream, json);
        } else if (this.type == Follower.Type.SUBSCRIBER) {
            result = this.parseSubscribers(stream, json);
        }
        if (result != null) {
            this.addAccountCreationTimes(result, updatedInfo -> this.processResult(updatedInfo.stream, (FollowerInfo)updatedInfo));
        } else {
            this.parseRequestError(responseCode, stream);
        }
    }

    private void addAccountCreationTimes(FollowerInfo info, Consumer<FollowerInfo> resultListener) {
        List<String> usernames = info.getUsernames();
        if (usernames.isEmpty()) {
            resultListener.accept(info);
        } else {
            this.api.userInfoManager.getCached(this, usernames, t -> {
                ArrayList<Follower> updatedFollowers = new ArrayList<Follower>();
                for (Follower f : info.followers) {
                    UserInfo userInfo = (UserInfo)t.get(f.name);
                    if (userInfo != null) {
                        updatedFollowers.add(f.setAccountCreationTime(userInfo.createdAt));
                        continue;
                    }
                    updatedFollowers.add(f);
                }
                FollowerInfo updatedInfo = info.replaceFollowers(updatedFollowers);
                resultListener.accept(updatedInfo);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResult(String stream, FollowerInfo result) {
        FollowerManager followerManager = this;
        synchronized (followerManager) {
            this.noError(stream);
            this.cached.put(stream, result);
            this.requested.add(stream);
        }
        if (this.type == Follower.Type.FOLLOWER) {
            this.listener.receivedFollowers(result);
            if (this.hasNewFollowers(result.followers)) {
                this.listener.newFollowers(result);
            }
        } else if (this.type == Follower.Type.SUBSCRIBER) {
            this.listener.receivedSubscribers(result);
        }
    }

    protected synchronized void receivedSingle(int responseCode, String stream, String json, String username, boolean ownFollow) {
        FollowerInfo followerInfo;
        FollowerInfo followerInfo2 = followerInfo = ownFollow ? this.parseOwnFollow(stream, username, json) : this.parseFollowers(stream, json);
        if (followerInfo != null) {
            if (!this.cachedSingle.containsKey(stream)) {
                this.cachedSingle.put(stream, new HashMap());
            }
            if (followerInfo.followers.isEmpty()) {
                this.listener.receivedFollower(stream, username, TwitchApi.RequestResultCode.NOT_FOUND, null);
                this.cachedSingle.get(stream).put(username, new Follower(this.type, username, null, -1L, -1L, false, false, null, null));
            } else {
                Follower result = followerInfo.followers.get(0);
                this.cachedSingle.get(stream).put(username, result);
                this.listener.receivedFollower(stream, username, TwitchApi.RequestResultCode.SUCCESS, result);
            }
        } else {
            this.listener.receivedFollower(stream, username, TwitchApi.RequestResultCode.FAILED, null);
        }
    }

    private FollowerInfo parseOwnFollow(String stream, String userName, String json) {
        if (json == null) {
            return null;
        }
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            JSONArray data = (JSONArray)root.get("data");
            if (!data.isEmpty()) {
                JSONObject channelFollow = (JSONObject)data.get(0);
                long followedAt = DateTime.parseDatetime((String)channelFollow.get("followed_at"));
                Follower follower = this.createFollowerItem(stream, userName, null, followedAt, -1L, null, null);
                ArrayList<Follower> result = new ArrayList<Follower>();
                result.add(follower);
                return new FollowerInfo(this.type, stream, result, -1, -1);
            }
            return new FollowerInfo(this.type, stream, new ArrayList<Follower>(), -1, -1);
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing " + (Object)((Object)this.type) + ": " + ex);
            return null;
        }
    }

    private FollowerInfo parseFollowers(String stream, String json) {
        ArrayList<Follower> result = new ArrayList<Follower>();
        int total = -1;
        if (json == null) {
            LOGGER.warning((Object)((Object)this.type) + " data null.");
            return null;
        }
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            JSONArray data = (JSONArray)root.get("data");
            for (Object o : data) {
                Follower follower = this.parseFollower(stream, (JSONObject)o);
                if (follower == null) continue;
                result.add(follower);
            }
            total = JSONUtil.getInteger(root, "total", -1);
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing " + (Object)((Object)this.type) + ": " + ex);
            return null;
        }
        return new FollowerInfo(this.type, stream, result, total, -1);
    }

    private Follower parseFollower(String stream, JSONObject data) {
        try {
            String name;
            long followedAt = DateTime.parseDatetime((String)data.get("followed_at"));
            String display_name = JSONUtil.getString(data, "from_name");
            if (display_name == null) {
                display_name = JSONUtil.getString(data, "user_name");
            }
            if ((name = JSONUtil.getString(data, "from_login")) == null) {
                name = JSONUtil.getString(data, "user_login");
            }
            return this.createFollowerItem(stream, name, display_name, followedAt, -1L, null, null);
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing entry of " + (Object)((Object)this.type) + ": " + data + " [" + ex + "]");
            return null;
        }
    }

    private FollowerInfo parseSubscribers(String stream, String json) {
        if (json == null) {
            return null;
        }
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            JSONArray data = (JSONArray)root.get("data");
            ArrayList<Follower> result = new ArrayList<Follower>();
            int total = JSONUtil.getInteger(root, "total", -1);
            int totalPoints = JSONUtil.getInteger(root, "points", -1);
            for (Object o : data) {
                Follower f;
                JSONObject entry = (JSONObject)o;
                String username = JSONUtil.getString(entry, "user_login");
                String display_name = JSONUtil.getString(entry, "user_name");
                String info = "";
                String verboseInfo = "";
                switch (JSONUtil.getString(entry, "tier", "")) {
                    case "1000": {
                        info = info + "T1";
                        break;
                    }
                    case "2000": {
                        info = info + "T2";
                        break;
                    }
                    case "3000": {
                        info = info + "T3";
                    }
                }
                verboseInfo = JSONUtil.getString(entry, "plan_name");
                if (JSONUtil.getBoolean(entry, "is_gift", false)) {
                    info = info + String.format(" (%s)", JSONUtil.getString(entry, "gifter_login"));
                    verboseInfo = verboseInfo + String.format(" (gifted by %s)", JSONUtil.getString(entry, "gifter_login"));
                }
                if ((f = this.createFollowerItem(stream, username, display_name, -1L, -1L, info, verboseInfo)) == null) continue;
                result.add(f);
            }
            return new FollowerInfo(this.type, stream, result, total, totalPoints);
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing subscribers: " + ex);
            return null;
        }
    }

    private synchronized Follower createFollowerItem(String stream, String name, String display_name, long time, long userTime, String info, String verboseInfo) {
        if (name == null) {
            return null;
        }
        if (display_name == null || display_name.trim().isEmpty()) {
            display_name = name;
        }
        if (!this.alreadyFollowed.containsKey(stream = StringUtil.toLowerCase(stream))) {
            this.alreadyFollowed.put(stream, new HashMap());
        }
        Map<String, Follower> entries = this.alreadyFollowed.get(stream);
        Follower existingEntry = entries.get(name);
        boolean refollow = false;
        boolean newFollow = true;
        if (existingEntry != null) {
            newFollow = false;
            if (existingEntry.follow_time != time) {
                refollow = true;
            }
        }
        if (!this.requested.contains(stream)) {
            newFollow = false;
        }
        Follower newEntry = new Follower(this.type, name, display_name, time, userTime, refollow, newFollow, info, verboseInfo);
        if (existingEntry == null) {
            this.alreadyFollowed.get(stream).put(name, newEntry);
        }
        return newEntry;
    }

    private void sendResult(Follower.Type type, FollowerInfo result) {
        if (type == Follower.Type.FOLLOWER) {
            this.listener.receivedFollowers(result);
        } else if (type == Follower.Type.SUBSCRIBER) {
            this.listener.receivedSubscribers(result);
        }
    }

    private synchronized void parseRequestError(int responseCode, String stream) {
        String errorMessage = "";
        if (responseCode == 404) {
            errorMessage = "Channel not found.";
            this.error(stream, 10);
        } else if (responseCode == 200) {
            errorMessage = "Parse error.";
            this.error(stream, 1);
        } else if (responseCode == 401 || responseCode == 403) {
            errorMessage = "Access denied.";
            this.error(stream, 1);
        } else if (responseCode == 422) {
            errorMessage = "No data for this channel.";
            this.error(stream, 10);
        } else {
            errorMessage = "Request error.";
            this.error(stream, 1);
        }
        FollowerInfo errorResult = new FollowerInfo(this.type, stream, errorMessage);
        this.cached.put(stream, errorResult);
        this.sendResult(this.type, errorResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Follower getSingleFollower(String stream, String streamId, String username, String userId, boolean refresh) {
        Follower follower = null;
        FollowerManager followerManager = this;
        synchronized (followerManager) {
            if (this.cachedSingle.containsKey(stream)) {
                follower = this.cachedSingle.get(stream).get(username);
            }
        }
        if (follower != null) {
            if (System.currentTimeMillis() - follower.created_time > 1800000L || refresh) {
                this.requestSingleFollower(stream, streamId, username, userId);
            }
            if (refresh) return null;
            if (follower.follow_time != -1L) return follower;
            this.listener.receivedFollower(stream, username, TwitchApi.RequestResultCode.NOT_FOUND, null);
            return null;
        } else {
            this.requestSingleFollower(stream, streamId, username, userId);
        }
        return null;
    }

    private void requestSingleFollower(String stream, String streamId, String username, String userId) {
        if (streamId != null && userId != null) {
            this.api.requests.getSingleFollowerNew(stream, streamId, username, userId);
        } else {
            this.api.userIDs.getUserIDsAsap(r -> {
                if (r.hasError()) {
                    this.listener.receivedFollower(stream, username, TwitchApi.RequestResultCode.FAILED, null);
                } else {
                    this.api.requests.getSingleFollowerNew(stream, r.getId(stream), username, r.getId(username));
                }
            }, stream, username);
        }
    }

    public static boolean forceNewFollowsApi() {
        return Debugging.isEnabled("newfollowerapi") || Instant.now().isAfter(OLD_FOLLOW_API_OFF);
    }
}

