/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.StringUtil;
import chatty.util.api.CheerEmoticon;
import chatty.util.api.Emoticon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class IgnoredEmotes {
    public static final int CHAT = 1;
    public static final int EMOTE_DIALOG = 2;
    public static final int TAB_COMPLETION = 4;
    public static final int ALL = 7;
    private final Set<Item> items = new HashSet<Item>();

    public void setData(Collection<String> data) {
        this.items.clear();
        for (String input : data) {
            Item parsed = Item.parse(input);
            if (parsed == null || parsed.context <= 0) continue;
            this.items.add(parsed);
        }
    }

    public Collection<String> getData() {
        ArrayList<String> result = new ArrayList<String>();
        this.items.forEach(item -> result.add(item.toString()));
        return result;
    }

    public String add(Emoticon emote, int context) {
        this.remove(emote);
        Item item = Item.create(emote, context);
        if (item.context > 0) {
            this.items.add(item);
        }
        return item.toString();
    }

    public List<Item> getMatches(Emoticon emote) {
        ArrayList<Item> result = new ArrayList<Item>();
        for (Item item : this.items) {
            if (!item.matches(emote, 0)) continue;
            result.add(item);
        }
        return result;
    }

    public boolean remove(Emoticon emote) {
        return this.items.removeIf(item -> item.matches(emote, 0));
    }

    public boolean isIgnored(Emoticon emote, int context) {
        for (Item item : this.items) {
            if (!item.matches(emote, context)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        Item item = Item.parse("abc type:ffz in:c");
        System.out.println(item);
        Emoticon emote = new Emoticon.Builder(Emoticon.Type.FFZ, "abc").build();
        System.out.println(item.matches(emote, 1));
        System.out.println(Item.create(emote, 0));
    }

    public static class Item {
        public final String code;
        public final String id;
        public final Emoticon.Type type;
        public final int context;

        public static Item parse(String input) {
            String[] split;
            String id = null;
            Emoticon.Type type = null;
            String code = null;
            int context = 7;
            for (String item : split = input.split(" ")) {
                int prefixStart = item.indexOf(":");
                if (prefixStart > 0 && prefixStart + 1 < item.length()) {
                    String prefix = item.substring(0, prefixStart);
                    String value = item.substring(prefixStart + 1);
                    switch (prefix) {
                        case "id": {
                            id = value;
                            break;
                        }
                        case "type": {
                            type = Item.getType(value);
                            break;
                        }
                        case "for": {
                            context = Item.getContext(value);
                        }
                    }
                    continue;
                }
                code = item;
            }
            if (id != null || code != null) {
                return new Item(code, type, id, context);
            }
            return null;
        }

        public static Item create(Emoticon emote, int context) {
            String code = emote.code;
            if (emote instanceof CheerEmoticon) {
                code = ((CheerEmoticon)emote).getSimpleCode();
            }
            return new Item(code, emote.type, emote.stringId, context);
        }

        private static Emoticon.Type getType(String value) {
            for (Emoticon.Type type : Emoticon.Type.values()) {
                if (!value.equalsIgnoreCase(type.id)) continue;
                return type;
            }
            return null;
        }

        private static int getContext(String value) {
            int result = 0;
            if (value.contains("c")) {
                ++result;
            }
            if (value.contains("t")) {
                result += 4;
            }
            if (value.contains("d")) {
                result += 2;
            }
            return result;
        }

        private static String fromContext(int in) {
            if (in == 7) {
                return null;
            }
            if (in == 0) {
                return "0";
            }
            String result = "";
            if ((in & 1) != 0) {
                result = result + "c";
            }
            if ((in & 4) != 0) {
                result = result + "t";
            }
            if ((in & 2) != 0) {
                result = result + "d";
            }
            return result;
        }

        private Item(String code, Emoticon.Type type, String id, int context) {
            this.code = code;
            this.type = type;
            this.id = id;
            this.context = context;
        }

        public boolean matches(Emoticon emote, int context) {
            if (context > 0 && (this.context & context) == 0) {
                return false;
            }
            if (this.type != null && this.type != emote.type) {
                return false;
            }
            if (!(this.id == null || emote.stringId != null && emote.stringId.equals(this.id))) {
                return false;
            }
            if (emote instanceof CheerEmoticon) {
                return this.code != null && ((CheerEmoticon)emote).getSimpleCode().equals(this.code);
            }
            return this.code != null && this.code.equals(emote.code);
        }

        public String toString() {
            String result = this.code != null ? this.code : "";
            result = StringUtil.append(result, " ", "for:", Item.fromContext(this.context));
            result = StringUtil.append(result, " ", "type:", this.type != null ? this.type.id : null);
            result = StringUtil.append(result, " ", "id:", this.id);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            if (this.context != other.context) {
                return false;
            }
            if (!Objects.equals(this.code, other.code)) {
                return false;
            }
            if (!Objects.equals(this.id, other.id)) {
                return false;
            }
            return this.type == other.type;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.code);
            hash = 97 * hash + Objects.hashCode(this.id);
            hash = 97 * hash + Objects.hashCode((Object)this.type);
            hash = 97 * hash + this.context;
            return hash;
        }
    }
}

