/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.gui.MainGui;
import chatty.gui.components.LinkLabel;
import chatty.util.api.Emoticon;
import chatty.util.settings.AdvancedSetting;
import chatty.util.settings.Settings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;

public class LocalEmotesSetting
extends AdvancedSetting<Emoticon> {
    private final MainGui gui;

    public LocalEmotesSetting(Settings settings, MainGui gui) {
        super(settings, "localEmotes", false);
        this.gui = gui;
    }

    @Override
    public Emoticon toObject(Object input) {
        List list = (List)input;
        String emoteId = (String)list.get(0);
        String emoteCode = (String)list.get(1);
        return this.createEmote(emoteId, emoteCode);
    }

    @Override
    public Object fromObject(Emoticon emote) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(emote.stringId);
        result.add(emote.code);
        return result;
    }

    private Emoticon createEmote(String id, String code) {
        Emoticon.Builder b = new Emoticon.Builder(Emoticon.Type.CUSTOM2, code);
        b.setStringId(id);
        return b.build();
    }

    @Override
    public void add(Emoticon emote) {
        this.add((Set<Emoticon>)new HashSet<Emoticon>(Arrays.asList(emote)));
    }

    @Override
    public void remove(Emoticon emote) {
        this.remove((Set<Emoticon>)new HashSet<Emoticon>(Arrays.asList(emote)));
    }

    @Override
    public void add(Set<Emoticon> emotes) {
        if (this.checkAction("Add", emotes)) {
            for (Emoticon emote : emotes) {
                super.setAdd(this.createEmote(emote.stringId, emote.code));
            }
            this.notifyChanges();
        }
    }

    @Override
    public void remove(Set<Emoticon> emotes) {
        if (this.checkAction("Remove", emotes)) {
            for (Emoticon emote : emotes) {
                super.remove(this.createEmote(emote.stringId, emote.code));
            }
            this.notifyChanges();
        }
    }

    @Override
    public void setData(Collection<Emoticon> data) {
        super.setData(data);
        this.notifyChanges();
    }

    private boolean checkAction(String action, Collection<Emoticon> emotes) {
        LinkLabel label = new LinkLabel(String.format("%s %d Local Emotes?<br /><br />(Read help: [help-settings:EmoticonsLocal Local Emotes])", action, emotes.size()), this.gui.getLinkLabelListener());
        int result = JOptionPane.showConfirmDialog(this.gui, label, "Local Emotes", 0);
        return result == 0;
    }
}

