/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.DateTime;
import chatty.util.JSONUtil;
import chatty.util.StringUtil;
import chatty.util.api.StreamCategory;
import chatty.util.api.TokenInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Parsing {
    private static final Logger LOGGER = Logger.getLogger(Parsing.class.getName());

    public static Set<StreamCategory> parseCategorySearch(String json) {
        HashSet<StreamCategory> result = new HashSet<StreamCategory>();
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            Object data = root.get("data");
            if (!(data instanceof JSONArray)) {
                LOGGER.warning("Error parsing game search: Should be array");
                return null;
            }
            for (Object obj : (JSONArray)data) {
                if (!(obj instanceof JSONObject)) continue;
                JSONObject categoryData = (JSONObject)obj;
                String id = JSONUtil.getString(categoryData, "id");
                String name = JSONUtil.getString(categoryData, "name");
                if (StringUtil.isNullOrEmpty(id, name)) continue;
                result.add(new StreamCategory(id, name));
            }
            return result;
        }
        catch (ParseException ex) {
            LOGGER.warning("Error parsing game search.");
            return null;
        }
        catch (NullPointerException ex) {
            LOGGER.warning("Error parsing game search: Unexpected null");
            return null;
        }
        catch (ClassCastException ex) {
            LOGGER.warning("Error parsing game search: Unexpected type");
            return null;
        }
    }

    public static long followGetTime(String json) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            long time = DateTime.parseDatetime((String)root.get("created_at"));
            return time;
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    public static TokenInfo parseVerifyToken(String json) {
        if (json == null) {
            LOGGER.warning("Error parsing verify token result (null)");
            return null;
        }
        try {
            JSONParser parser = new JSONParser();
            JSONObject token = (JSONObject)parser.parse(json);
            String username = (String)token.get("login");
            String id = (String)token.get("user_id");
            String client_id = JSONUtil.getString(token, "client_id");
            JSONArray scopes = (JSONArray)token.get("scopes");
            long expiresIn = JSONUtil.getLong(token, "expires_in", -1L);
            return new TokenInfo(username, id, client_id, scopes, expiresIn);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String parseModerators(String json, String type) {
        try {
            ArrayList<String> moderators = new ArrayList<String>();
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            JSONArray data = (JSONArray)root.get("data");
            for (Object o : data) {
                JSONObject entry = (JSONObject)o;
                moderators.add(JSONUtil.getString(entry, "user_login"));
            }
            if (moderators.isEmpty()) {
                return "There are no " + type + " for this channel.";
            }
            return String.format("There are %d %s for this channel%s: %s", moderators.size(), type, moderators.size() == 100 ? " (limit reached, there may be more)" : "", StringUtil.join(moderators, ", "));
        }
        catch (ParseException ex) {
            LOGGER.warning("Error parsing " + type + ": " + ex);
            return null;
        }
    }

    public static String getClipUrl(String text) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(text);
            JSONObject data = (JSONObject)((JSONArray)root.get("data")).get(0);
            return (String)data.get("edit_url");
        }
        catch (Exception ex) {
            LOGGER.warning("Error getting clip url: " + ex);
            return null;
        }
    }

    public static class ShieldModeStatus {
        public final String stream;
        public final boolean enabled;

        public ShieldModeStatus(String stream, boolean enabled) {
            this.stream = stream;
            this.enabled = enabled;
        }

        public static ShieldModeStatus decode(String json, String stream) {
            if (json == null) {
                return null;
            }
            try {
                JSONParser parser = new JSONParser();
                JSONObject root = (JSONObject)parser.parse(json);
                JSONObject data = (JSONObject)((JSONArray)root.get("data")).get(0);
                if (data.containsKey("is_active")) {
                    return new ShieldModeStatus(stream, JSONUtil.getBoolean(data, "is_active", false));
                }
            }
            catch (Exception ex) {
                LOGGER.warning("Error parsing shield mode status: " + ex);
            }
            return null;
        }
    }
}

