/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.Helper;
import chatty.lang.Language;
import chatty.util.Debugging;
import chatty.util.JSONUtil;
import chatty.util.StringUtil;
import chatty.util.api.AccessChecker;
import chatty.util.api.BlockedTermsManager;
import chatty.util.api.ChannelStatus;
import chatty.util.api.EmoticonParsing;
import chatty.util.api.EmoticonUpdate;
import chatty.util.api.FollowerManager;
import chatty.util.api.Parsing;
import chatty.util.api.ResultManager;
import chatty.util.api.SendMessageResult;
import chatty.util.api.StreamCategory;
import chatty.util.api.StreamInfo;
import chatty.util.api.StreamLabels;
import chatty.util.api.TokenInfo;
import chatty.util.api.TwitchApi;
import chatty.util.api.TwitchApiRequest;
import chatty.util.api.TwitchApiResultListener;
import chatty.util.api.UserInfo;
import chatty.util.api.UserInfoManager;
import chatty.util.api.eventsub.EventSubAddResult;
import chatty.util.api.eventsub.EventSubSubs;
import chatty.util.api.queue.QueuedApi;
import chatty.util.api.queue.ResultListener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Requests {
    private static final Logger LOGGER = Logger.getLogger(Requests.class.getName());
    private final ExecutorService executor;
    private final TwitchApi api;
    private final QueuedApi newApi;
    private final TwitchApiResultListener listener;
    private final Set<String> pendingRequest = new HashSet<String>();

    public Requests(TwitchApi api, TwitchApiResultListener listener) {
        this.executor = Executors.newCachedThreadPool();
        this.api = api;
        this.listener = listener;
        this.newApi = new QueuedApi();
    }

    protected void requestFollowers(String streamId, String stream) {
        String url = String.format("https://api.twitch.tv/helix/users/follows?to_id=%s&first=100", streamId);
        this.newApi.add(url, "GET", this.api.defaultToken, r -> this.api.followerManager.received(r.responseCode, stream, r.text));
    }

    public void requestFollowersNew(String streamId, String stream) {
        boolean modAccess = AccessChecker.isModerator(Helper.toChannel(stream), TokenInfo.Scope.CHANNEL_FOLLOWERS);
        if (!modAccess && !FollowerManager.forceNewFollowsApi()) {
            this.requestFollowers(streamId, stream);
            return;
        }
        String url = Requests.makeUrl("https://api.twitch.tv/helix/channels/followers", "broadcaster_id", streamId, "first", "100");
        this.newApi.add(url, "GET", this.api.defaultToken, r -> this.api.followerManager.received(r.responseCode, stream, r.text));
    }

    protected void requestSubscribers(String streamId, String stream) {
        String url = String.format("https://api.twitch.tv/helix/subscriptions?broadcaster_id=%s&first=100", streamId);
        this.newApi.add(url, "GET", this.api.defaultToken, r -> this.api.subscriberManager.received(r.responseCode, stream, r.text));
    }

    public void getChannelStatus(String streamId, String stream) {
        String url = "https://api.twitch.tv/helix/channels?broadcaster_id=" + streamId;
        this.newApi.add(url, "GET", this.api.defaultToken, r -> {
            if (r.responseCode == 200) {
                List<ChannelStatus> parsed = ChannelStatus.parseJson(r.text);
                if (parsed != null && parsed.size() > 0) {
                    ChannelStatus status = parsed.get(0);
                    this.listener.receivedChannelStatus(status, TwitchApi.RequestResultCode.SUCCESS);
                    if (status.hasCategoryId()) {
                        this.api.resultManager.inform(ResultManager.Type.CATEGORY_RESULT, l -> l.result(Arrays.asList(status.category)));
                    }
                } else {
                    this.listener.receivedChannelStatus(ChannelStatus.createInvalid(streamId, stream), TwitchApi.RequestResultCode.NOT_FOUND);
                }
            } else {
                this.listener.receivedChannelStatus(ChannelStatus.createInvalid(streamId, stream), TwitchApi.RequestResultCode.UNKNOWN);
            }
        });
    }

    protected void requestFollowedStreams(String token, String cursor) {
        String url = String.format(Locale.ROOT, "https://api.twitch.tv/helix/streams/followed?user_id=%s&first=%d", this.api.localUserId, 100);
        if (!StringUtil.isNullOrEmpty(cursor)) {
            url = url + "&after=" + cursor;
        }
        this.newApi.add(url, "GET", this.api.defaultToken, r -> this.api.streamInfoManager.requestResultFollows(r.text, r.responseCode));
    }

    protected void requestStreamInfo(String stream) {
        String url = "https://api.twitch.tv/helix/streams?first=100&user_login=" + stream;
        this.newApi.add(url, "GET", this.api.defaultToken, r -> this.api.streamInfoManager.requestResult(r.text, r.responseCode, stream));
    }

    protected void requestStreamsInfo(Set<String> streams, Set<StreamInfo> expected) {
        String url = "https://api.twitch.tv/helix/streams?first=100&" + Requests.makeNewApiParameters("user_login", streams);
        this.newApi.add(url, "GET", this.api.defaultToken, r -> this.api.streamInfoManager.requestResultStreams(r.text, r.responseCode, expected));
    }

    public void verifyToken(String token) {
        String url = "https://id.twitch.tv/oauth2/validate";
        TwitchApiRequest request = new TwitchApiRequest(url, null);
        request.setToken(token);
        this.execute(request, r -> {
            if (r.responseCode == 200) {
                TokenInfo tokenInfo = Parsing.parseVerifyToken(r.text);
                this.listener.tokenVerified(token, tokenInfo);
            } else if (r.responseCode == 401) {
                this.listener.tokenVerified(token, new TokenInfo());
            } else {
                this.listener.tokenVerified(token, null);
            }
        });
    }

    public void revokeToken(String token) {
        String url = "https://id.twitch.tv/oauth2/revoke?client_id=spyiu9jqdnfjtwv6l1xjk5zgt8qb91l&token=" + token;
        TwitchApiRequest request = new TwitchApiRequest(url, "v5");
        request.setRequestType("POST");
        request.setToken(token);
        this.execute(request, r -> {
            if (r.responseCode != 200) {
                this.listener.tokenRevoked("Failed to revoke token (" + r.responseCode + ")");
            } else {
                this.listener.tokenRevoked(null);
            }
        });
    }

    public void requestUserInfo(Set<String> usernames) {
        String url = "https://api.twitch.tv/helix/users?" + Requests.makeNewApiParameters("login", usernames);
        this.newApi.add(url, "GET", this.api.defaultToken, r -> {
            Collection<UserInfo> parsedResult = UserInfoManager.parseJSON(r.text);
            HashMap<String, String> ids = null;
            if (parsedResult != null) {
                ids = new HashMap<String, String>();
                for (UserInfo info : parsedResult) {
                    ids.put(info.login, info.id);
                }
            }
            this.api.userInfoManager.resultReceived(usernames, parsedResult);
            this.api.userIDs.handleRequestResult(usernames, ids);
        });
    }

    public void requestUserIDs(Set<String> usernames) {
        this.requestUserInfo(usernames);
    }

    public void requestUserInfoById(Set<String> requestedIds) {
        String url = "https://api.twitch.tv/helix/users?" + Requests.makeNewApiParameters("id", requestedIds);
        this.newApi.add(url, "GET", this.api.defaultToken, r -> {
            Collection<UserInfo> parsedResult = UserInfoManager.parseJSON(r.text);
            HashMap<String, String> ids = null;
            Set<String> usernames = new HashSet<String>();
            if (parsedResult != null) {
                ids = new HashMap<String, String>();
                for (UserInfo info : parsedResult) {
                    ids.put(info.login, info.id);
                }
                usernames = ids.keySet();
            }
            this.api.userInfoManager.idResultReceived(requestedIds, parsedResult);
            this.api.userIDs.handleRequestResult(usernames, ids);
        });
    }

    public void getSingleFollower(String stream, String streamID, String user, String userID) {
        if (StringUtil.isNullOrEmpty(stream, user, streamID, userID)) {
            return;
        }
        String url = String.format("https://api.twitch.tv/helix/users/follows?from_id=%s&to_id=%s", userID, streamID);
        this.newApi.add(url, "GET", this.api.defaultToken, r -> this.api.followerManager.receivedSingle(r.responseCode, stream, r.text, user, false));
    }

    public void getSingleFollowerNew(String stream, String streamID, String user, String userID) {
        boolean modAccess = AccessChecker.isModerator(Helper.toChannel(stream), TokenInfo.Scope.CHANNEL_FOLLOWERS);
        if (!modAccess && !FollowerManager.forceNewFollowsApi()) {
            this.getSingleFollower(stream, streamID, user, userID);
            return;
        }
        if (StringUtil.isNullOrEmpty(stream, user, streamID, userID)) {
            return;
        }
        if (userID.equals(this.api.localUserId)) {
            this.getSingleOwnFollow(stream, streamID, user, userID);
            return;
        }
        if (!modAccess) {
            return;
        }
        String url = Requests.makeUrl("https://api.twitch.tv/helix/channels/followers", "broadcaster_id", streamID, "user_id", userID);
        this.newApi.add(url, "GET", this.api.defaultToken, r -> this.api.followerManager.receivedSingle(r.responseCode, stream, r.text, user, false));
    }

    public void getSingleOwnFollow(String stream, String streamID, String user, String userID) {
        if (StringUtil.isNullOrEmpty(stream, user, streamID, userID)) {
            return;
        }
        String url = Requests.makeUrl("https://api.twitch.tv/helix/channels/followed", "broadcaster_id", streamID, "user_id", userID);
        this.newApi.add(url, "GET", this.api.defaultToken, r -> this.api.followerManager.receivedSingle(r.responseCode, stream, r.text, user, true));
    }

    public void putChannelInfoNew(String userId, ChannelStatus info, String token) {
        if (info == null || info.channelLogin == null) {
            return;
        }
        String url = "https://api.twitch.tv/helix/channels?broadcaster_id=" + userId;
        this.newApi.add(url, "PATCH", info.makePutJson(), token, r -> {
            switch (r.responseCode) {
                case 204: {
                    this.listener.putChannelInfoResult(TwitchApi.RequestResultCode.SUCCESS, null);
                    break;
                }
                case 401: 
                case 403: {
                    this.listener.putChannelInfoResult(TwitchApi.RequestResultCode.ACCESS_DENIED, Requests.getErrorMessage(r.errorText));
                    break;
                }
                default: {
                    this.listener.putChannelInfoResult(TwitchApi.RequestResultCode.FAILED, Requests.getErrorMessage(r.errorText));
                }
            }
        });
    }

    public void getContentLabels() {
        this.newApi.add("https://api.twitch.tv/helix/content_classification_labels", "GET", this.api.defaultToken, r -> {
            if (r.responseCode == 200) {
                StreamLabels.dataReceived(r.text);
            }
        });
    }

    public void getGameSearch(String game, ResultManager.CategoryResult listener) {
        if (game == null || game.isEmpty()) {
            return;
        }
        String encodedGame = "";
        try {
            encodedGame = URLEncoder.encode(game, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(TwitchApi.class.getName()).log(Level.SEVERE, null, ex);
        }
        String url = "https://api.twitch.tv/helix/search/categories?query=" + encodedGame;
        this.newApi.add(url, "GET", this.api.defaultToken, r -> {
            Set<StreamCategory> categories;
            if (r.text != null && (categories = Parsing.parseCategorySearch(r.text)) != null) {
                listener.result(categories);
                this.api.resultManager.inform(ResultManager.Type.CATEGORY_RESULT, l -> l.result(categories));
            }
        });
    }

    public void runCommercial(String userId, String stream, int length) {
        String url = "https://api.twitch.tv/helix/channels/commercial";
        String json = JSONUtil.listMapToJSON("broadcaster_id", userId, "length", length);
        this.newApi.add(url, "POST", json, this.api.defaultToken, r -> {
            String resultText = "Failed to start commercial (error " + r.responseCode + ")";
            TwitchApi.RequestResultCode resultCode = TwitchApi.RequestResultCode.UNKNOWN;
            if (r.responseCode == 204 || r.responseCode == 200) {
                resultText = "Running commercial..";
                resultCode = TwitchApi.RequestResultCode.RUNNING_COMMERCIAL;
            }
            this.listener.runCommercialResult(stream, resultText, resultCode);
        });
    }

    public void autoMod(TwitchApi.AutoModAction action, String msgId, String token, String localUserId) {
        String url = "https://api.twitch.tv/helix/moderation/automod/message";
        String json = JSONUtil.listMapToJSON("user_id", localUserId, "msg_id", msgId, "action", action == TwitchApi.AutoModAction.ALLOW ? "ALLOW" : "DENY");
        this.newApi.add(url, "POST", json, token, r -> {
            boolean handled = false;
            for (TwitchApi.AutoModActionResult result : TwitchApi.AutoModActionResult.values()) {
                if (r.responseCode != result.responseCode) continue;
                this.listener.autoModResult(action, msgId, result);
                handled = true;
            }
            if (!handled) {
                this.listener.autoModResult(action, msgId, TwitchApi.AutoModActionResult.OTHER_ERROR);
            }
        });
    }

    public void getBlockedTerms(String streamId, String login, String cursor) {
        String url = String.format(Locale.ROOT, "https://api.twitch.tv/helix/moderation/blocked_terms?broadcaster_id=%s&moderator_id=%s&first=%d", streamId, this.api.localUserId, 100);
        if (!StringUtil.isNullOrEmpty(cursor)) {
            url = url + "&after=" + cursor;
        }
        this.newApi.add(url, "GET", this.api.defaultToken, r -> this.api.blockedTermsManager.resultReceived(streamId, login, r.text, r.responseCode));
    }

    public void addBlockedTerm(String streamId, String streamName, String text, Consumer<BlockedTermsManager.BlockedTerm> listener) {
        String url = String.format("https://api.twitch.tv/helix/moderation/blocked_terms?broadcaster_id=%s&moderator_id=%s", streamId, this.api.localUserId);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("text", text);
        this.newApi.add(url, "POST", data, this.api.defaultToken, r -> {
            BlockedTermsManager.BlockedTerms parsed = BlockedTermsManager.BlockedTerms.parse(r.text, streamId, streamName);
            if (parsed != null && !parsed.hasError() && parsed.data.size() == 1) {
                listener.accept(parsed.data.get(0));
            } else {
                listener.accept(null);
            }
        });
    }

    public void removeBlockedTerm(BlockedTermsManager.BlockedTerm term, Consumer<BlockedTermsManager.BlockedTerm> listener) {
        String url = String.format("https://api.twitch.tv/helix/moderation/blocked_terms?broadcaster_id=%s&moderator_id=%s&id=%s", term.streamId, this.api.localUserId, term.id);
        this.newApi.add(url, "DELETE", this.api.defaultToken, r -> {
            if (r.responseCode == 204) {
                listener.accept(term);
            } else {
                listener.accept(null);
            }
        });
    }

    public void createStreamMarker(String userId, String description, String token, TwitchApi.StreamMarkerResult listener) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("user_id", userId);
        if (description != null && !description.isEmpty()) {
            data.put("description", description);
        }
        this.newApi.add("https://api.twitch.tv/helix/streams/markers", "POST", data, token, r -> {
            switch (r.responseCode) {
                case 200: {
                    listener.streamMarkerResult(null);
                    break;
                }
                case 401: {
                    listener.streamMarkerResult("Required access not available (please check <Main - Login..> for 'Edit broadcast')");
                    break;
                }
                case 404: {
                    listener.streamMarkerResult("No stream");
                    break;
                }
                case 403: {
                    listener.streamMarkerResult("Access denied");
                    break;
                }
                default: {
                    listener.streamMarkerResult("Unknown error (" + r.responseCode + ")");
                }
            }
        });
    }

    public void createClip(String userId) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/clips", "broadcaster_id", userId);
        this.newApi.add(url, "POST", this.api.defaultToken, r -> {
            String error = null;
            if (r.responseCode == 202) {
                String editUrl = Parsing.getClipUrl(r.text);
                if (editUrl != null) {
                    String viewUrl = editUrl.replace("/edit", "");
                    this.api.resultManager.inform(ResultManager.Type.CREATE_CLIP, l -> l.result(editUrl, viewUrl, null));
                } else {
                    error = "Error creating clip";
                }
            } else {
                String errorMsg;
                error = r.responseCode == 401 ? "Creating clip failed: Check access under 'Main - Account'" : ((errorMsg = Requests.getErrorMessage(r.text)) != null ? errorMsg : "Creating clip failed");
            }
            if (error != null) {
                String error2 = error;
                this.api.resultManager.inform(ResultManager.Type.CREATE_CLIP, l -> l.result(null, null, error2));
            }
        });
    }

    public void sendAnnouncement(String streamId, String message, String color) {
        String url = String.format("https://api.twitch.tv/helix/chat/announcements?broadcaster_id=%s&moderator_id=%s", streamId, this.api.localUserId);
        if (StringUtil.isNullOrEmpty(color)) {
            color = "primary";
        }
        String json = JSONUtil.listMapToJSON("message", message, "color", StringUtil.toLowerCase(color));
        this.newApi.add(url, "POST", json, this.api.defaultToken, r -> {
            if (r.responseCode != 204) {
                if (r.responseCode == 400) {
                    this.listener.errorMessage("Invalid announcement message or color");
                } else if (r.responseCode == 401) {
                    this.listener.errorMessage("Announcement access denied (check 'Main - Account' for access)");
                } else {
                    this.listener.errorMessage(String.format("Sending announcement failed (%d)", r.responseCode));
                }
            }
        });
    }

    public void ban(String streamId, String targetId, int length, String reason, TwitchApi.SimpleRequestResultListener listener) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/moderation/bans", "broadcaster_id", streamId, "moderator_id", this.api.localUserId);
        JSONObject data = new JSONObject();
        data.put("user_id", targetId);
        data.put("reason", reason);
        if (length > 0) {
            data.put("duration", length);
        }
        JSONObject json = new JSONObject();
        json.put("data", data);
        this.newApi.add(url, "POST", json.toJSONString(), this.api.defaultToken, r -> Requests.handleResult(r, listener));
    }

    public void unban(String streamId, String targetId, TwitchApi.SimpleRequestResultListener listener) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/moderation/bans", "broadcaster_id", streamId, "moderator_id", this.api.localUserId, "user_id", targetId);
        this.newApi.add(url, "DELETE", this.api.defaultToken, r -> Requests.handleResult(r, listener));
    }

    public void deleteMsg(String streamId, String msgId, TwitchApi.SimpleRequestResultListener listener) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/moderation/chat", "broadcaster_id", streamId, "moderator_id", this.api.localUserId);
        if (!StringUtil.isNullOrEmpty(msgId)) {
            url = url + "&message_id=" + msgId;
        }
        this.newApi.add(url, "DELETE", this.api.defaultToken, r -> Requests.handleResult(r, listener));
    }

    public void shoutout(String streamId, String targetId, TwitchApi.SimpleRequestResultListener listener) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/chat/shoutouts", "from_broadcaster_id", streamId, "moderator_id", this.api.localUserId, "to_broadcaster_id", targetId);
        this.newApi.add(url, "POST", this.api.defaultToken, r -> Requests.handleResult(r, listener));
    }

    public void warn(String streamId, String targetId, String reason, TwitchApi.SimpleRequestResultListener listener) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/moderation/warnings", "broadcaster_id", streamId, "moderator_id", this.api.localUserId);
        JSONObject data = new JSONObject();
        data.put("user_id", targetId);
        data.put("reason", reason);
        JSONObject json = new JSONObject();
        json.put("data", data);
        this.newApi.add(url, "POST", json.toJSONString(), this.api.defaultToken, r -> Requests.handleResult(r, listener));
    }

    public void setVip(String streamId, String targetId, boolean add, TwitchApi.SimpleRequestResultListener listener) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/channels/vips", "broadcaster_id", streamId, "user_id", targetId);
        this.newApi.add(url, add ? "POST" : "DELETE", this.api.defaultToken, r -> Requests.handleResult(r, listener));
    }

    public void setModerator(String streamId, String targetId, boolean add, TwitchApi.SimpleRequestResultListener listener) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/moderation/moderators", "broadcaster_id", streamId, "user_id", targetId);
        this.newApi.add(url, add ? "POST" : "DELETE", this.api.defaultToken, r -> Requests.handleResult(r, listener));
    }

    public void getModerators(String streamId, TwitchApi.SimpleRequestResultListener listener) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/moderation/moderators", "broadcaster_id", streamId, "first", "100");
        this.newApi.add(url, "GET", this.api.defaultToken, r -> Requests.handleModerators(r, listener, "moderators"));
    }

    public void getVips(String streamId, TwitchApi.SimpleRequestResultListener listener) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/channels/vips", "broadcaster_id", streamId, "first", "100");
        this.newApi.add(url, "GET", this.api.defaultToken, r -> Requests.handleModerators(r, listener, "VIPs"));
    }

    private static void handleModerators(ResultListener.Result r, TwitchApi.SimpleRequestResultListener listener, String type) {
        if (r.text != null) {
            String result = Parsing.parseModerators(r.text, type);
            if (result == null) {
                listener.accept(TwitchApi.SimpleRequestResult.error("Error parsing list"));
            } else {
                listener.accept(TwitchApi.SimpleRequestResult.result(result));
            }
        } else {
            Requests.handleResult(r, listener);
        }
    }

    public void startRaid(String streamId, String targetId, TwitchApi.SimpleRequestResultListener listener) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/raids", "from_broadcaster_id", streamId, "to_broadcaster_id", targetId);
        this.newApi.add(url, "POST", this.api.defaultToken, r -> Requests.handleResult(r, listener));
    }

    public void cancelRaid(String streamId, TwitchApi.SimpleRequestResultListener listener) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/raids", "broadcaster_id", streamId);
        this.newApi.add(url, "DELETE", this.api.defaultToken, r -> Requests.handleResult(r, listener));
    }

    public void whisper(String targetId, String msg, TwitchApi.SimpleRequestResultListener listener) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/whispers", "from_user_id", this.api.localUserId, "to_user_id", targetId);
        String json = JSONUtil.listMapToJSON("message", msg);
        this.newApi.add(url, "POST", json, this.api.defaultToken, r -> Requests.handleResult(r, listener));
    }

    public void updateChatSettings(String streamId, Object[] data, TwitchApi.SimpleRequestResultListener listener) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/chat/settings", "broadcaster_id", streamId, "moderator_id", this.api.localUserId);
        String json = JSONUtil.listMapToJSON(data);
        this.newApi.add(url, "PATCH", json, this.api.defaultToken, r -> Requests.handleResult(r, listener));
    }

    public void setColor(String color, TwitchApi.SimpleRequestResultListener listener) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/chat/color", "user_id", this.api.localUserId, "color", Requests.makeColor(color));
        this.newApi.add(url, "PUT", this.api.defaultToken, r -> Requests.handleResult(r, listener));
    }

    private static String makeColor(String color) {
        switch (color = StringUtil.toLowerCase(color)) {
            case "dodgerblue": {
                return "dodger_blue";
            }
            case "springgreen": {
                return "spring_green";
            }
            case "yellowgreen": {
                return "yellow_green";
            }
            case "orangered": {
                return "orange_red";
            }
            case "goldenrod": {
                return "golden_rod";
            }
            case "hotpink": {
                return "hot_pink";
            }
            case "cadetblue": {
                return "cadet_blue";
            }
            case "seagreen": {
                return "sea_green";
            }
            case "blueviolet": {
                return "blue_violet";
            }
        }
        return color;
    }

    public void setShieldMode(String stream, String streamId, boolean enabled, TwitchApi.SimpleRequestResultListener listener) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/moderation/shield_mode", "broadcaster_id", streamId, "moderator_id", this.api.localUserId);
        JSONObject data = new JSONObject();
        data.put("is_active", enabled);
        this.newApi.add(url, "PUT", data.toJSONString(), this.api.defaultToken, r -> {
            Requests.handleResult(r, listener);
            Parsing.ShieldModeStatus status = Parsing.ShieldModeStatus.decode(r.text, stream);
            if (status != null) {
                this.api.resultManager.inform(ResultManager.Type.SHIELD_MODE_RESULT, l -> l.result(status.stream, status.enabled));
            }
        });
    }

    public void getShieldMode(String stream, String streamId, String requestId) {
        String url = Requests.makeUrl("https://api.twitch.tv/helix/moderation/shield_mode", "broadcaster_id", streamId, "moderator_id", this.api.localUserId);
        this.newApi.add(url, "GET", this.api.defaultToken, r -> {
            Parsing.ShieldModeStatus status = Parsing.ShieldModeStatus.decode(r.text, stream);
            if (status != null) {
                this.api.resultManager.inform(ResultManager.Type.SHIELD_MODE_RESULT, l -> l.result(status.stream, status.enabled));
            }
            switch (r.responseCode) {
                case 200: {
                    this.api.setReceived(requestId);
                    break;
                }
                case 404: {
                    this.api.setNotFound(requestId);
                    break;
                }
                default: {
                    this.api.setError(requestId);
                }
            }
        });
    }

    private static void handleResult(ResultListener.Result r, TwitchApi.SimpleRequestResultListener listener) {
        if (String.valueOf(r.responseCode).startsWith("2")) {
            listener.accept(TwitchApi.SimpleRequestResult.ok());
        } else if (!StringUtil.isNullOrEmpty(Requests.getErrorMessage(r.errorText))) {
            String msg = Requests.getErrorMessage(r.errorText);
            String scopeMissingMsg = Requests.checkForMissingScope(msg);
            if (scopeMissingMsg != null) {
                msg = scopeMissingMsg;
            }
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("The ID in broadcaster_id must match the user ID found in the request's OAuth token.", "Access only for broadcaster.");
            replace.put("is already banned", "Already banned.");
            replace.put("is not banned", "Not banned.");
            replace.put("may not be banned", "Can't be banned.");
            for (Map.Entry entry : replace.entrySet()) {
                if (!msg.contains((CharSequence)entry.getKey())) continue;
                msg = (String)entry.getValue();
                break;
            }
            if (Debugging.isEnabled("errormsg")) {
                LOGGER.info(String.format("Code: %s Error: %s Output: %s", r.responseCode, r.errorText, msg));
            }
            listener.accept(TwitchApi.SimpleRequestResult.error(msg));
        } else {
            listener.accept(TwitchApi.SimpleRequestResult.error(String.format("Error (%d)", r.responseCode)));
        }
    }

    private static String checkForMissingScope(String msg) {
        String scopeString;
        TokenInfo.Scope scope;
        Pattern p = Pattern.compile("Missing scope: ([a-z:_]+)");
        Matcher m = p.matcher(msg);
        if (m.matches() && (scope = TokenInfo.Scope.fromScopeString(scopeString = m.group(1))) != null) {
            return Language.getString("login.accessMissing", scope.label);
        }
        return null;
    }

    protected void sendChatMessage(String channelId, String message, String replyToMsgId, Consumer<SendMessageResult> listener) {
        String url = "https://api.twitch.tv/helix/chat/messages";
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("broadcaster_id", channelId);
        data.put("sender_id", this.api.localUserId);
        data.put("message", message);
        if (replyToMsgId != null) {
            data.put("reply_parent_message_id", replyToMsgId);
        }
        this.newApi.add(url, "POST", data, this.api.defaultToken, r -> {
            if (r.responseCode == 200) {
                listener.accept(SendMessageResult.parse(r.text));
            } else {
                listener.accept(new SendMessageResult(false, null, String.format("Error %s (%s)", r.responseCode, r.errorText)));
            }
        });
    }

    protected void requestGlobalBadges() {
        String url = "https://api.twitch.tv/helix/chat/badges/global";
        this.newApi.add(url, "GET", this.api.defaultToken, r -> this.listener.receivedUsericons(this.api.badgeManager.handleGlobalBadgesResult(r.text)));
    }

    protected void requestRoomBadges(String roomId, String stream) {
        String url = "https://api.twitch.tv/helix/chat/badges?broadcaster_id=" + roomId;
        this.newApi.add(url, "GET", this.api.defaultToken, r -> this.listener.receivedUsericons(this.api.badgeManager.handleRoomBadgesResult(r.text, stream)));
    }

    public void requestEmotesByChannelId(String stream, String id, String requestId) {
        this.newApi.add("https://api.twitch.tv/helix/chat/emotes?broadcaster_id=" + id, "GET", this.api.defaultToken, r -> {
            EmoticonUpdate parsed = EmoticonParsing.parseEmoteList(r.text, EmoticonUpdate.Source.HELIX_CHANNEL, stream, id);
            if (parsed != null) {
                this.listener.receivedEmoticons(parsed);
                this.api.setReceived(requestId);
                if (parsed.setsAdded != null) {
                    this.api.emoticonManager2.addRequested(parsed.setsAdded);
                }
            } else if (r.responseCode == 404) {
                this.api.setNotFound(requestId);
            } else {
                this.api.setError(requestId);
            }
        });
    }

    public void requestEmotesetsNew(Set<String> emotesets) {
        if (emotesets != null && !emotesets.isEmpty()) {
            String emotesetsParam = StringUtil.join(emotesets, "&emote_set_id=");
            String url = "https://api.twitch.tv/helix/chat/emotes/set?emote_set_id=" + emotesetsParam;
            this.newApi.add(url, "GET", this.api.defaultToken, r -> {
                EmoticonUpdate result = EmoticonParsing.parseEmoteList(r.text, EmoticonUpdate.Source.HELIX_SETS, null, null);
                if (result != null) {
                    this.listener.receivedEmoticons(result);
                } else {
                    this.api.emoticonManager2.addError(emotesets);
                }
            });
        }
    }

    public void requestCheerEmoticons(String channelId, String stream) {
        String url = "https://api.twitch.tv/helix/bits/cheermotes?broadcaster_id=" + channelId;
        this.newApi.add(url, "GET", this.api.defaultToken, r -> this.api.cheersManager2.dataReceived(r.text, stream, channelId));
    }

    public void test() {
        String url = "https://api.twitch.tv/helix/...";
        this.newApi.add(url, "GET", this.api.defaultToken, r -> System.out.println(r.text));
    }

    public void addEventSub(String body, Consumer<EventSubAddResult> listener) {
        this.newApi.add("https://api.twitch.tv/helix/eventsub/subscriptions", "POST", body, this.api.defaultToken, r -> listener.accept(EventSubAddResult.decode(r)));
    }

    public void removeEventSub(String id, Consumer<Integer> listener) {
        this.newApi.add("https://api.twitch.tv/helix/eventsub/subscriptions?id=" + id, "DELETE", this.api.defaultToken, r -> listener.accept(r.responseCode));
    }

    public void getEventSubSubs(String cursor, Consumer<EventSubSubs> listener, EventSubSubs result) {
        String url = "https://api.twitch.tv/helix/eventsub/subscriptions?status=enabled";
        if (cursor != null) {
            url = url + "&after=" + cursor;
        }
        this.newApi.add(url, "GET", this.api.defaultToken, r -> {
            String nextCursor = Requests.getCursor(r.text);
            EventSubSubs result2 = result;
            if (result2 == null) {
                result2 = EventSubSubs.decode(r.text);
            } else {
                result2.addResult(EventSubSubs.decode(r.text));
            }
            if (nextCursor != null) {
                this.getEventSubSubs(nextCursor, listener, result2);
            } else {
                listener.accept(result2);
            }
        });
    }

    public void execute(TwitchApiRequest request, final RequestResultListener listener) {
        request.setOrigin(new TwitchApiRequest.TwitchApiRequestResult(){

            @Override
            public void requestResult(String url, String result, int responseCode, String error, String encoding, String token, String info) {
                int length = -1;
                if (result != null) {
                    length = result.length();
                }
                String encodingText = encoding == null ? "" : ", " + encoding;
                LOGGER.info("GOT (" + responseCode + ", " + length + encodingText + "): " + Requests.filterToken(url, token) + (token != null ? " (using authorization)" : "") + (error != null ? " [" + error + "]" : ""));
                Requests.this.removeRequest(url);
                if (Debugging.isEnabled("requestresponse")) {
                    LOGGER.info(result);
                }
                listener.result(new RequestResult(result, responseCode));
            }
        });
        this.executor.execute(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attemptRequest(String url) {
        Set<String> set = this.pendingRequest;
        synchronized (set) {
            if (!this.pendingRequest.contains(url)) {
                this.pendingRequest.add(url);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRequest(String url) {
        Set<String> set = this.pendingRequest;
        synchronized (set) {
            this.pendingRequest.remove(url);
        }
    }

    public static String filterToken(String input, String token) {
        if (input != null && !StringUtil.isNullOrEmpty(token)) {
            return input.replace(token, "<token>");
        }
        return input;
    }

    public static String makeNewApiParameters(String key, Collection<String> values) {
        return key + "=" + StringUtil.join(values, "&" + key + "=");
    }

    public static String makeUrl(String base, String ... args) {
        String result = base;
        for (int i = 0; i < args.length; i += 2) {
            result = i == 0 ? result + "?" : result + "&";
            try {
                result = result + args[i] + "=" + URLEncoder.encode(args[i + 1], "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                return null;
            }
        }
        return result;
    }

    public static String getCursor(String json) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            JSONObject pagination = (JSONObject)root.get("pagination");
            if (pagination != null) {
                String cursor = JSONUtil.getString(pagination, "cursor");
                return !StringUtil.isNullOrEmpty(cursor) ? cursor : null;
            }
        }
        catch (Exception ex) {
            LOGGER.warning("Error getting cursor: " + ex);
        }
        return null;
    }

    public static String getErrorMessage(String json) {
        if (json == null) {
            return null;
        }
        try {
            JSONParser parser = new JSONParser();
            JSONObject o = (JSONObject)parser.parse(json);
            return (String)o.get("message");
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static interface RequestResultListener {
        public void result(RequestResult var1);
    }

    public static class RequestResult {
        public final String text;
        public final int responseCode;

        public RequestResult(String result, int responseCode) {
            this.text = result;
            this.responseCode = responseCode;
        }
    }
}

