/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.api.StreamCategory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class ResultManager {
    private final Map<Type, Set<Object>> listeners = new HashMap<Type, Set<Object>>();
    private final Map<Object, Object> uniqueListeners = new HashMap<Object, Object>();

    public void subscribe(Type type, Object listener) {
        this.subscribe(type, null, listener);
    }

    public void subscribe(Type type, Object unique, Object listener) {
        if (listener != null) {
            if (!type.c.isInstance(listener)) {
                throw new RuntimeException("Invalid parameter");
            }
            if (!this.listeners.containsKey((Object)type)) {
                this.listeners.put(type, new HashSet());
            }
            if (unique != null) {
                Object prevListener = this.uniqueListeners.remove(unique);
                if (prevListener != null) {
                    this.listeners.forEach((k, v) -> v.remove(prevListener));
                }
                this.uniqueListeners.put(unique, listener);
            }
            this.listeners.get((Object)type).add(listener);
        }
    }

    public <T> void inform(Type type, Consumer<T> func) {
        if (!this.listeners.containsKey((Object)type)) {
            return;
        }
        for (Object listener : this.listeners.get((Object)type)) {
            func.accept(listener);
        }
    }

    public static void main(String[] args) {
        ResultManager m = new ResultManager();
        m.subscribe(Type.CATEGORY_RESULT, categories -> System.out.println(categories));
        m.subscribe(Type.CATEGORY_RESULT, categories -> System.out.println("b" + categories));
        m.inform(Type.CATEGORY_RESULT, result -> result.result(null));
        CategoryResult o = new CategoryResult(){

            @Override
            public void result(Collection<StreamCategory> categories) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    public static enum Type {
        CATEGORY_RESULT(CategoryResult.class),
        SHIELD_MODE_RESULT(ShieldModeResult.class),
        CREATE_CLIP(CreateClipResult.class);

        private final Class c;

        private Type(Class c) {
            this.c = c;
        }
    }

    public static interface CategoryResult {
        public void result(Collection<StreamCategory> var1);
    }

    public static interface CreateClipResult {
        public void result(String var1, String var2, String var3);
    }

    public static interface ShieldModeResult {
        public void result(String var1, boolean var2);
    }
}

