/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.StringUtil;
import java.util.Objects;

public class StreamCategory
implements Comparable<StreamCategory> {
    public static final StreamCategory EMPTY = new StreamCategory("", "");
    public final String id;
    public final String name;

    public StreamCategory(String id, String name) {
        if (StringUtil.isNullOrEmpty(name)) {
            this.id = "";
            this.name = "";
        } else {
            this.id = id;
            this.name = name;
        }
    }

    public boolean hasId() {
        return this.id != null;
    }

    public boolean isEmpty() {
        return this.name.isEmpty();
    }

    public boolean nameMatches(StreamCategory other) {
        String otherName;
        String currentName = this.name.trim();
        return currentName.equals(otherName = other.name.trim()) || StreamCategory.newDash(currentName).equals(StreamCategory.newDash(otherName));
    }

    private static String newDash(String input) {
        return input.replace("\u2013", "-");
    }

    public String toString() {
        return this.name;
    }

    public String toStringVerbose() {
        return String.format("[%s/%s]", this.id, this.name);
    }

    @Override
    public int compareTo(StreamCategory o) {
        return this.name.compareToIgnoreCase(o.name);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamCategory other = (StreamCategory)obj;
        return Objects.equals(this.name, other.name);
    }
}

