/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.Helper;
import chatty.util.DateTime;
import chatty.util.ElapsedTime;
import chatty.util.StringUtil;
import chatty.util.api.StreamCategory;
import chatty.util.api.StreamInfoHistoryItem;
import chatty.util.api.StreamInfoListener;
import java.util.LinkedHashMap;
import java.util.logging.Logger;

public class StreamInfo {
    private static final Logger LOGGER = Logger.getLogger(StreamInfo.class.getName());
    public final String stream;
    private String display_name;
    private String broadcastId;
    private String thumbnailUrl;
    private String userId;
    private String capitalizedName;
    private final ElapsedTime lastUpdatedET = new ElapsedTime();
    private final ElapsedTime lastStatusChangeET = new ElapsedTime();
    private final ElapsedTime lastUpdateSuccededET = new ElapsedTime();
    private String status = null;
    private StreamCategory game = StreamCategory.EMPTY;
    private int viewers = 0;
    private long startedAt = -1L;
    private long startedAtSameAfterOffline;
    private final ElapsedTime lastFollowedUpdate = new ElapsedTime();
    private final ElapsedTime lastOnlineET = new ElapsedTime();
    private long prevLastOnlineAgoSecs;
    private long startedAtWithPicnic = -1L;
    private boolean online = false;
    private StreamType streamType;
    private boolean updateSucceeded = false;
    private int updateFailedCounter = 0;
    private boolean requested = false;
    private boolean followed = false;
    private volatile boolean notFound = false;
    private int followerCount = 0;
    private int subscriberCount = 0;
    private boolean isOpen = false;
    private long recheckOffline = -1L;
    private long lastViewerStats;
    private static final int VIEWERSTATS_DELAY = 1800000;
    private static final int VIEWERSTATS_MAX_LENGTH = 0x200B20;
    private static final int RECHECK_OFFLINE_DELAY = 20000;
    private static final int MAX_PICNIC_LENGTH = 600;
    private String currentFullStatus;
    private String prevFullStatus;
    private final LinkedHashMap<Long, StreamInfoHistoryItem> history = new LinkedHashMap();
    private int expiresAfter = 300;
    private final StreamInfoListener listener;

    public StreamInfo(String stream, StreamInfoListener listener) {
        this.listener = listener;
        this.stream = StringUtil.toLowerCase(stream);
    }

    private void streamInfoUpdated(UpdateResult r) {
        if (r == UpdateResult.SET_OFFLINE) {
            this.setOffline();
        }
        if (r == UpdateResult.CHANGED) {
            this.streamInfoStatusChanged();
        }
        this.streamInfoUpdated();
    }

    private void streamInfoUpdated() {
        if (this.listener != null) {
            this.listener.streamInfoUpdated(this);
        }
    }

    private void streamInfoStatusChanged() {
        this.lastStatusChangeET.set();
        if (this.listener != null) {
            this.listener.streamInfoStatusChanged(this, this.getFullStatus());
        }
    }

    public synchronized void setRequested() {
        this.requested = true;
    }

    public synchronized boolean isRequested() {
        return this.requested;
    }

    public void setFollowed(String status, StreamCategory game, int viewers, long startedAt, StreamType streamType) {
        this.followed = true;
        boolean saveToHistory = false;
        if (this.hasExpired() || this.startedAtSameAfterOffline > 0L) {
            saveToHistory = true;
        }
        this.lastFollowedUpdate.set();
        this.set(status, game, viewers, startedAt, streamType, saveToHistory);
    }

    public void set(String status, StreamCategory game, int viewers, long startedAt, StreamType streamType) {
        this.set(status, game, viewers, startedAt, streamType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set(String status, StreamCategory game, int viewers, long startedAt, StreamType streamType, boolean saveToHistory) {
        UpdateResult result;
        StreamInfo streamInfo = this;
        synchronized (streamInfo) {
            this.status = StringUtil.trim(StringUtil.removeLinebreakCharacters(status));
            this.game = game;
            this.viewers = viewers;
            this.streamType = streamType;
            if (this.recheckOffline != -1L) {
                if (this.startedAt < startedAt) {
                    LOGGER.info("StreamInfo " + this.stream + ": Stream not offline anymore");
                } else {
                    LOGGER.info("StreamInfo " + this.stream + ": Stream not offline");
                }
            }
            this.recheckOffline = -1L;
            if (this.getLastOnlineAgoSecs() > 600L || this.startedAtWithPicnic == -1L) {
                this.startedAtWithPicnic = startedAt;
            }
            if (!this.online && this.startedAt == startedAt) {
                LOGGER.info("Same start time after offline: " + this.stream);
                this.startedAtSameAfterOffline = startedAt;
            }
            if (this.startedAtSameAfterOffline > 0L && this.startedAtSameAfterOffline != startedAt) {
                LOGGER.info("Changed start time after offline: " + this.stream);
                this.startedAtSameAfterOffline = -1L;
            }
            this.startedAt = startedAt;
            this.prevLastOnlineAgoSecs = this.lastOnlineET.secondsElapsed();
            this.lastOnlineET.set();
            this.online = true;
            if (saveToHistory) {
                this.addHistoryItem(System.currentTimeMillis(), new StreamInfoHistoryItem(System.currentTimeMillis(), viewers, status, game.name, streamType, this.getTimeStarted(), this.getTimeStartedWithPicnic()));
            }
            result = this.setUpdateSucceeded(true);
        }
        this.streamInfoUpdated(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffline() {
        UpdateResult result;
        StreamInfo streamInfo = this;
        synchronized (streamInfo) {
            if (this.startedAtSameAfterOffline > 0L) {
                if (this.lastFollowedUpdate.isSetAndSecondsElapsed(600)) {
                    LOGGER.info("Stopped ignoring offline (no followed updates)");
                    this.startedAtSameAfterOffline = -1L;
                } else {
                    LOGGER.info("Ignored setting offline " + this.stream);
                }
            } else if (this.online && this.recheckOffline == -1L && this.isValidEnough()) {
                LOGGER.info("Waiting to recheck offline status for " + this.stream);
                this.recheckOffline = System.currentTimeMillis();
            } else {
                if (this.recheckOffline != -1L) {
                    LOGGER.info("Offline after check: " + this.stream);
                }
                this.recheckOffline = -1L;
                this.online = false;
                this.addHistoryItem(System.currentTimeMillis(), new StreamInfoHistoryItem(System.currentTimeMillis()));
            }
            result = this.setUpdateSucceeded(true);
        }
        this.streamInfoUpdated(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdateFailed() {
        UpdateResult result;
        StreamInfo streamInfo = this;
        synchronized (streamInfo) {
            result = this.setUpdateSucceeded(false);
        }
        this.streamInfoUpdated(result);
    }

    private UpdateResult setUpdateSucceeded(boolean succeeded) {
        boolean statusChanged = false;
        this.updateSucceeded = succeeded;
        this.setUpdated();
        if (succeeded) {
            this.updateFailedCounter = 0;
            this.lastUpdateSuccededET.set();
        } else {
            ++this.updateFailedCounter;
            if (this.recheckOffline != -1L) {
                LOGGER.warning("StreamInfo " + this.stream + ": Update failed, delayed setting offline");
                return UpdateResult.SET_OFFLINE;
            }
        }
        this.currentFullStatus = this.makeFullStatus();
        if (succeeded && !this.currentFullStatus.equals(this.prevFullStatus) || this.lastUpdateLongAgo()) {
            this.prevFullStatus = this.currentFullStatus;
            statusChanged = true;
        }
        if (statusChanged) {
            return UpdateResult.CHANGED;
        }
        return UpdateResult.UPDATED;
    }

    private void setUpdated() {
        this.lastUpdatedET.set();
        this.requested = false;
    }

    public synchronized void setExpiresAfter(int expiresAfter) {
        this.expiresAfter = expiresAfter;
    }

    public String getStream() {
        return this.stream;
    }

    public synchronized String getFullStatus() {
        return this.currentFullStatus;
    }

    private String makeFullStatus() {
        if (this.online) {
            String fullStatus = this.status;
            if (this.status == null || this.status.isEmpty()) {
                fullStatus = "No stream title set";
            }
            fullStatus = this.getStreamTypeString() + fullStatus;
            if (this.game != null && !this.game.isEmpty()) {
                fullStatus = fullStatus + " (" + this.game + ")";
            }
            return fullStatus;
        }
        return "Stream offline";
    }

    public String getDisplayName() {
        return this.display_name != null ? this.display_name : this.stream;
    }

    public boolean hasDisplayName() {
        return this.display_name != null;
    }

    public void setDisplayName(String name) {
        this.display_name = name;
        if (name != null && StringUtil.toLowerCase(name).equals(this.stream)) {
            this.capitalizedName = name;
        }
    }

    public void setBroadcastId(String broadcastId) {
        this.broadcastId = broadcastId;
    }

    public String getBroadcastId() {
        return this.broadcastId;
    }

    public String getCapitalizedName() {
        return this.capitalizedName != null ? this.capitalizedName : this.stream;
    }

    public boolean hasRegularDisplayName() {
        return !this.hasDisplayName() || this.capitalizedName != null;
    }

    public synchronized void setThumbnailUrl(String url) {
        this.thumbnailUrl = url;
    }

    public synchronized String getThumbnailUrl(int width, int height) {
        return this.thumbnailUrl.replace("{width}", String.valueOf(width)).replace("{height}", String.valueOf(height));
    }

    public synchronized boolean setUserId(String userId) {
        if (this.userId == null || !this.userId.equals(userId) && userId != null) {
            this.userId = userId;
            return true;
        }
        return false;
    }

    public synchronized StreamType getStreamType() {
        return this.streamType;
    }

    public synchronized String getStreamTypeString() {
        if (this.streamType != StreamType.LIVE) {
            return "[VOD] ";
        }
        return "";
    }

    public synchronized void setNotFound() {
        this.notFound = true;
    }

    public synchronized boolean isNotFound() {
        return this.notFound;
    }

    public synchronized boolean recheckOffline() {
        return this.recheckOffline != -1L && System.currentTimeMillis() - this.recheckOffline > 20000L;
    }

    public synchronized boolean getFollowed() {
        return this.followed;
    }

    public synchronized boolean getOnline() {
        return this.online;
    }

    public synchronized long getTimeStarted() {
        return this.startedAt;
    }

    public synchronized long getTimeStartedAgo() {
        return System.currentTimeMillis() - this.startedAt;
    }

    public synchronized long getTimeStartedWithPicnic() {
        return this.startedAtWithPicnic;
    }

    public synchronized long getTimeStartedWithPicnicAgo() {
        return System.currentTimeMillis() - this.startedAtWithPicnic;
    }

    public synchronized long getLastOnlineAgoSecs() {
        return this.lastOnlineET.secondsElapsed();
    }

    public synchronized long getLastOnlineTime() {
        if (!this.lastOnlineET.isSet()) {
            return -1L;
        }
        return System.currentTimeMillis() - this.lastOnlineET.millisElapsed();
    }

    public synchronized long getPrevLastOnlineAgoSecs() {
        return this.prevLastOnlineAgoSecs;
    }

    public synchronized String getStatus() {
        return this.status;
    }

    public synchronized String getTitle() {
        if (this.status == null) {
            return "No stream title set";
        }
        return this.status;
    }

    public synchronized String getGame() {
        return this.game.name;
    }

    public synchronized int getViewers() {
        return this.viewers;
    }

    public synchronized long getUpdatedDelay() {
        return this.lastUpdatedET.secondsElapsed();
    }

    public synchronized boolean hasExpired() {
        return this.getUpdatedDelay() > (long)(this.expiresAfter * (1 + this.updateFailedCounter / 2));
    }

    public synchronized boolean isValid() {
        return this.updateSucceeded && this.getUpdatedDelay() <= (long)(this.expiresAfter * 2);
    }

    public synchronized boolean isValidEnough() {
        return this.isValid() || !this.lastUpdateSuccededET.secondsElapsed(this.expiresAfter * 3);
    }

    public synchronized boolean lastUpdateLongAgo() {
        return this.updateSucceeded && this.getUpdatedDelay() > (long)(this.expiresAfter * 4);
    }

    public synchronized long getStatusChangeTimeAgo() {
        return this.lastStatusChangeET.secondsElapsed();
    }

    public synchronized String toString() {
        return "Online: " + this.online + " Status: " + this.status + " Game: " + this.game + " Viewers: " + this.viewers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHistoryItem(Long time, StreamInfoHistoryItem item) {
        LinkedHashMap<Long, StreamInfoHistoryItem> linkedHashMap = this.history;
        synchronized (linkedHashMap) {
            this.history.put(time, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<Long, StreamInfoHistoryItem> getHistory() {
        LinkedHashMap<Long, StreamInfoHistoryItem> linkedHashMap = this.history;
        synchronized (linkedHashMap) {
            return new LinkedHashMap<Long, StreamInfoHistoryItem>(this.history);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistory(LinkedHashMap<Long, StreamInfoHistoryItem> history) {
        LinkedHashMap<Long, StreamInfoHistoryItem> linkedHashMap = history;
        synchronized (linkedHashMap) {
            this.history.clear();
            this.history.putAll(history);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHistoryStreamStart(long time, boolean picnic) {
        if (time == -1L && this.isValid() && this.getOnline()) {
            if (picnic) {
                return this.getTimeStartedWithPicnic();
            }
            return this.getTimeStarted();
        }
        LinkedHashMap<Long, StreamInfoHistoryItem> linkedHashMap = this.history;
        synchronized (linkedHashMap) {
            StreamInfoHistoryItem found = null;
            for (StreamInfoHistoryItem item : this.history.values()) {
                if (item.getTime() > time) break;
                if (item.getTime() > time) continue;
                found = item;
            }
            if (found != null && found.isOnline() && time - found.getTime() < (long)(this.expiresAfter * 1000 * 2)) {
                if (picnic) {
                    return found.getStreamStartTimeWithPicnic();
                }
                return found.getStreamStartTime();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewerStats getViewerStats(boolean force) {
        LinkedHashMap<Long, StreamInfoHistoryItem> linkedHashMap = this.history;
        synchronized (linkedHashMap) {
            if (this.lastViewerStats == 0L && !force) {
                this.lastViewerStats = System.currentTimeMillis() - 5000L;
            }
            long timePassed = System.currentTimeMillis() - this.lastViewerStats;
            if (!force && timePassed < 1800000L) {
                return null;
            }
            long startAt = this.lastViewerStats + 1L;
            if (timePassed > 0x200B20L) {
                startAt = System.currentTimeMillis() - 0x200B20L;
            }
            int min = -1;
            int max = -1;
            int total = 0;
            int count = 0;
            long firstTime = -1L;
            long lastTime = -1L;
            StringBuilder b = new StringBuilder();
            int prevViewers = -2;
            for (long time : this.history.keySet()) {
                if (time < startAt) continue;
                this.lastViewerStats = time;
                int viewers = this.history.get(time).getViewers();
                if (prevViewers > -1 && viewers != -1) {
                    int diff = viewers - prevViewers;
                    if (diff >= 0) {
                        b.append("+");
                    }
                    b.append(Helper.formatViewerCount(diff));
                } else if (viewers != -1) {
                    if (prevViewers == -1) {
                        b.append("_");
                    }
                    b.append(Helper.formatViewerCount(viewers));
                }
                prevViewers = viewers;
                if (viewers == -1) continue;
                if (firstTime == -1L) {
                    firstTime = time;
                }
                lastTime = time;
                if (viewers > max) {
                    max = viewers;
                }
                if (min == -1 || viewers < min) {
                    min = viewers;
                }
                total += viewers;
                ++count;
            }
            if (prevViewers == -1) {
                b.append("_");
            }
            if (count == 0) {
                return null;
            }
            int avg = total / count;
            return new ViewerStats(min, max, avg, firstTime, lastTime, count, b.toString());
        }
    }

    public synchronized boolean setFollowerCount(int followers) {
        if (followers != this.followerCount) {
            this.followerCount = followers;
            return true;
        }
        return false;
    }

    public synchronized boolean setSubscriberCount(int subscribers) {
        if (subscribers != this.subscriberCount) {
            this.subscriberCount = subscribers;
            return true;
        }
        return false;
    }

    public synchronized int getFollowerCount() {
        return this.followerCount;
    }

    public synchronized int getSubscriberCount() {
        return this.subscriberCount;
    }

    public synchronized void setIsOpen(boolean isOpen) {
        if (isOpen != this.isOpen) {
            this.isOpen = isOpen;
            this.streamInfoUpdated();
        }
    }

    public synchronized boolean isOpen() {
        return this.isOpen;
    }

    private static enum UpdateResult {
        UPDATED,
        CHANGED,
        SET_OFFLINE;

    }

    public static enum StreamType {
        LIVE,
        WATCH_PARTY,
        RERUN,
        PREMIERE;

    }

    public static class ViewerStats {
        public final int max;
        public final int min;
        public final int avg;
        public final long startTime;
        public final long endTime;
        public final int count;
        public final String history;

        public ViewerStats(int min, int max, int avg, long startTime, long endTime, int count, String history) {
            this.max = max;
            this.min = min;
            this.avg = avg;
            this.startTime = startTime;
            this.endTime = endTime;
            this.count = count;
            this.history = history;
        }

        public long duration() {
            return (this.endTime - this.startTime) / 1000L;
        }

        public boolean isValid() {
            return this.min != -1;
        }

        public String toString() {
            return "Viewerstats (" + DateTime.format2(this.startTime) + "-" + DateTime.format2(this.endTime) + "): avg:" + Helper.formatViewerCount(this.avg) + " min:" + Helper.formatViewerCount(this.min) + " max:" + Helper.formatViewerCount(this.max) + " [" + this.count + "/" + this.history + "]";
        }
    }
}

