/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.MiscUtil;
import chatty.util.api.StreamInfo;

public class StreamInfoHistoryItem {
    private final boolean online;
    private final int viewers;
    private final String status;
    private final String game;
    private final String statusAndGame;
    private final long time;
    private final String title;
    private final StreamInfo.StreamType streamType;
    private final long streamStartTime;
    private final long streamStartTimeWithPicnic;

    public StreamInfoHistoryItem(long time) {
        this.viewers = -1;
        this.status = null;
        this.game = null;
        this.online = false;
        this.statusAndGame = null;
        this.time = time;
        this.title = "Stream offline";
        this.streamType = null;
        this.streamStartTime = -1L;
        this.streamStartTimeWithPicnic = -1L;
    }

    public StreamInfoHistoryItem(long time, int viewers, String status, String game, StreamInfo.StreamType streamType, long startedTime, long startedTimeWithPicnic) {
        this.viewers = viewers;
        this.status = status;
        this.game = MiscUtil.intern(game);
        this.online = true;
        this.statusAndGame = MiscUtil.intern(status + game);
        this.time = time;
        this.title = status == null ? "No stream title set" : MiscUtil.intern(status);
        this.streamType = streamType;
        this.streamStartTime = startedTime;
        this.streamStartTimeWithPicnic = startedTimeWithPicnic;
    }

    public int getViewers() {
        return this.viewers;
    }

    public String getStatus() {
        return this.status;
    }

    public String getTitle() {
        return this.title;
    }

    public String getGame() {
        return this.game;
    }

    public boolean isOnline() {
        return this.online;
    }

    public String getStatusAndGame() {
        return this.statusAndGame;
    }

    public long getTime() {
        return this.time;
    }

    public StreamInfo.StreamType getStreamType() {
        return this.streamType;
    }

    public long getStreamStartTime() {
        return this.streamStartTime;
    }

    public long getStreamStartTimeWithPicnic() {
        return this.streamStartTimeWithPicnic;
    }
}

