/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.DateTime;
import chatty.util.ElapsedTime;
import chatty.util.JSONUtil;
import chatty.util.StringUtil;
import chatty.util.api.Requests;
import chatty.util.api.StreamCategory;
import chatty.util.api.StreamInfo;
import chatty.util.api.StreamInfoListener;
import chatty.util.api.TwitchApi;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class StreamInfoManager {
    private static final Logger LOGGER = Logger.getLogger(StreamInfoManager.class.getName());
    private static final int UPDATE_STREAMINFO_DELAY = 120;
    private static final int SPECIAL_CHECK_DELAY = 20;
    private static final int UPDATE_FOLLOWS_DELAY = 200;
    private static final int UPDATE_STREAMINFO_DELAY_NOT_FOUND = 300;
    public static final int FOLLOWED_STREAMS_LIMIT = 100;
    private static final int FOLLOWED_STREAMS_REQUEST_LIMIT = 8;
    private int followedStreamsRequests = 0;
    private final HashMap<String, StreamInfo> cachedStreamInfo = new HashMap();
    private final ElapsedTime streamsInfoRequestedET = new ElapsedTime();
    private final ElapsedTime followsRequestedET = new ElapsedTime();
    private final ElapsedTime specialCheckDoneET = new ElapsedTime();
    private int followsRequestErrors = 0;
    private String prevToken = "";
    private int streamsRequestErrors = 0;
    private final StreamInfoListener listener;
    private final TwitchApi api;
    private final StreamInfo invalidStreamInfo;
    private static final long VALID_UPTIME_LIMIT = 1827387392L;

    public StreamInfoManager(TwitchApi api, StreamInfoListener listener) {
        this.listener = listener;
        this.api = api;
        this.invalidStreamInfo = new StreamInfo("invalid", listener);
        this.invalidStreamInfo.setRequested();
    }

    public synchronized void manualRefresh() {
        this.followsRequestedET.reset();
        this.streamsInfoRequestedET.reset();
    }

    public synchronized void getFollowedStreams(String token) {
        if (token == null || token.isEmpty()) {
            return;
        }
        if (!this.prevToken.equals(token)) {
            this.followsRequestErrors = 0;
        }
        if (StreamInfoManager.checkTimePassed(this.followsRequestedET, 200, this.followsRequestErrors)) {
            this.prevToken = token;
            this.followsRequestedET.set();
            this.followedStreamsRequests = 1;
            this.api.requests.requestFollowedStreams(token, null);
        }
    }

    private void getFollowedStreamsNext(String cursor) {
        if (this.followedStreamsRequests < 8) {
            int offset = 100 * this.followedStreamsRequests;
            this.api.requests.requestFollowedStreams(this.prevToken, cursor);
            ++this.followedStreamsRequests;
        } else {
            LOGGER.warning("Followed streams: Not getting next url (limit reached: 8)");
        }
    }

    public static boolean checkTimePassed(ElapsedTime et, int delay, int errors) {
        return et.secondsElapsed(delay + errors * delay / 4);
    }

    public synchronized StreamInfo getStreamInfo(String stream, Set<String> streams) {
        this.requestStreamsInfo(streams);
        this.checkRerequest(streams);
        StreamInfo cached = this.getStreamInfo(stream);
        if (cached.hasExpired() && !cached.isRequested()) {
            cached.setRequested();
            this.api.requests.requestStreamInfo(stream);
        }
        return cached;
    }

    public synchronized StreamInfo getCachedStreamInfo(String stream) {
        return this.cachedStreamInfo.get(StringUtil.toLowerCase(stream));
    }

    private StreamInfo getStreamInfo(String stream) {
        if (stream == null || stream.isEmpty()) {
            return this.invalidStreamInfo;
        }
        StreamInfo cached = this.cachedStreamInfo.get(stream = StringUtil.toLowerCase(stream));
        if (cached == null) {
            cached = new StreamInfo(stream, this.listener);
            cached.setExpiresAfter(120);
            this.cachedStreamInfo.put(stream, cached);
        }
        return cached;
    }

    private void checkRerequest(Set<String> streams) {
        if (!StreamInfoManager.checkTimePassed(this.specialCheckDoneET, 20, this.streamsRequestErrors)) {
            return;
        }
        this.requestStreamsInfo2(streams, true);
    }

    private void requestStreamsInfo(Set<String> streams) {
        if (!StreamInfoManager.checkTimePassed(this.streamsInfoRequestedET, 120, this.streamsRequestErrors)) {
            return;
        }
        this.requestStreamsInfo2(streams, false);
    }

    private void requestStreamsInfo2(Set<String> streams, boolean special) {
        HashSet<String> streamsForRequest = new HashSet<String>();
        HashSet<StreamInfo> streamInfosForRequest = new HashSet<StreamInfo>();
        for (String stream : streams) {
            StreamInfo cached = this.getStreamInfo(stream);
            if (!(cached.isRequested() || special && !cached.recheckOffline())) {
                streamsForRequest.add(stream);
                streamInfosForRequest.add(cached);
                cached.setRequested();
            }
            if (streamsForRequest.size() <= 90) continue;
            break;
        }
        if (special) {
            this.specialCheckDoneET.set();
        }
        if (!streamsForRequest.isEmpty()) {
            if (!special) {
                this.streamsInfoRequestedET.set();
            }
            this.api.requests.requestStreamsInfo(streamsForRequest, streamInfosForRequest);
        }
    }

    protected synchronized void requestResult(String result, int responseCode, String stream) {
        StreamInfo streamInfo = this.getStreamInfo(stream);
        if (result == null) {
            LOGGER.warning("Error requesting stream data " + stream + ": " + result);
            if (responseCode == 404) {
                streamInfo.setExpiresAfter(300);
                streamInfo.setNotFound();
            }
            streamInfo.setUpdateFailed();
        } else {
            HashSet<StreamInfo> expected = new HashSet<StreamInfo>();
            expected.add(streamInfo);
            this.parseStreams(result, expected);
        }
    }

    protected synchronized void requestResultStreams(String result, int responseCode, Set<StreamInfo> expected) {
        if (responseCode != 200 || result == null) {
            this.streamsRequestErrors = responseCode == 404 ? (this.streamsRequestErrors += 2) : ++this.streamsRequestErrors;
            LOGGER.warning("Unexpected response code " + responseCode + " or result null (errors: " + this.streamsRequestErrors + ")");
            this.streamsRequestError(expected);
        } else {
            this.streamsRequestErrors = this.parseStreams(result, expected) == -1 ? ++this.streamsRequestErrors : 0;
        }
    }

    private void streamsRequestError(Set<StreamInfo> expected) {
        if (expected != null) {
            for (StreamInfo info : expected) {
                info.setUpdateFailed();
            }
        }
    }

    protected synchronized void requestResultFollows(String result, int responseCode) {
        if (responseCode == 200 && result != null) {
            int count = this.parseStreams(result, null);
            LOGGER.info("Got " + count + " (limit: " + 100 + ") followed streams.");
            String cursor = Requests.getCursor(result);
            if (cursor != null) {
                this.getFollowedStreamsNext(cursor);
            }
            this.followsRequestErrors = 0;
        } else if (responseCode == 401) {
            this.followsRequestErrors += 4;
            LOGGER.warning("Access denied when getting followed streams.");
            this.api.accessDenied();
        } else {
            ++this.followsRequestErrors;
        }
    }

    private int parseStreams(String json, Set<StreamInfo> streamInfos) {
        try {
            JSONArray streamsArray;
            JSONParser parser = new JSONParser();
            try {
                JSONObject root = (JSONObject)parser.parse(json);
                streamsArray = (JSONArray)root.get("data");
            }
            catch (ClassCastException ex) {
                LOGGER.warning("Error parsing streams: unexpected type");
                this.streamsRequestError(streamInfos);
                return -1;
            }
            if (streamsArray == null) {
                LOGGER.warning("Error parsing streams: streams array not found");
                this.streamsRequestError(streamInfos);
                return -1;
            }
            for (Object obj : streamsArray) {
                if (obj instanceof JSONObject) {
                    StreamInfo parsedInfo = this.parseStream((JSONObject)obj, streamInfos == null);
                    if (parsedInfo == null) {
                        LOGGER.warning("Error parsing stream " + (JSONObject)obj);
                    }
                    if (streamInfos == null) continue;
                    streamInfos.remove(parsedInfo);
                    continue;
                }
                LOGGER.warning("Element in array wasn't JSONObject " + obj);
            }
            if (streamInfos != null) {
                for (StreamInfo info : streamInfos) {
                    info.setOffline();
                }
            }
            return streamsArray.size();
        }
        catch (ParseException ex) {
            LOGGER.warning("Error parsing streams info: " + ex.getLocalizedMessage());
            this.streamsRequestError(streamInfos);
            return -1;
        }
    }

    private StreamInfo parseStream(JSONObject stream, boolean follows) {
        String broadcastId;
        String display_name;
        String name;
        String status;
        Number viewersTemp;
        if (stream == null) {
            LOGGER.warning("Error parsing stream: Should be JSONObject, not null");
            return null;
        }
        StreamCategory game = StreamCategory.EMPTY;
        StreamInfo.StreamType streamType = StreamInfo.StreamType.LIVE;
        long timeStarted = -1L;
        String userId = null;
        String thumbnailUrl = null;
        try {
            viewersTemp = (Number)stream.get("viewer_count");
            status = JSONUtil.getString(stream, "title");
            String gameName = JSONUtil.getString(stream, "game_name");
            String gameId = JSONUtil.getString(stream, "game_id");
            game = new StreamCategory(gameId, gameName);
            name = JSONUtil.getString(stream, "user_login");
            display_name = JSONUtil.getString(stream, "user_name");
            userId = JSONUtil.getString(stream, "user_id");
            thumbnailUrl = JSONUtil.getString(stream, "thumbnail_url");
            broadcastId = JSONUtil.getString(stream, "id");
        }
        catch (ClassCastException ex) {
            LOGGER.warning("Error parsing StreamInfo: unpexected type");
            return null;
        }
        if (name == null || name.isEmpty()) {
            LOGGER.warning("Error parsing StreamInfo: name null or empty");
            return null;
        }
        if (viewersTemp == null) {
            LOGGER.warning("Error parsing StreamInfo: viewercount null (" + name + ")");
            return null;
        }
        try {
            timeStarted = DateTime.parseDatetime(JSONUtil.getString(stream, "started_at"));
            if (timeStarted + 1827387392L < System.currentTimeMillis()) {
                LOGGER.warning("Warning: Stream created_at for " + name + " seems invalid (" + stream.get("created_at") + ")");
                timeStarted = -1L;
            }
        }
        catch (Exception ex) {
            LOGGER.warning("Warning parsing StreamInfo: could not parse created_at (" + ex + ")");
        }
        int viewers = viewersTemp.intValue();
        if (viewers < 0) {
            viewers = 0;
            LOGGER.warning("Warning: Viewercount should not be negative, set to 0 (" + name + ").");
        }
        StreamInfo streamInfo = this.getStreamInfo(name);
        streamInfo.setDisplayName(display_name);
        streamInfo.setBroadcastId(broadcastId);
        if (streamInfo.setUserId(userId)) {
            this.api.setUserId(name, userId);
        }
        if (thumbnailUrl != null) {
            streamInfo.setThumbnailUrl(thumbnailUrl);
        }
        if (follows) {
            streamInfo.setFollowed(status, game, viewers, timeStarted, streamType);
        } else {
            streamInfo.set(status, game, viewers, timeStarted, streamType);
        }
        return streamInfo;
    }
}

