/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.Chatty;
import chatty.util.JSONUtil;
import chatty.util.StringUtil;
import chatty.util.api.CachedManager;
import chatty.util.api.Requests;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class StreamLabels {
    private static final Logger LOGGER = Logger.getLogger(StreamLabels.class.getName());
    private static final List<String> EDITABLE = new ArrayList<String>(Arrays.asList("DrugsIntoxication", "SexualThemes", "ViolentGraphic", "Gambling", "ProfanityVulgarity"));
    private static final List<String> AUTO = new ArrayList<String>(Arrays.asList("MatureGame"));
    private static final String CACHE_FILE = Chatty.getPathCreate(Chatty.PathType.CACHE).resolve("streamlabels").toString();
    public static final int CACHE_EXPIRES_AFTER = 604800;
    private static final CachedManager cache = new CachedManager(CACHE_FILE, 604800L, "StreamLabels"){

        @Override
        public boolean handleData(String data) {
            if (data != null) {
                return StreamLabels.parseInfo(data);
            }
            return false;
        }
    };
    private static Map<String, StreamLabelInfo> infos;

    public static List<StreamLabel> copyEditableLabelsOnly(List<StreamLabel> labels) {
        ArrayList<StreamLabel> editableLabels = new ArrayList<StreamLabel>(labels);
        editableLabels.removeIf(label -> !label.isEditable());
        return editableLabels;
    }

    public static List<StreamLabel> copyAutoLabelsOnly(List<StreamLabel> labels) {
        ArrayList<StreamLabel> editableLabels = new ArrayList<StreamLabel>(labels);
        editableLabels.removeIf(label -> label.isEditable());
        return editableLabels;
    }

    private static boolean isEditableLabel(String labelId) {
        return EDITABLE.contains(labelId);
    }

    public static List<StreamLabel> getAvailableLabels() {
        ArrayList<StreamLabel> labels = new ArrayList<StreamLabel>();
        EDITABLE.forEach(id -> labels.add(new StreamLabel((String)id)));
        AUTO.forEach(id -> labels.add(new StreamLabel((String)id)));
        return labels;
    }

    public static void request(Requests requests) {
        if (!cache.load()) {
            requests.getContentLabels();
        }
    }

    public static void dataReceived(String json) {
        cache.dataReceived(json, false);
    }

    private static boolean parseInfo(String json) {
        try {
            HashMap<String, StreamLabelInfo> result = new HashMap<String, StreamLabelInfo>();
            JSONObject root = (JSONObject)new JSONParser().parse(json);
            JSONArray data = (JSONArray)root.get("data");
            for (Object o : data) {
                JSONObject entry = (JSONObject)o;
                StreamLabelInfo info = new StreamLabelInfo(JSONUtil.getString(entry, "id"), JSONUtil.getString(entry, "name"), JSONUtil.getString(entry, "description"));
                result.put(info.id, info);
            }
            infos = result;
            return true;
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing streamlabels: " + ex);
            return false;
        }
    }

    private static StreamLabelInfo getInfo(String id) {
        if (infos != null) {
            return infos.get(id);
        }
        return null;
    }

    public static class StreamLabelInfo {
        public final String id;
        public final String name;
        public final String description;

        public StreamLabelInfo(String id, String name, String description) {
            this.id = id;
            this.name = name;
            this.description = description;
        }
    }

    public static class StreamLabel
    implements Comparable<StreamLabel> {
        public static final StreamLabel EMPTY = new StreamLabel("");
        private final String id;

        public StreamLabel(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getDisplayName() {
            StreamLabelInfo info = StreamLabels.getInfo(this.id);
            return info != null ? info.name : this.id;
        }

        public String getDescription() {
            StreamLabelInfo info = StreamLabels.getInfo(this.id);
            return info != null ? info.description : null;
        }

        public boolean isValid() {
            return !StringUtil.isNullOrEmpty(this.id) && !this.id.contains(" ");
        }

        public boolean isEditable() {
            return StreamLabels.isEditableLabel(this.id);
        }

        public String toString() {
            return this.getId();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StreamLabel other = (StreamLabel)obj;
            return Objects.equals(this.id, other.id);
        }

        public int hashCode() {
            int hash = 5;
            hash = 23 * hash + Objects.hashCode(this.id);
            return hash;
        }

        @Override
        public int compareTo(StreamLabel o) {
            return this.id.compareToIgnoreCase(o.id);
        }
    }
}

