/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.lang.Language;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TokenInfo {
    public final String name;
    public final String userId;
    public final boolean valid;
    public final String clientId;
    public final Set<String> scopes;
    public final long expiresIn;

    public TokenInfo() {
        this.valid = false;
        this.name = null;
        this.userId = null;
        this.clientId = null;
        this.scopes = new HashSet<String>();
        this.expiresIn = -1L;
    }

    public TokenInfo(String name, String userId, String clientId, Collection<String> scopes, long expiresIn) {
        this.name = name;
        this.userId = userId;
        this.valid = true;
        this.clientId = clientId;
        this.scopes = new HashSet<String>(scopes);
        this.expiresIn = expiresIn;
    }

    public boolean hasScope(String scope) {
        return this.scopes.contains(scope);
    }

    public boolean hasScope(Scope scope) {
        return this.scopes.contains(scope.scope);
    }

    public boolean hasChatAccess() {
        return this.hasScope(Scope.CHAT_READ) && this.hasScope(Scope.CHAT_EDIT);
    }

    public static void main(String[] args) {
        System.out.println(ScopeCategory.getUncategorized());
    }

    public static enum Scope {
        CHAT_READ("chat:read", "chatRead"),
        CHAT_EDIT("chat:edit", "chatWrite"),
        WHISPER_READ("whispers:read", "whisperRead"),
        WHISPER_EDIT("whispers:edit", "whisperWrite"),
        WHISPER_MANAGE("user:manage:whispers", "whisperManage"),
        EDITOR("channel_editor", "editor"),
        EDIT_BROADCAST("channel:manage:broadcast", "broadcast"),
        COMMERICALS("channel_commercial", "commercials"),
        FOLLOWS("user:read:follows", "follows"),
        CHANNEL_FOLLOWERS("moderator:read:followers", "viewFollowers"),
        SUBSCRIBERS("channel:read:subscriptions", "subscribers"),
        CHAN_MOD("channel:moderate", "chanMod"),
        AUTOMOD("moderator:manage:automod", "automod"),
        BLOCKED_READ("moderator:read:blocked_terms", "blockedRead"),
        BLOCKED_MANAGE("moderator:manage:blocked_terms", "blockedManage"),
        READ_POINTS("channel:read:redemptions", "points"),
        ANNOUNCEMENTS("moderator:manage:announcements", "announcements"),
        MANAGE_BANS("moderator:manage:banned_users", "manageBans"),
        MANAGE_CHAT("moderator:manage:chat_settings", "manageChat"),
        MANAGE_MODS("channel:manage:moderators", "manageMods"),
        MANAGE_VIPS("channel:manage:vips", "manageVips"),
        MANAGE_MSGS("moderator:manage:chat_messages", "manageMsgs"),
        MANAGE_SHIELD("moderator:manage:shield_mode", "manageShield"),
        MANAGE_COLOR("user:manage:chat_color", "manageColor"),
        MANAGE_RAIDS("channel:manage:raids", "manageRaids"),
        MANAGE_POLLS("channel:manage:polls", "managePolls"),
        MANAGE_SHOUTOUTS("moderator:manage:shoutouts", "manageShoutouts"),
        MANAGE_WARNINGS("moderator:manage:warnings", "manageWarnings"),
        MANAGE_UNBAN_REQUESTS("moderator:manage:unban_requests", "manageUnbanRequests"),
        READ_MODS("moderator:read:moderators", "readMods"),
        READ_VIPS("moderator:read:vips", "readVips"),
        READ_SUSPICIOUS_USERS("moderator:read:suspicious_users", "readSuspiciousUsers"),
        CLIPS_EDIT("clips:edit", "editClips"),
        USER_READ_CHAT("user:read:chat", "userReadChat"),
        USER_WRITE_CHAT("user:write:chat", "userWriteChat");

        public String scope;
        public String label;
        public String description;

        private Scope(String scope, String langKey) {
            this.scope = scope;
            this.label = Language.getString("login.access." + langKey);
            this.description = Language.getString("login.access." + langKey + ".tip", false);
        }

        public static Scope fromScopeString(String scopeString) {
            for (Scope scope : Scope.values()) {
                if (!scope.scope.equals(scopeString)) continue;
                return scope;
            }
            return null;
        }
    }

    public static enum ScopeCategory {
        BASIC("basic", Scope.CHAT_READ, Scope.CHAT_EDIT, Scope.USER_READ_CHAT, Scope.USER_WRITE_CHAT, Scope.WHISPER_READ, Scope.WHISPER_EDIT, Scope.WHISPER_MANAGE, Scope.MANAGE_COLOR, Scope.FOLLOWS, Scope.CLIPS_EDIT),
        MODERATION("moderation", Scope.MANAGE_CHAT, Scope.MANAGE_WARNINGS, Scope.MANAGE_BANS, Scope.MANAGE_MSGS, Scope.CHAN_MOD, Scope.AUTOMOD, Scope.BLOCKED_READ, Scope.BLOCKED_MANAGE, Scope.ANNOUNCEMENTS, Scope.MANAGE_SHIELD, Scope.MANAGE_SHOUTOUTS, Scope.CHANNEL_FOLLOWERS, Scope.MANAGE_UNBAN_REQUESTS, Scope.READ_MODS, Scope.READ_VIPS, Scope.READ_SUSPICIOUS_USERS),
        BROADCASTER("broadcaster", Scope.MANAGE_MODS, Scope.MANAGE_VIPS, Scope.EDITOR, Scope.EDIT_BROADCAST, Scope.COMMERICALS, Scope.SUBSCRIBERS, Scope.MANAGE_RAIDS, Scope.MANAGE_POLLS, Scope.READ_POINTS);

        public List<Scope> scopes;
        public String label;

        private ScopeCategory(String langKey, Scope ... scopes) {
            this.scopes = Arrays.asList(scopes);
            this.label = Language.getString("login.accessCategory." + langKey);
        }

        public static List<Scope> getUncategorized() {
            ArrayList<Scope> result = new ArrayList<Scope>(Arrays.asList(Scope.values()));
            result.removeIf(scope -> ScopeCategory.getCategory(scope) != null);
            return result;
        }

        public static ScopeCategory getCategory(Scope scope) {
            for (ScopeCategory cat : ScopeCategory.values()) {
                if (!cat.scopes.contains((Object)scope)) continue;
                return cat;
            }
            return null;
        }
    }
}

