/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.Room;
import chatty.User;
import chatty.util.CachedBulkManager;
import chatty.util.StringUtil;
import chatty.util.api.BadgeManager;
import chatty.util.api.BlockedTermsManager;
import chatty.util.api.ChannelInfoManager;
import chatty.util.api.ChannelStatus;
import chatty.util.api.CheerEmoticonManager2;
import chatty.util.api.EmoticonManager2;
import chatty.util.api.Follower;
import chatty.util.api.FollowerManager;
import chatty.util.api.Requests;
import chatty.util.api.ResultManager;
import chatty.util.api.SendMessageResult;
import chatty.util.api.StreamCategory;
import chatty.util.api.StreamInfo;
import chatty.util.api.StreamInfoListener;
import chatty.util.api.StreamInfoManager;
import chatty.util.api.StreamLabels;
import chatty.util.api.TwitchApiResultListener;
import chatty.util.api.UserIDs;
import chatty.util.api.UserInfo;
import chatty.util.api.UserInfoManager;
import chatty.util.api.eventsub.EventSubAddResult;
import chatty.util.api.eventsub.EventSubSubs;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class TwitchApi {
    private static final Logger LOGGER = Logger.getLogger(TwitchApi.class.getName());
    public static final int CACHED_EMOTICONS_EXPIRE_AFTER = 86400;
    public static final int TOKEN_CHECK_DELAY = 600;
    private final TwitchApiResultListener resultListener;
    protected final StreamInfoManager streamInfoManager;
    protected final EmoticonManager2 emoticonManager2;
    protected final CheerEmoticonManager2 cheersManager2;
    protected final FollowerManager followerManager;
    protected final FollowerManager subscriberManager;
    protected final BadgeManager badgeManager;
    protected final UserIDs userIDs;
    protected final ChannelInfoManager channelInfoManager;
    protected final CachedBulkManager<Req, Boolean> m;
    protected final ResultManager resultManager;
    protected final UserInfoManager userInfoManager;
    protected final BlockedTermsManager blockedTermsManager;
    private volatile Long tokenLastChecked = 0L;
    protected volatile String defaultToken;
    protected volatile String localUserId;
    protected final Requests requests;
    public static String[] ANNOUNCEMENT_COLORS = new String[]{"", "primary", "blue", "green", "orange", "purple"};
    public static final String CHAT_SETTINGS_EMOTEONLY = "emote_mode";
    public static final String CHAT_SETTINGS_FOLLOWER_MODE = "follower_mode";
    public static final String CHAT_SETTINGS_FOLLOWER_MODE_DURATION = "follower_mode_duration";
    public static final String CHAT_SETTINGS_SLOWMODE = "slow_mode";
    public static final String CHAT_SETTINGS_SLOWMODE_TIME = "slow_mode_wait_time";
    public static final String CHAT_SETTINGS_SUBONLY = "subscriber_mode";
    public static final String CHAT_SETTINGS_UNIQUE = "unique_chat_mode";

    public TwitchApi(TwitchApiResultListener apiResultListener, StreamInfoListener streamInfoListener) {
        this.resultListener = apiResultListener;
        this.streamInfoManager = new StreamInfoManager(this, streamInfoListener);
        this.cheersManager2 = new CheerEmoticonManager2(this, this.resultListener);
        this.followerManager = new FollowerManager(Follower.Type.FOLLOWER, this, this.resultListener);
        this.subscriberManager = new FollowerManager(Follower.Type.SUBSCRIBER, this, this.resultListener);
        this.badgeManager = new BadgeManager(this);
        this.requests = new Requests(this, this.resultListener);
        this.channelInfoManager = new ChannelInfoManager(this, this.resultListener);
        this.userIDs = new UserIDs(this);
        this.userInfoManager = new UserInfoManager(this);
        this.emoticonManager2 = new EmoticonManager2(this.resultListener, this.requests);
        this.blockedTermsManager = new BlockedTermsManager(this.requests);
        this.m = new CachedBulkManager<Req, Boolean>(new CachedBulkManager.Requester<Req, Boolean>(){

            @Override
            public void request(CachedBulkManager<Req, Boolean> manager, Set<Req> asap, Set<Req> normal, Set<Req> backlog) {
                Set<Req> requests = manager.makeAndSetRequested(asap, normal, backlog, 1);
                Req req = requests.iterator().next();
                if (req.request != null) {
                    req.request.run();
                }
            }
        }, "[Api] ", 0);
        this.resultManager = new ResultManager();
    }

    protected void setReceived(String requestId) {
        this.m.setResult(new Req(requestId, null), Boolean.TRUE);
    }

    protected void setError(String requestId) {
        this.m.setError((Req[])new Req[]{new Req(requestId, null)});
    }

    protected void setNotFound(String requestId) {
        this.m.setNotFound((Req[])new Req[]{new Req(requestId, null)});
    }

    public void getEmotesByChannelId(String stream, String id, boolean refresh) {
        if (id != null) {
            this.getEmotesByChannelId2(stream, id, refresh);
        } else {
            this.userIDs.getUserIDsAsap(r -> {
                if (!r.hasError()) {
                    this.getEmotesByChannelId2(stream, r.getId(stream), refresh);
                }
            }, stream);
        }
    }

    private void getEmotesByChannelId2(String stream, String id, boolean refresh) {
        int options = 34;
        if (refresh) {
            options |= 8;
        }
        String requestId = "channel_emotes:" + id;
        this.m.query(null, options, (Req[])new Req[]{new Req(requestId, () -> this.requests.requestEmotesByChannelId(stream, id, requestId))});
    }

    public void getEmotesBySets(String ... emotesets) {
        this.getEmotesBySets(new HashSet<String>(Arrays.asList(emotesets)));
    }

    public void getEmotesBySets(Set<String> emotesets) {
        this.emoticonManager2.addEmotesets(emotesets);
    }

    public void refreshEmotes() {
        this.emoticonManager2.refresh();
    }

    public void refreshSets(Set<String> emotesets) {
        this.emoticonManager2.refresh(emotesets);
    }

    public void requestEmotesNow() {
        this.emoticonManager2.requestNow();
    }

    public void getGlobalBadges(boolean forceRefresh) {
        this.badgeManager.requestGlobalBadges(forceRefresh);
    }

    public void getRoomBadges(String room, boolean forceRefresh) {
        this.badgeManager.requestBadges(room, forceRefresh);
    }

    public void getCheers(String room, boolean forceRefresh) {
        this.cheersManager2.request(room, forceRefresh);
    }

    public void getChannelStatus(String stream) {
        this.getChannelStatus(stream, null);
    }

    public void getChannelStatus(String stream, String id) {
        if (id != null) {
            this.requests.getChannelStatus(id, stream);
        } else {
            this.userIDs.getUserIDsAsap(r -> {
                if (r.hasError()) {
                    this.resultListener.receivedChannelStatus(ChannelStatus.createInvalid(null, stream), RequestResultCode.FAILED);
                } else {
                    this.requests.getChannelStatus(r.getId(stream), stream);
                }
            }, stream);
        }
    }

    public void getStreamLabels() {
        StreamLabels.request(this.requests);
    }

    public void getFollowers(String stream, boolean forceRefresh) {
        this.followerManager.request(stream, forceRefresh);
    }

    public Follower getSingleFollower(String stream, String streamId, String user, String userId, boolean refresh) {
        return this.followerManager.getSingleFollower(stream, streamId, user, userId, refresh);
    }

    public void getSubscribers(String stream, boolean forceRefresh) {
        this.subscriberManager.request(stream, forceRefresh);
    }

    public UserInfo getCachedUserInfo(String channel, Consumer<UserInfo> result) {
        return this.userInfoManager.getCached(channel, result);
    }

    public void getCachedUserInfo(List<String> logins, Consumer<Map<String, UserInfo>> result) {
        this.userInfoManager.getCached(null, logins, result);
    }

    public UserInfo getCachedUserInfoById(String id, Consumer<UserInfo> result) {
        return this.userInfoManager.getCachedById(id, result);
    }

    public void getCachedUserInfoById(List<String> ids, Consumer<Map<String, UserInfo>> result) {
        this.userInfoManager.getCachedById(null, ids, result);
    }

    public UserInfo getCachedOnlyUserInfo(String login) {
        return this.userInfoManager.getCachedOnly(login);
    }

    public StreamInfo getStreamInfo(String stream, Set<String> streams) {
        if (streams == null) {
            streams = new HashSet<String>();
        }
        return this.streamInfoManager.getStreamInfo(stream, streams);
    }

    public StreamInfo getCachedStreamInfo(String stream) {
        return this.streamInfoManager.getCachedStreamInfo(stream);
    }

    public void getFollowedStreams(String token) {
        this.streamInfoManager.getFollowedStreams(token);
    }

    public void manualRefreshStreams() {
        this.streamInfoManager.manualRefresh();
    }

    public void setToken(String token) {
        this.defaultToken = token;
    }

    public void setLocalUserId(String userId) {
        this.localUserId = userId;
    }

    protected void accessDenied() {
        this.resultListener.accessDenied();
    }

    public void checkToken() {
        if (!StringUtil.isNullOrEmpty(this.defaultToken) && (System.currentTimeMillis() - this.tokenLastChecked) / 1000L > 600L) {
            LOGGER.info("Checking token..");
            this.tokenLastChecked = System.currentTimeMillis();
            this.requests.verifyToken(this.defaultToken);
        }
    }

    public void verifyToken(String token) {
        this.requests.verifyToken(token);
    }

    public String getToken() {
        return this.defaultToken;
    }

    public void revokeToken(String token) {
        this.requests.revokeToken(token);
    }

    public void setUserId(String userName, String userId) {
        this.userIDs.setUserId(userName, userId);
    }

    public void waitForUserId(UserIDs.UserIdResultListener listener, String ... names) {
        this.userIDs.waitForUserIDs(listener, names);
    }

    public void getUserId(UserIDs.UserIdResultListener listener, String ... names) {
        this.userIDs.getUserIDs(listener, names);
    }

    public void getUserIdAsap(UserIDs.UserIdResultListener listener, String ... names) {
        this.userIDs.getUserIDsAsap(listener, names);
    }

    public void requestUserId(String ... names) {
        this.userIDs.requestUserIDs(names);
    }

    public void getUserIDsTest2(String usernames) {
        UserIDs.UserIdResult result = this.userIDs.requestUserIDs(usernames.split(" "));
        if (result != null) {
            System.out.println(result.getValidIDs());
        }
    }

    public void getUserIDsTest3(String usernames) {
        this.userIDs.waitForUserIDs(r -> System.out.println(r.getValidIDs()), usernames.split(" "));
    }

    public void putChannelInfoNew(ChannelStatus info) {
        this.userIDs.getUserIDsAsap(r -> {
            if (r.hasError()) {
                this.resultListener.putChannelInfoResult(RequestResultCode.FAILED, "Could not get user id");
            } else {
                String streamId = r.getId(info.channelLogin);
                if (!info.hasCategoryId()) {
                    this.performGameSearch(info.category.name, categories -> {
                        boolean categoryFound = false;
                        for (StreamCategory category : categories) {
                            if (!category.nameMatches(info.category)) continue;
                            this.requests.putChannelInfoNew(streamId, info.changeCategory(category), this.defaultToken);
                            categoryFound = true;
                        }
                        if (!categoryFound) {
                            LOGGER.warning("Stream Category " + info.category.name + " not found");
                            this.resultListener.putChannelInfoResult(RequestResultCode.FAILED, "Category not found");
                        }
                    });
                } else {
                    this.requests.putChannelInfoNew(streamId, info, this.defaultToken);
                }
            }
        }, info.channelLogin);
    }

    public void performGameSearch(String search, ResultManager.CategoryResult listener) {
        this.requests.getGameSearch(search, listener);
    }

    public void getBlockedTerms(String streamName, boolean refresh, Consumer<BlockedTermsManager.BlockedTerms> listener) {
        this.userIDs.getUserIDsAsap(r -> {
            if (r.hasError()) {
                listener.accept(null);
            } else {
                String streamId = r.getId(streamName);
                this.blockedTermsManager.getBlockedTerms(streamId, streamName, refresh, listener);
            }
        }, streamName);
    }

    public void addBlockedTerm(String streamName, String text, Consumer<BlockedTermsManager.BlockedTerm> listener) {
        this.userIDs.getUserIDsAsap(r -> {
            if (r.hasError()) {
                listener.accept(null);
            } else {
                String streamId = r.getId(streamName);
                this.requests.addBlockedTerm(streamId, streamName, text, listener);
            }
        }, streamName);
    }

    public void removeBlockedTerm(BlockedTermsManager.BlockedTerm term, Consumer<BlockedTermsManager.BlockedTerm> listener) {
        this.requests.removeBlockedTerm(term, listener);
    }

    public void runCommercial(String stream, int length) {
        this.userIDs.getUserIDsAsap(r -> {
            if (r.hasError()) {
                this.resultListener.runCommercialResult(stream, "Failed to resolve id", RequestResultCode.UNKNOWN);
            } else {
                this.requests.runCommercial(r.getId(stream), stream, length);
            }
        }, stream);
    }

    public void autoModApprove(String msgId) {
        this.requests.autoMod(AutoModAction.ALLOW, msgId, this.defaultToken, this.localUserId);
    }

    public void autoModDeny(String msgId) {
        this.requests.autoMod(AutoModAction.DENY, msgId, this.defaultToken, this.localUserId);
    }

    public void createStreamMarker(String stream, String description, StreamMarkerResult listener) {
        this.userIDs.getUserIDsAsap(r -> {
            if (r.hasError()) {
                listener.streamMarkerResult("Failed to resolve channel id");
            } else {
                this.requests.createStreamMarker(r.getId(stream), description, this.defaultToken, listener);
            }
        }, stream);
    }

    public void createClip(String stream) {
        this.userIDs.getUserIDsAsap(r -> {
            if (r.hasError()) {
                this.resultManager.inform(ResultManager.Type.CREATE_CLIP, l -> l.result(null, null, "Failed to resolve channel id"));
            } else {
                this.requests.createClip(r.getId(stream));
            }
        }, stream);
    }

    public void sendAnnouncement(String stream, String message, String color) {
        this.userIDs.getUserIDsAsap(r -> {
            if (r.hasError()) {
                this.resultListener.errorMessage("Failed to resolve channel id");
            } else {
                this.requests.sendAnnouncement(r.getId(stream), message, color);
            }
        }, stream);
    }

    public void sendChatMessage(String stream, String message, String replyToMsgId, Consumer<SendMessageResult> listener) {
        this.userIDs.getUserIDsAsap(r -> {
            if (r.hasError()) {
                listener.accept(new SendMessageResult(false, null, "Failed to resolve channel id"));
            } else {
                this.requests.sendChatMessage(r.getId(stream), message, replyToMsgId, listener);
            }
        }, stream);
    }

    public void subscribe(ResultManager.Type type, Object listener) {
        this.resultManager.subscribe(type, listener);
    }

    public void subscribe(ResultManager.Type type, Object unique, Object listener) {
        this.resultManager.subscribe(type, unique, listener);
    }

    public void ban(User targetUser, int length, String reason, SimpleRequestResultListener listener) {
        this.runWithUserIds(targetUser, listener, (streamId, targetId) -> this.requests.ban((String)streamId, (String)targetId, length, reason, listener));
    }

    public void unban(User targetUser, SimpleRequestResultListener listener) {
        this.runWithUserIds(targetUser, listener, (streamId, targetId) -> this.requests.unban((String)streamId, (String)targetId, listener));
    }

    public void deleteMsg(Room room, String msgId, SimpleRequestResultListener listener) {
        this.runWithStreamId(room, listener, streamId -> this.requests.deleteMsg((String)streamId, msgId, listener));
    }

    public void shoutout(User targetUser, SimpleRequestResultListener listener) {
        this.runWithUserIds(targetUser, listener, (streamId, targetId) -> this.requests.shoutout((String)streamId, (String)targetId, listener));
    }

    public void warn(User targetUser, String reason, SimpleRequestResultListener listener) {
        this.runWithUserIds(targetUser, listener, (streamId, targetId) -> this.requests.warn((String)streamId, (String)targetId, reason, listener));
    }

    public void setVip(User targetUser, boolean add, SimpleRequestResultListener listener) {
        this.runWithUserIds(targetUser, listener, (streamId, targetId) -> this.requests.setVip((String)streamId, (String)targetId, add, listener));
    }

    public void setModerator(User targetUser, boolean add, SimpleRequestResultListener listener) {
        this.runWithUserIds(targetUser, listener, (streamId, targetId) -> this.requests.setModerator((String)streamId, (String)targetId, add, listener));
    }

    public void requestModerators(Room room, SimpleRequestResultListener listener) {
        this.runWithStreamId(room, listener, streamId -> this.requests.getModerators((String)streamId, listener));
    }

    public void requestVips(Room room, SimpleRequestResultListener listener) {
        this.runWithStreamId(room, listener, streamId -> this.requests.getVips((String)streamId, listener));
    }

    public void startRaid(Room room, String targetUsername, SimpleRequestResultListener listener) {
        this.userIDs.getUserIDsAsap(r -> {
            if (r.hasError()) {
                listener.accept(SimpleRequestResult.error("Invalid username"));
            } else {
                this.requests.startRaid(r.getId(room.getStream()), r.getId(targetUsername), listener);
            }
        }, room.getStream(), targetUsername);
    }

    public void cancelRaid(Room room, SimpleRequestResultListener listener) {
        this.runWithStreamId(room, listener, streamId -> this.requests.cancelRaid((String)streamId, listener));
    }

    public void setShieldMode(Room room, boolean enabled, SimpleRequestResultListener listener) {
        this.runWithStreamId(room, listener, streamId -> this.requests.setShieldMode(room.getStream(), (String)streamId, enabled, listener));
    }

    public void getShieldMode(Room room, boolean oncePerStream) {
        String requestId = "getShieldMode:" + room.getStream();
        if (oncePerStream) {
            int options = 34;
            this.m.query(null, options, (Req[])new Req[]{new Req(requestId, () -> this.runWithStreamId(room, null, streamId -> this.requests.getShieldMode(room.getStream(), (String)streamId, requestId)))});
        } else {
            this.runWithStreamId(room, null, streamId -> this.requests.getShieldMode(room.getStream(), (String)streamId, requestId));
        }
    }

    public void removeShieldModeCache(Room room) {
        String requestId = "getShieldMode:" + room.getStream();
        this.m.removeCachedValue(new Req(requestId, null));
    }

    public void whisper(String targetUsername, String msg, SimpleRequestResultListener listener) {
        this.userIDs.getUserIDsAsap(r -> {
            if (r.hasError()) {
                listener.accept(SimpleRequestResult.error("Invalid username"));
            } else {
                this.requests.whisper(r.getId(targetUsername), msg, listener);
            }
        }, targetUsername);
    }

    public void setColor(String color, SimpleRequestResultListener listener) {
        this.requests.setColor(color, listener);
    }

    public void updateChatSettings(Room room, SimpleRequestResultListener listener, Object ... data) {
        this.runWithStreamId(room, listener, streamId -> this.requests.updateChatSettings((String)streamId, data, listener));
    }

    private void runWithUserIds(User targetUser, SimpleRequestResultListener listener, BiConsumer<String, String> run) {
        String roomId = targetUser.getRoom().getStreamId();
        String targetId = targetUser.getId();
        if (roomId == null || targetId == null) {
            this.userIDs.getUserIDsAsap(r -> {
                if (r.hasError()) {
                    listener.accept(SimpleRequestResult.error("Invalid username"));
                } else {
                    run.accept(r.getId(targetUser.getRoom().getStream()), r.getId(targetUser.getName()));
                }
            }, targetUser.getRoom().getStream(), targetUser.getName());
        } else {
            run.accept(roomId, targetId);
        }
    }

    private void runWithStreamId(Room room, SimpleRequestResultListener listener, Consumer<String> run) {
        String streamId = room.getStreamId();
        if (streamId == null) {
            this.userIDs.getUserIDsAsap(r -> {
                if (r.hasError() && listener != null) {
                    listener.accept(SimpleRequestResult.error("Invalid username"));
                } else {
                    run.accept(r.getId(room.getStream()));
                }
            }, room.getStream());
        } else {
            run.accept(streamId);
        }
    }

    public void test() {
        this.requests.test();
    }

    public void addEventSub(String body, Consumer<EventSubAddResult> listener) {
        this.requests.addEventSub(body, listener);
    }

    public void removeEventSub(String id, Consumer<Integer> listener) {
        this.requests.removeEventSub(id, listener);
    }

    public void getEventSubSubs(Consumer<EventSubSubs> listener) {
        this.requests.getEventSubSubs(null, listener, null);
    }

    private static class Req {
        public final String key;
        public final Runnable request;

        public Req(String key, Runnable request) {
            this.key = key;
            this.request = request;
        }

        public String toString() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Req other = (Req)obj;
            return Objects.equals(this.key, other.key);
        }

        public int hashCode() {
            int hash = 5;
            hash = 37 * hash + Objects.hashCode(this.key);
            return hash;
        }
    }

    public static enum AutoModAction {
        ALLOW,
        DENY;

    }

    public static interface StreamMarkerResult {
        public void streamMarkerResult(String var1);
    }

    public static interface SimpleRequestResultListener {
        public void accept(SimpleRequestResult var1);
    }

    public static class SimpleRequestResult {
        public final String error;
        public final String result;

        private SimpleRequestResult(String result, String error) {
            this.result = result;
            this.error = error;
        }

        public static SimpleRequestResult error(String errorMessage) {
            return new SimpleRequestResult(null, errorMessage);
        }

        public static SimpleRequestResult ok() {
            return new SimpleRequestResult(null, null);
        }

        public static SimpleRequestResult result(String result) {
            return new SimpleRequestResult(result, null);
        }
    }

    public static enum RequestResultCode {
        ACCESS_DENIED,
        SUCCESS,
        FAILED,
        NOT_FOUND,
        RUNNING_COMMERCIAL,
        INVALID_CHANNEL,
        INVALID_STREAM_STATUS,
        UNKNOWN;

    }

    public static enum AutoModActionResult {
        SUCCESS(204, ""),
        ALREADY_PROCESSED(400, "Message already handled"),
        BAD_AUTH(401, "Access denied (check Main - Account for access)"),
        UNAUTHORIZED(403, "Access denied"),
        NOT_FOUND(404, "Invalid message id"),
        OTHER_ERROR(-1, "Unknown error");

        public final int responseCode;
        public final String errorMessage;

        private AutoModActionResult(int responseCode, String errorMessage) {
            this.responseCode = responseCode;
            this.errorMessage = errorMessage;
        }
    }
}

