/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.api.Requests;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class TwitchApiRequest
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(TwitchApiRequest.class.getName());
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int READ_TIMEOUT = 60000;
    private static final String CLIENT_ID = "spyiu9jqdnfjtwv6l1xjk5zgt8qb91l";
    private String url;
    private TwitchApiRequestResult origin;
    private String token;
    private String data = null;
    private String encoding;
    private int responseCode = -1;
    private String requestMethod = "GET";
    private String contentType = "application/json";
    private String apiVersion = null;
    private String error;
    private String info;

    public TwitchApiRequest(String url, String version) {
        this.url = url;
        this.apiVersion = version;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setData(String data, String requestMethod) {
        this.data = data;
        this.requestMethod = requestMethod;
    }

    public void setApiVersion(String version) {
        this.apiVersion = version;
    }

    public void setRequestType(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setOrigin(TwitchApiRequestResult origin) {
        this.origin = origin;
    }

    @Override
    public void run() {
        if (this.origin == null) {
            return;
        }
        String result = this.getUrl(this.url);
        this.origin.requestResult(this.url, result, this.responseCode, this.error, this.encoding, this.token, this.info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUrl(String targetUrl) {
        if (this.token != null) {
            LOGGER.info(this.requestMethod + " (" + this.apiVersion + "): " + Requests.filterToken(targetUrl, this.token) + " (using authorization)");
        } else {
            LOGGER.info(this.requestMethod + " (" + this.apiVersion + "): " + targetUrl);
        }
        Charset charset = Charset.forName("UTF-8");
        HttpURLConnection connection = null;
        try {
            StringBuilder response;
            URL url = new URL(targetUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(60000);
            if (this.apiVersion != null) {
                connection.setRequestProperty("Accept", "application/vnd.twitchtv." + this.apiVersion + "+json");
            }
            connection.setRequestProperty("Accept-Encoding", "gzip");
            connection.setRequestProperty("Client-ID", CLIENT_ID);
            if (this.token != null) {
                connection.setRequestProperty("Authorization", "OAuth " + this.token);
            }
            connection.setRequestMethod(this.requestMethod);
            if (this.data != null) {
                connection.setRequestProperty("Content-Type", this.contentType);
                connection.setDoOutput(true);
                try (OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), charset);){
                    out.write(this.data);
                }
                LOGGER.info("Sending data: " + this.data);
            }
            this.encoding = connection.getContentEncoding();
            InputStream input = connection.getInputStream();
            if ("gzip".equals(connection.getContentEncoding())) {
                input = new GZIPInputStream(input);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, charset));){
                String line;
                response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            String string = response.toString();
            return string;
        }
        catch (SocketTimeoutException ex) {
            this.error = ex.toString();
            String string = null;
            return string;
        }
        catch (IOException ex) {
            this.error = ex.toString();
            String string = null;
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    this.responseCode = connection.getResponseCode();
                }
                catch (IOException iOException) {}
                connection.disconnect();
            }
        }
    }

    public static interface TwitchApiRequestResult {
        public void requestResult(String var1, String var2, int var3, String var4, String var5, String var6, String var7);
    }
}

