/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.Helper;
import chatty.util.StringUtil;
import chatty.util.api.TwitchApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class UserIDs {
    private static final Logger LOGGER = Logger.getLogger(UserIDs.class.getName());
    private static final long CHECK_PENDING_DELAY = 10000L;
    private static final long REQUEST_DELAY = 5L;
    private static final long ERROR_PENALTY = 30L;
    private final Data data = new Data();
    private final Collection<Request> requests = new LinkedList<Request>();
    private final Set<String> requestPending = new HashSet<String>();
    private int errors = 0;
    private long lastRequest = 0L;
    private final TwitchApi api;

    public UserIDs(TwitchApi api) {
        this.api = api;
        Timer checkPending = new Timer("UserIDPending", true);
        checkPending.schedule(new TimerTask(){

            @Override
            public void run() {
                UserIDs.this.checkRequest();
            }
        }, 10000L, 10000L);
    }

    public void waitForUserIDs(UserIdResultListener result, String ... usernames) {
        Collection<String> names = this.prepareNames(usernames);
        this.addRequest(result, names, true);
        this.checkDoneRequests(true);
        this.checkRequest();
    }

    public void getUserIDsAsap(UserIdResultListener result, String ... usernames) {
        Collection<String> names = this.prepareNames(usernames);
        this.addRequest(result, names, false);
        this.checkDoneRequests(true);
        this.performRequest();
    }

    public void getUserIDs(UserIdResultListener result, String ... usernames) {
        Collection<String> names = this.prepareNames(usernames);
        this.getUserIDs(result, names);
    }

    public void getUserIDs(UserIdResultListener result, Collection<String> names) {
        this.addRequest(result, names, false);
        this.checkDoneRequests(true);
    }

    public synchronized UserIdResult requestUserIDs(String ... usernames) {
        Collection<String> names = this.prepareNames(usernames);
        UserIdResult result = this.getCachedResult(names);
        if (result == null || result.getValidIDs().size() < names.size()) {
            this.addRequest(null, names, false);
        }
        return result;
    }

    private Collection<String> prepareNames(String[] usernames) {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : usernames) {
            names.add(StringUtil.toLowerCase(name));
        }
        return names;
    }

    public void setUserId(String name, String id) {
        if (name == null || id == null || name.isEmpty() || id.isEmpty()) {
            return;
        }
        this.data.setId(StringUtil.toLowerCase(name), id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequestResult(Set<String> requestedNames, Map<String, String> result) {
        UserIDs userIDs = this;
        synchronized (userIDs) {
            this.requestPending.removeAll(requestedNames);
            if (result == null) {
                requestedNames.stream().forEach(n -> this.data.setError((String)n));
                ++this.errors;
            } else {
                for (String name : requestedNames) {
                    if (!result.keySet().contains(name)) {
                        this.data.setNotFound(name);
                        continue;
                    }
                    this.data.setId(name, result.get(name));
                }
                this.errors = this.errors > 0 ? this.errors - 1 : 0;
            }
        }
        this.checkDoneRequests(false);
    }

    private static Map<String, String> parseResult(String text) {
        if (text == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(text);
            JSONArray users = (JSONArray)root.get("users");
            for (Object o : users) {
                JSONObject user = (JSONObject)o;
                String id = (String)user.get("_id");
                String name = (String)user.get("name");
                if (id == null || name == null) continue;
                result.put(name, id);
            }
            return result;
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing userids: " + ex);
            return null;
        }
    }

    private synchronized void checkRequest() {
        long timePassed = System.currentTimeMillis() - this.lastRequest;
        if (timePassed > (5L + 30L * (long)this.errors) * 1000L) {
            this.performRequest();
        }
    }

    private synchronized void performRequest() {
        if (this.requests.isEmpty()) {
            return;
        }
        HashSet<String> namesToRequest = new HashSet<String>();
        this.requests.stream().forEach(r -> ((Request)r).usernames.stream().forEach(n -> {
            if (!this.requestPending.contains(n) && this.data.shouldRequest((String)n) && namesToRequest.size() < 100) {
                if (Helper.isValidStream(n)) {
                    namesToRequest.add((String)n);
                    this.requestPending.add((String)n);
                } else {
                    this.data.setNotFound((String)n);
                }
            }
        }));
        if (!namesToRequest.isEmpty()) {
            this.api.requests.requestUserIDs(namesToRequest);
            this.lastRequest = System.currentTimeMillis();
        } else {
            this.checkDoneRequests(false);
        }
    }

    private synchronized void addRequest(UserIdResultListener result, Collection<String> usernames, boolean wait) {
        this.requests.add(new Request(new HashSet<String>(usernames), result, wait));
    }

    private void checkDoneRequests(boolean onlyComplete) {
        Collection<Request> done = this.getDoneRequests(onlyComplete);
        if (done == null) {
            return;
        }
        for (Request r : done) {
            if (r.listener == null) continue;
            r.listener.result(r.getResult());
        }
        this.clearUp();
    }

    private synchronized Collection<Request> getDoneRequests(boolean onlyComplete) {
        if (this.requests.isEmpty()) {
            return null;
        }
        ArrayList<Request> result = new ArrayList<Request>();
        for (Request r : this.requests) {
            UserIdResult idResult = this.getCachedResult(r.usernames);
            if (idResult == null || r.wait && idResult.hasError() || onlyComplete && this.eligibleForRequest(r)) continue;
            r.setResult(idResult);
            result.add(r);
        }
        this.requests.removeAll(result);
        return result;
    }

    private synchronized UserIdResult getCachedResult(Collection<String> usernames) {
        Map<String, Entry> result = this.data.get(usernames);
        if (result.size() < usernames.size()) {
            return null;
        }
        return new UserIdResult(result);
    }

    private synchronized void clearUp() {
        if (!this.requests.isEmpty()) {
            Iterator<Request> it = this.requests.iterator();
            while (it.hasNext()) {
                if (this.eligibleForRequest(it.next())) continue;
                it.remove();
            }
        }
    }

    private boolean eligibleForRequest(Request request) {
        for (String name : request.usernames) {
            if (!this.data.shouldRequest(name)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
    }

    private static class Data {
        private final Map<String, Entry> data = new HashMap<String, Entry>();

        private Data() {
        }

        public synchronized void put(String name, Entry entry) {
            this.data.put(name, entry);
        }

        public synchronized boolean containsKey(String name) {
            return this.data.containsKey(name);
        }

        public synchronized Entry get(String name) {
            return this.data.get(name);
        }

        public synchronized boolean setId(String name, String id) {
            if (!this.data.containsKey(name) || this.get(name).id == null) {
                this.data.put(name, new Entry(name, id));
                return true;
            }
            return false;
        }

        public synchronized void setNotFound(String name) {
            Entry entry;
            if (!this.data.containsKey(name)) {
                entry = new Entry(name, null);
                this.data.put(name, entry);
            } else {
                entry = this.data.get(name);
            }
            entry.notFound = true;
            entry.errors += 4;
        }

        public synchronized void setError(String name) {
            if (!this.data.containsKey(name)) {
                Entry entry = new Entry(name, null);
                this.data.put(name, entry);
            }
        }

        public synchronized Map<String, Entry> get(Collection<String> usernames) {
            HashMap<String, Entry> result = new HashMap<String, Entry>();
            for (String name : usernames) {
                if (!this.data.containsKey(name)) continue;
                result.put(name, this.data.get(name));
            }
            return result;
        }

        public synchronized boolean hasId(String name) {
            return this.data.containsKey(name) && this.data.get(name).id != null;
        }

        public synchronized boolean shouldRequest(String name) {
            if (!this.data.containsKey(name)) {
                return true;
            }
            Entry entry = this.data.get(name);
            return entry.id == null && entry.errors < 10;
        }
    }

    public static interface UserIdResultListener {
        public void result(UserIdResult var1);
    }

    public static class UserIdResult {
        private final Map<String, String> data = new HashMap<String, String>();
        private boolean hasError;
        private String error;

        private UserIdResult(Map<String, Entry> result) {
            for (Entry entry : result.values()) {
                if (entry.id != null) {
                    this.data.put(entry.name, entry.id);
                }
                if (entry.id == null) {
                    this.hasError = true;
                }
                if (!entry.notFound) continue;
                this.error = "User not found";
            }
        }

        public boolean hasError() {
            return this.hasError;
        }

        public String getError() {
            if (this.hasError && this.error == null) {
                return "Unknown Error";
            }
            return this.error;
        }

        public Collection<String> getValidIDs() {
            return this.data.values();
        }

        public Map<String, String> getData() {
            return this.data;
        }

        public String getId(String name) {
            return this.data.get(StringUtil.toLowerCase(name));
        }

        public String toString() {
            return this.data.toString() + "/" + this.getError();
        }
    }

    private static class Request {
        private final Set<String> usernames;
        private final UserIdResultListener listener;
        private final boolean wait;
        private UserIdResult result;

        Request(Set<String> usernames, UserIdResultListener listener, boolean wait) {
            this.usernames = usernames;
            this.listener = listener;
            this.wait = wait;
        }

        public synchronized void setResult(UserIdResult result) {
            this.result = result;
        }

        public synchronized UserIdResult getResult() {
            return this.result;
        }

        public String toString() {
            return String.format("{%s/%s}", this.usernames.toString(), this.wait);
        }
    }

    private static class Entry {
        private final String name;
        private final String id;
        private volatile boolean notFound;
        private int errors;

        public Entry(String name, String id) {
            this.name = name;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public boolean notFound() {
            return this.notFound;
        }

        public int errorCount() {
            return this.errors;
        }

        public String toString() {
            return this.name + "/" + this.id + "/" + (this.notFound ? "n/a" : "") + "/" + this.errors;
        }
    }
}

