/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.CachedBulkManager;
import chatty.util.api.TwitchApi;
import chatty.util.api.UserInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class UserInfoManager {
    private static final Logger LOGGER = Logger.getLogger(UserInfoManager.class.getName());
    private final CachedBulkManager<String, UserInfo> perLogin;
    private final CachedBulkManager<String, UserInfo> perId;

    public UserInfoManager(final TwitchApi api) {
        this.perLogin = new CachedBulkManager<String, UserInfo>(new CachedBulkManager.Requester<String, UserInfo>(){

            @Override
            public void request(CachedBulkManager<String, UserInfo> manager, Set<String> asap, Set<String> normal, Set<String> backlog) {
                Set<String> toRequest = manager.makeAndSetRequested(asap, normal, backlog, 100);
                api.requests.requestUserInfo(toRequest);
            }
        }, 0);
        this.perId = new CachedBulkManager((manager, asap, normal, backlog) -> {
            Set<String> toRequest = manager.makeAndSetRequested(asap, normal, backlog, 100);
            api.requests.requestUserInfoById(toRequest);
        }, 0);
    }

    public UserInfo getCachedOnly(String login) {
        return this.perLogin.get(login);
    }

    public UserInfo getCached(String login, Consumer<UserInfo> result) {
        return this.perLogin.getOrQuerySingle(r -> result.accept((UserInfo)r.get(login)), 2, login);
    }

    public UserInfo getCachedById(String id, Consumer<UserInfo> result) {
        return this.perId.getOrQuerySingle(r -> result.accept((UserInfo)r.get(id)), 2, id);
    }

    public void getCached(Object unique, List<String> logins, Consumer<Map<String, UserInfo>> resultListener) {
        this.perLogin.query(unique, (CachedBulkManager.ResultListener<String, UserInfo>)result -> resultListener.accept(result.getResults()), 2, (Collection<String>)logins);
    }

    public void getCachedById(Object unique, List<String> ids, Consumer<Map<String, UserInfo>> resultListener) {
        this.perId.query(unique, (CachedBulkManager.ResultListener<String, UserInfo>)result -> resultListener.accept(result.getResults()), 2, (Collection<String>)ids);
    }

    public void resultReceived(Set<String> requested, Collection<UserInfo> result) {
        if (result == null) {
            this.perLogin.setError((Collection<String>)requested);
        } else {
            HashSet<String> notFound = new HashSet<String>(requested);
            for (UserInfo info : result) {
                notFound.remove(info.login);
                this.perLogin.setResult(info.login, info);
                this.perId.setResult(info.id, info);
            }
            this.perLogin.setNotFound((Collection<String>)notFound);
        }
    }

    public static Collection<UserInfo> parseJSON(String json) {
        if (json == null) {
            return null;
        }
        try {
            ArrayList<UserInfo> result = new ArrayList<UserInfo>();
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            JSONArray data = (JSONArray)root.get("data");
            for (Object o : data) {
                UserInfo info;
                if (!(o instanceof JSONObject) || (info = UserInfo.create((JSONObject)o)) == null) continue;
                result.add(info);
            }
            return result;
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing user info: " + ex);
            return null;
        }
    }

    public void idResultReceived(Set<String> requested, Collection<UserInfo> result) {
        if (result == null) {
            this.perId.setError((Collection<String>)requested);
        } else {
            HashSet<String> notFound = new HashSet<String>(requested);
            for (UserInfo info : result) {
                notFound.remove(info.id);
                this.perId.setResult(info.id, info);
                this.perLogin.setResult(info.login, info);
            }
            this.perId.setNotFound((Collection<String>)notFound);
        }
    }
}

