/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api.eventsub;

import chatty.util.api.eventsub.Topic;
import chatty.util.jws.JWSClient;
import chatty.util.jws.MessageHandler;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Connection
extends JWSClient {
    private static final int MAX_TOPICS = 300;
    private final MessageHandler handler;
    private final Map<Topic, Topic> topics;
    public final int id;
    private volatile String sessionId;
    private volatile Connection replacesConnection;
    private volatile int connectionTimeoutSeconds;

    public Connection(URI server, MessageHandler handler, int id) {
        super(server);
        this.handler = handler;
        this.topics = new HashMap<Topic, Topic>();
        this.id = id;
    }

    public void setConnectionTimeout(int seconds) {
        this.connectionTimeoutSeconds = seconds;
    }

    public void checkTimeout() {
        if (!this.isOpen() && this.getConnectionSeconds() > 30L) {
            return;
        }
        if (this.connectionTimeoutSeconds > 0) {
            if (this.getLastReceivedSecondsAgo() > (long)(this.connectionTimeoutSeconds * 2)) {
                this.forceReconnect();
            } else if (this.getLastReceivedSecondsAgo() > (long)this.connectionTimeoutSeconds) {
                this.reconnect();
            }
        }
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setReplacedConnection(Connection c) {
        this.replacesConnection = c;
    }

    public Connection getReplacedConnection() {
        return this.replacesConnection;
    }

    @Override
    public void handleConnect(JWSClient c) {
        this.handler.handleConnect(c);
    }

    @Override
    public void handleDisconnect(int code) {
        this.handler.handleDisconnect(code);
    }

    @Override
    public void handleReceived(String text) {
        this.handler.handleReceived(text);
    }

    @Override
    public void handleSent(String text) {
        this.handler.handleSent(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTopic(Topic topic) {
        Map<Topic, Topic> map = this.topics;
        synchronized (map) {
            if (this.topics.containsKey(topic)) {
                return true;
            }
            if (this.topics.size() >= 300) {
                return false;
            }
            this.topics.put(topic, topic);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic getTopic(Topic topic) {
        Map<Topic, Topic> map = this.topics;
        synchronized (map) {
            return this.topics.get(topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic removeTopic(Topic topic) {
        Map<Topic, Topic> map = this.topics;
        synchronized (map) {
            return this.topics.remove(topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Topic> getTopics() {
        Map<Topic, Topic> map = this.topics;
        synchronized (map) {
            return new HashSet<Topic>(this.topics.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic getTopicById(String id) {
        Map<Topic, Topic> map = this.topics;
        synchronized (map) {
            for (Topic topic : this.topics.values()) {
                if (!id.equals(topic.getId())) continue;
                return topic;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTopic(Topic topic) {
        Map<Topic, Topic> map = this.topics;
        synchronized (map) {
            return this.topics.containsKey(topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numTopics() {
        Map<Topic, Topic> map = this.topics;
        synchronized (map) {
            return this.topics.size();
        }
    }

    public String toString() {
        return this.getStatus();
    }
}

