/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api.eventsub;

import chatty.util.Debugging;
import chatty.util.api.TwitchApi;
import chatty.util.api.eventsub.Connection;
import chatty.util.api.eventsub.ConnectionsMessageHandler;
import chatty.util.api.eventsub.Message;
import chatty.util.api.eventsub.Topic;
import chatty.util.api.eventsub.payloads.SessionPayload;
import chatty.util.api.eventsub.payloads.SubscriptionPayload;
import chatty.util.jws.JWSClient;
import chatty.util.jws.MessageHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class Connections {
    private static final Logger LOGGER = Logger.getLogger(Connections.class.getName());
    private static final int MAX_CONNECTIONS = 3;
    private static final int MAX_RETRY_TOPIC_COUNT = 5;
    private final Map<Integer, Connection> connections;
    private final URI server;
    private final ConnectionsMessageHandler handler;
    private final TwitchApi api;
    private final Timer timer = new Timer("EventSub");
    private final Set<Topic> errorTopics = new HashSet<Topic>();
    private final Set<Topic> errorLimitReachedTopics = new HashSet<Topic>();
    private final Set<Topic> removedAuthTopics = new HashSet<Topic>();
    private final Set<Topic> toRemove = new HashSet<Topic>();
    private final Set<Topic> toAdd = new HashSet<Topic>();
    private final Set<Topic> requestPending = new HashSet<Topic>();
    private int totalCost = 0;
    private int maxTotalCost = 0;
    private int connIdCounter;

    public Connections(URI server, ConnectionsMessageHandler handler, TwitchApi api) {
        this.connections = new HashMap<Integer, Connection>();
        this.server = server;
        this.handler = handler;
        this.api = api;
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Connections.this.checkConnection();
                Connections.this.checkRetry();
                Connections.this.unregisterTopics();
                Connections.this.addTopics();
            }
        }, 5000L, 5000L);
    }

    public synchronized boolean addTopic(Topic topic) {
        if (this.hasTopic(topic) && !this.toRemove.contains(topic)) {
            Debugging.println("es", "Add Topic: %s (already added)", topic);
            return true;
        }
        if (this.toRemove.contains(topic)) {
            Debugging.println("es", "Add Topic: %s (try again later)", topic);
            this.toAdd.add(topic);
            return true;
        }
        return this.addTopicInternal(topic);
    }

    private synchronized boolean addTopicInternal(Topic topic) {
        for (Connection c : this.connections.values()) {
            if (!c.addTopic(topic)) continue;
            Debugging.println("es", "Add Topic: %s (added to %s)", topic, c.id);
            if (c.getSessionId() != null) {
                this.registerTopic(c, topic);
            }
            return true;
        }
        if (this.connections.size() < 3) {
            Connection c = this.addConnection(this.server);
            boolean result = c.addTopic(topic);
            Debugging.println("es", "Add Topic: %s (added to new %s)", topic, c.id);
            c.init();
            return result;
        }
        return false;
    }

    private synchronized Connection addConnection(URI server) {
        int connId = this.connIdCounter++;
        Connection c = new Connection(server, this.createHandler(connId), connId);
        c.setDebugPrefix(String.format(Locale.ROOT, "[EventSub][%d] ", connId));
        this.connections.put(connId, c);
        return c;
    }

    public synchronized void removeTopic(Topic topic) {
        Connection c;
        Debugging.println("es", "Remove Topic: %s", topic);
        this.errorLimitReachedTopics.remove(topic);
        this.errorTopics.remove(topic);
        this.removedAuthTopics.remove(topic);
        this.toAdd.remove(topic);
        Topic existingTopic = null;
        Iterator<Connection> iterator = this.connections.values().iterator();
        while (iterator.hasNext() && (existingTopic = (c = iterator.next()).getTopic(topic)) == null) {
        }
        if (existingTopic != null && !this.toRemove.contains(existingTopic)) {
            this.toRemove.add(existingTopic);
            this.unregisterTopic(existingTopic);
        }
    }

    private synchronized boolean removeTopicInternal(Topic topic) {
        Debugging.println("es", "Remove Topic: %s (internal)", topic);
        this.toRemove.remove(topic);
        for (Connection c : this.connections.values()) {
            if (c.removeTopic(topic) == null) continue;
            if (c.numTopics() == 0) {
                this.disconnect(c);
            }
            return true;
        }
        return false;
    }

    private void retryFailedTopic(boolean withCost) {
        if (this.errorLimitReachedTopics.isEmpty()) {
            return;
        }
        Iterator<Topic> it = this.errorLimitReachedTopics.iterator();
        Topic topic = null;
        while (it.hasNext()) {
            topic = it.next();
            if (topic.getCost() != 0 && !withCost) continue;
            it.remove();
            break;
        }
        if (topic != null) {
            LOGGER.info("[EventSub] Retrying: " + topic + " " + this.totalCost);
            this.addTopicInternal(topic);
        }
    }

    private synchronized void checkRetry() {
        if (!this.errorTopics.isEmpty()) {
            HashSet<Topic> retry = new HashSet<Topic>();
            for (Topic topic : this.errorTopics) {
                if (topic.shouldRequest()) {
                    retry.add(topic);
                }
                if (retry.size() < 5) continue;
                break;
            }
            this.errorTopics.removeAll(retry);
            if (!retry.isEmpty()) {
                LOGGER.info("[EventSub] Retrying: " + retry);
                for (Topic topic : retry) {
                    this.addTopicInternal(topic);
                }
            }
        }
    }

    private synchronized Connection getConnection(int id) {
        return this.connections.get(id);
    }

    public synchronized boolean hasTopic(Topic topic) {
        if (this.errorTopics.contains(topic)) {
            return true;
        }
        if (this.errorLimitReachedTopics.contains(topic)) {
            return true;
        }
        if (this.removedAuthTopics.contains(topic)) {
            return true;
        }
        for (Connection c : this.connections.values()) {
            if (!c.hasTopic(topic)) continue;
            return true;
        }
        return false;
    }

    public synchronized String getStatus() {
        return this.connections.toString();
    }

    public synchronized int getNumTopics(int id) {
        if (this.connections.containsKey(id)) {
            return this.connections.get(id).numTopics();
        }
        return -1;
    }

    public synchronized int getNumTopics() {
        int total = 0;
        for (Connection c : this.connections.values()) {
            total += c.numTopics();
        }
        return total;
    }

    public synchronized int getNumConnections() {
        return this.connections.size();
    }

    public synchronized boolean isConnected() {
        if (this.connections.isEmpty()) {
            return false;
        }
        for (Connection c : this.connections.values()) {
            if (c.isOpen()) continue;
            return false;
        }
        return true;
    }

    private synchronized void disconnect(Connection c) {
        c.disconnect();
        this.connections.values().remove(c);
    }

    public synchronized void disconnect() {
        for (Connection c : this.connections.values()) {
            c.disconnect();
        }
        this.timer.cancel();
    }

    public synchronized void reconnect() {
        for (Connection c : this.connections.values()) {
            c.reconnect();
        }
    }

    public synchronized void checkConnection() {
        for (Connection c : this.connections.values()) {
            c.checkTimeout();
        }
    }

    private synchronized boolean hasReplacement(Connection c) {
        for (Connection c2 : this.connections.values()) {
            if (c2.getReplacedConnection() != c) continue;
            return true;
        }
        return false;
    }

    public synchronized void simulate(String text) {
        this.connections.values().iterator().next().handleReceived(text);
    }

    public synchronized Topic removeTopicById(String id) {
        for (Connection c : this.connections.values()) {
            Topic topic = c.getTopicById(id);
            if (topic == null) continue;
            this.removeTopicInternal(topic);
            return topic;
        }
        return null;
    }

    private MessageHandler createHandler(final int id) {
        return new MessageHandler(){

            @Override
            public void handleReceived(String text) {
                Message msg = Message.fromJson(text);
                Connections.this.handler.handleReceived(id, text, msg);
                Connections.this.handleMessage2(id, msg);
            }

            @Override
            public void handleSent(String text) {
                Connections.this.handler.handleSent(id, text);
            }

            @Override
            public void handleConnect(JWSClient c) {
                Connections.this.handler.handleConnect(id, c);
            }

            @Override
            public void handleDisconnect(int code) {
                Connections.this.handler.handleDisconnect(id);
                Connections.this.handleDisconnect2(id, code);
            }
        };
    }

    private synchronized void handleMessage2(int id, Message msg) {
        Connection c = this.getConnection(id);
        if (c == null) {
            return;
        }
        if (msg == null) {
            return;
        }
        if (msg.type.equals("session_welcome")) {
            SessionPayload session = (SessionPayload)msg.data;
            c.setSessionId(session.id);
            c.setConnectionTimeout(session.keepAliveTimeout + 4);
            if (c.getReplacedConnection() != null) {
                this.disconnect(c.getReplacedConnection());
            } else {
                for (Topic topic : c.getTopics()) {
                    this.registerTopic(c, topic);
                }
            }
        } else if (msg.type.equals("session_reconnect")) {
            SessionPayload session = (SessionPayload)msg.data;
            String reconnectUrl = session.reconnectUrl;
            if (reconnectUrl != null) {
                try {
                    Connection c2 = this.addConnection(new URI(reconnectUrl));
                    c2.setReplacedConnection(c);
                    for (Topic topic : c.getTopics()) {
                        Topic newTopic = topic.copy();
                        newTopic.setCost(topic.getCost());
                        newTopic.setId(topic.getId());
                        c2.addTopic(newTopic);
                    }
                    c2.init();
                }
                catch (URISyntaxException ex) {
                    LOGGER.warning("[EventSub] Invalid reconnect URL: " + reconnectUrl);
                }
            }
        } else if (msg.type.equals("revocation")) {
            SubscriptionPayload subscription = (SubscriptionPayload)msg.data;
            Topic topic = this.removeTopicById(subscription.id);
            if (topic != null) {
                topic.setId(null);
                topic.setCost(0);
                if ("authorization_revoked".equals(subscription.status)) {
                    if (!this.toRemove.contains(topic)) {
                        this.removedAuthTopics.add(topic);
                    }
                } else if (!"moderator_removed".equals(subscription.status) && !this.toRemove.contains(topic)) {
                    this.errorTopics.add(topic);
                }
            }
        }
    }

    private synchronized void handleDisconnect2(int id, int code) {
        Connection c = this.getConnection(id);
        if (c == null) {
            return;
        }
        c.setSessionId(null);
        if (!this.hasReplacement(c)) {
            for (Topic topic2 : c.getTopics()) {
                if (topic2.getCost() > 0) {
                    this.totalCost = -topic2.getCost();
                }
                topic2.setCost(0);
                topic2.setId(null);
            }
        }
        switch (code) {
            case 4007: {
                this.disconnect(c);
                Connection c2 = this.addConnection(this.server);
                c.getTopics().forEach(topic -> c2.addTopic(topic.copy()));
                c2.init();
            }
        }
    }

    private void registerTopic(Connection c, Topic topic) {
        String sessionId = c.getSessionId();
        this.requestPending.add(topic);
        this.api.addEventSub(topic.make(sessionId), r -> {
            if (!r.hasError) {
                Connections connections = this;
                synchronized (connections) {
                    if (sessionId.equals(c.getSessionId())) {
                        this.totalCost = r.totalCost;
                        this.maxTotalCost = r.maxTotalCost;
                        topic.setCost(r.cost);
                        topic.setId(r.id);
                    }
                    this.requestPending.remove(topic);
                }
                this.log("+" + topic, c.id);
            } else {
                boolean reportError = false;
                Connections connections = this;
                synchronized (connections) {
                    if (!this.toRemove.contains(topic)) {
                        reportError = true;
                        if (r.responseCode == 429) {
                            this.errorLimitReachedTopics.add(topic);
                        } else {
                            topic.increaseErrorCount();
                            this.errorTopics.add(topic);
                        }
                    }
                    this.removeTopicInternal(topic);
                    this.requestPending.remove(topic);
                }
                if (reportError) {
                    this.handler.handleRegisterError(r.responseCode);
                }
                this.log("Error: " + topic + " / " + this.getDebugText(), c.id);
            }
        });
    }

    private synchronized void unregisterTopics() {
        if (this.toRemove.isEmpty()) {
            return;
        }
        Iterator<Topic> it = this.toRemove.iterator();
        while (it.hasNext()) {
            Topic topic = it.next();
            if (this.requestPending.contains(topic)) continue;
            if (this.toAdd.contains(topic)) {
                it.remove();
                continue;
            }
            this.unregisterTopic(topic);
        }
    }

    private synchronized void addTopics() {
        HashSet<Topic> toAddCopy = new HashSet<Topic>(this.toAdd);
        this.toAdd.clear();
        for (Topic topic : toAddCopy) {
            Debugging.println("es", "Re-adding: %s", topic);
            this.addTopic(topic);
        }
    }

    private boolean unregisterTopic(Topic topic) {
        if (topic.getId() == null) {
            Debugging.println("es", "Unregister %s (no id)", topic);
            return false;
        }
        if (!topic.shouldRequest()) {
            Debugging.println("es", "Unregister %s (wait)", topic);
            return false;
        }
        Debugging.println("es", "Unregister %s", topic);
        this.requestPending.add(topic);
        this.api.removeEventSub(topic.getId(), r -> {
            if (r == 204 || r == 404) {
                Connections connections = this;
                synchronized (connections) {
                    if (topic.getCost() > 0 && r == 204) {
                        this.totalCost -= topic.getCost();
                    }
                    this.removeTopicInternal(topic);
                    this.requestPending.remove(topic);
                    this.retryFailedTopic(topic.getCost() > 0);
                }
                this.log("-" + topic);
            } else {
                Connections connections = this;
                synchronized (connections) {
                    topic.increaseErrorCount();
                    this.requestPending.remove(topic);
                }
            }
        });
        return true;
    }

    private void log(String event, int connectionId) {
        LOGGER.info(String.format("[EventSub]%s %s", this.getConnectionPrefix(connectionId), event));
    }

    private void log(String event) {
        LOGGER.info(String.format("[EventSub] %s", event));
    }

    public String getConnectionPrefix(int connectionId) {
        return String.format(Locale.ROOT, "[%d(%3d)/%d(%3d)]", connectionId, this.getNumTopics(connectionId), this.getNumConnections(), this.getNumTopics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDebugText() {
        String result;
        Connections connections = this;
        synchronized (connections) {
            result = String.format("Cost: %d/%d L:%s E:%s A:%s R:%s", this.totalCost, this.maxTotalCost, this.errorLimitReachedTopics, this.errorTopics, this.removedAuthTopics, this.toRemove);
        }
        return result;
    }

    public Map<String, List<Topic>> getTopics() {
        HashMap<String, List<Topic>> result = new HashMap<String, List<Topic>>();
        for (Connection c : this.connections.values()) {
            ArrayList<Topic> topics = new ArrayList<Topic>();
            topics.addAll(c.getTopics());
            result.put(c.getSessionId(), topics);
        }
        return result;
    }

    public synchronized void tokenUpdated() {
        HashSet<Topic> topics = new HashSet<Topic>(this.removedAuthTopics);
        this.removedAuthTopics.clear();
        for (Topic topic : topics) {
            this.addTopicInternal(topic);
        }
    }
}

