/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api.eventsub;

import chatty.gui.components.eventlog.EventLog;
import chatty.util.Debugging;
import chatty.util.StringUtil;
import chatty.util.api.TwitchApi;
import chatty.util.api.eventsub.Connections;
import chatty.util.api.eventsub.ConnectionsMessageHandler;
import chatty.util.api.eventsub.EventSubListener;
import chatty.util.api.eventsub.Helper;
import chatty.util.api.eventsub.Message;
import chatty.util.api.eventsub.RaidTopicManager;
import chatty.util.api.eventsub.Topic;
import chatty.util.jws.JWSClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;

public class EventSubManager {
    private static final Logger LOGGER = Logger.getLogger(EventSubManager.class.getName());
    private final TwitchApi api;
    private final Connections c;
    private final EventSubListener listener;
    private final Map<String, String> userIds = Collections.synchronizedMap(new HashMap());
    private final Set<Topic> pendingTopics = Collections.synchronizedSet(new HashSet());
    private volatile String localUserId;
    private volatile String localUsername;
    private final RaidTopicManager raidTopicManager;
    private boolean loggedTopicsYet;

    public EventSubManager(String server, EventSubListener listener, TwitchApi api) {
        this.api = api;
        this.listener = listener;
        this.c = this.init(server);
        this.raidTopicManager = new RaidTopicManager(this, api);
    }

    private Connections init(String server) {
        try {
            return new Connections(new URI(server), new ConnectionsMessageHandler(){

                @Override
                public void handleReceived(int id, String received, Message message) {
                    EventSubManager.this.listener.info(String.format(Locale.ROOT, "%s--> %s", EventSubManager.this.c.getConnectionPrefix(id), StringUtil.trim(received)));
                    if (message != null && message.data != null) {
                        EventSubManager.this.listener.messageReceived(message);
                    }
                }

                @Override
                public void handleSent(int id, String sent) {
                    EventSubManager.this.listener.info(String.format(Locale.ROOT, "[%d(%d)/%d(%d)]<-- %s", id, EventSubManager.this.c.getNumTopics(id), EventSubManager.this.c.getNumConnections(), EventSubManager.this.c.getNumTopics(), sent));
                }

                @Override
                public void handleDisconnect(int id) {
                }

                @Override
                public void handleConnect(int id, JWSClient c) {
                }

                @Override
                public void handleRegisterError(int responseCode) {
                    if (responseCode == 429) {
                        EventLog.addSystemEvent("session.eventsub.limit", "EventSub error", "EventSub has reached an unexpected request limit, which will cause some features to not fully work, such as displaying Mod Actions, AutoMod and others. Note that API limits are per Twitch account/Client ID, so if you have other Chatty instances running it may affect limits on this one.");
                        if (!EventSubManager.this.loggedTopicsYet) {
                            EventSubManager.this.logActiveTopics();
                            EventSubManager.this.loggedTopicsYet = true;
                        }
                    }
                }
            }, this.api);
        }
        catch (URISyntaxException ex) {
            LOGGER.warning("[EventSub] Invalid server: " + server);
            return null;
        }
    }

    public void simulate(String input) {
        this.c.simulate(input);
    }

    public void logActiveTopics() {
        this.api.getEventSubSubs(s -> this.listener.info(String.format("[Current topics according to API]\n%s total\nPer sesssion: %s\n%s", s.total, s.getCountBySession(), s.toString())));
        this.listener.info(String.format("[Current topics according to Chatty]%s\n", this.getTopics()));
    }

    public void setLocalUsername(String username) {
        if (this.localUsername == null || !this.localUsername.equals(username)) {
            this.localUsername = username;
            this.localUserId = null;
            this.requestUserId(username);
        }
    }

    public void listenRaid(String username) {
        this.raidTopicManager.listen(username, username.equals(this.localUsername));
    }

    public void unlistenRaid(String username) {
        this.raidTopicManager.unlisten(username);
    }

    protected void listenRaidInternal(String username) {
        this.addTopic(new Raid(username));
    }

    protected void unlistenRaidInternal(String username) {
        this.removeTopic(new Raid(username));
    }

    public void listenPoll(String username) {
        this.addTopic(new PollStart(username));
        this.addTopic(new PollEnd(username));
    }

    public void unlistenPoll(String username) {
        this.removeTopic(new PollStart(username));
        this.removeTopic(new PollEnd(username));
    }

    public void listenShield(String username) {
        this.addTopic(new ShieldBegin(username));
        this.addTopic(new ShieldEnd(username));
    }

    public void unlistenShield(String username) {
        this.removeTopic(new ShieldBegin(username));
        this.removeTopic(new ShieldEnd(username));
    }

    public void listenShoutouts(String username) {
        this.addTopic(new ShoutoutCreate(username));
    }

    public void unlistenShoutouts(String username) {
        this.removeTopic(new ShoutoutCreate(username));
    }

    public void listenModActions(String username) {
        this.addTopic(new ChannelModerate(username));
    }

    public void unlistenModActions(String username) {
        this.removeTopic(new ChannelModerate(username));
    }

    public void listenAutoMod(String username) {
        this.addTopic(new AutoModMessageHold(username));
        this.addTopic(new AutoModMessageUpdate(username));
    }

    public void unlistenAutoMod(String username) {
        this.removeTopic(new AutoModMessageHold(username));
        this.removeTopic(new AutoModMessageUpdate(username));
    }

    public void listenSuspiciousMessage(String username) {
        this.addTopic(new SuspiciousMessage(username));
        this.addTopic(new SuspiciousUpdate(username));
    }

    public void unlistenSuspicousMessage(String username) {
        this.removeTopic(new SuspiciousMessage(username));
        this.removeTopic(new SuspiciousUpdate(username));
    }

    public void listenWarnings(String username) {
        this.addTopic(new WarningAcknowledge(username));
    }

    public void unlistenWarnings(String username) {
        this.removeTopic(new WarningAcknowledge(username));
    }

    public void listenMessageHeld(String username) {
        this.addTopic(new UserMessageUpdate(username));
    }

    public void unlistenMessageHeld(String username) {
        this.removeTopic(new UserMessageUpdate(username));
    }

    public void listenPoints(String username) {
        this.addTopic(new ChannelPointsRedemption(username));
        this.addTopic(new ChannelPointsRedemptionUpdate(username));
    }

    public void unlistenPoints(String username) {
        this.removeTopic(new ChannelPointsRedemption(username));
        this.removeTopic(new ChannelPointsRedemptionUpdate(username));
    }

    private void addTopic(Topic topic) {
        if (this.c == null) {
            return;
        }
        boolean added = this.pendingTopics.add(topic);
        if (added) {
            this.checkPendingTopics();
            if (!topic.isReady()) {
                topic.request();
            }
        }
    }

    private void removeTopic(Topic topic) {
        if (this.c == null) {
            return;
        }
        this.pendingTopics.remove(topic);
        if (topic.isReady()) {
            this.c.removeTopic(topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPendingTopics() {
        HashSet<Topic> readyTopics = new HashSet<Topic>();
        Set<Topic> set = this.pendingTopics;
        synchronized (set) {
            Iterator<Topic> it = this.pendingTopics.iterator();
            while (it.hasNext()) {
                Topic topic = it.next();
                if (!topic.isReady()) continue;
                readyTopics.add(topic);
                it.remove();
            }
        }
        Debugging.println("es", "[EventSub] Send: %s, Pending: %s", readyTopics, this.pendingTopics);
        for (Topic topic : readyTopics) {
            boolean success = this.c.addTopic(topic);
            if (success) continue;
            EventLog.addSystemEvent("session.eventsub.maxtopics", "EventSub max channels reached", "The amount of channels you have joined (especially where you are a moderator) will cause some features to not fully work, such as displaying Mod Actions, AutoMod and others.");
        }
    }

    private void requestUserId(String username) {
        this.api.waitForUserId(r -> this.setUserId(username, r.getId(username)), username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserId(String username) {
        if (StringUtil.isNullOrEmpty(username)) {
            return null;
        }
        Map<String, String> map = this.userIds;
        synchronized (map) {
            for (Map.Entry<String, String> entry : this.userIds.entrySet()) {
                if (!entry.getValue().equals(username)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private void setUserId(String username, String userId) {
        this.userIds.put(userId, username);
        if (this.localUserId == null && username.equals(this.localUsername)) {
            this.localUserId = userId;
        }
        this.checkPendingTopics();
    }

    public String getStatus() {
        if (this.c == null) {
            return "Not initialized";
        }
        return this.c.getStatus();
    }

    public void disconnect() {
        if (this.c != null) {
            this.c.disconnect();
        }
    }

    public boolean isConnected() {
        return this.c != null && this.c.isConnected();
    }

    public void reconnect() {
        if (this.c != null) {
            this.c.reconnect();
        }
    }

    public void tokenUpdated() {
        this.c.tokenUpdated();
    }

    public String getTopics() {
        Map<String, List<Topic>> topics = this.c.getTopics();
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, List<Topic>> entry : topics.entrySet()) {
            b.append("\n[").append(entry.getKey()).append("]\n");
            ArrayList topics2 = new ArrayList();
            entry.getValue().forEach(t -> {
                if (t instanceof StreamTopic) {
                    topics2.add((StreamTopic)t);
                } else {
                    LOGGER.warning("Unexpected topic: " + t);
                }
            });
            Collections.sort(topics2, (o1, o2) -> o1.stream.compareTo(o2.stream));
            int count = 0;
            String currentStream = null;
            for (StreamTopic t2 : topics2) {
                if (currentStream != null && !t2.stream.equals(currentStream)) {
                    b.append("\n---\n");
                    count = 0;
                }
                currentStream = t2.stream;
                b.append(++count).append(".");
                b.append(t2).append("(").append(t2.getCost()).append(")\n");
            }
        }
        b.append("\n");
        b.append(this.c.getDebugText());
        return b.toString();
    }

    private class Raid
    extends StreamTopic {
        Raid(String stream) {
            super(stream);
        }

        @Override
        public String make(String sessionId) {
            String userId = EventSubManager.this.getUserId(this.stream);
            if (userId != null) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("from_broadcaster_user_id", userId);
                return Helper.makeAddEventSubBody("channel.raid", condition, sessionId, "1");
            }
            return null;
        }

        @Override
        public int getExpectedCost() {
            return 1;
        }

        @Override
        public Topic copy() {
            return new Raid(this.stream);
        }
    }

    private class PollStart
    extends StreamTopic {
        PollStart(String stream) {
            super(stream);
        }

        @Override
        public String make(String sessionId) {
            String userId = EventSubManager.this.getUserId(this.stream);
            if (userId != null) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("broadcaster_user_id", userId);
                return Helper.makeAddEventSubBody("channel.poll.begin", condition, sessionId, "1");
            }
            return null;
        }

        @Override
        public int getExpectedCost() {
            return 0;
        }

        @Override
        public Topic copy() {
            return new PollStart(this.stream);
        }
    }

    private class PollEnd
    extends StreamTopic {
        PollEnd(String stream) {
            super(stream);
        }

        @Override
        public String make(String sessionId) {
            String userId = EventSubManager.this.getUserId(this.stream);
            if (userId != null) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("broadcaster_user_id", userId);
                return Helper.makeAddEventSubBody("channel.poll.end", condition, sessionId, "1");
            }
            return null;
        }

        @Override
        public int getExpectedCost() {
            return 0;
        }

        @Override
        public Topic copy() {
            return new PollEnd(this.stream);
        }
    }

    private class ShieldBegin
    extends StreamTopic {
        ShieldBegin(String stream) {
            super(stream);
        }

        @Override
        public String make(String sessionId) {
            String userId = EventSubManager.this.getUserId(this.stream);
            if (userId != null && EventSubManager.this.localUserId != null) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("broadcaster_user_id", userId);
                condition.put("moderator_user_id", EventSubManager.this.localUserId);
                return Helper.makeAddEventSubBody("channel.shield_mode.begin", condition, sessionId, "1");
            }
            return null;
        }

        @Override
        public int getExpectedCost() {
            return 0;
        }

        @Override
        public Topic copy() {
            return new ShieldBegin(this.stream);
        }
    }

    private class ShieldEnd
    extends StreamTopic {
        ShieldEnd(String stream) {
            super(stream);
        }

        @Override
        public String make(String sessionId) {
            String userId = EventSubManager.this.getUserId(this.stream);
            if (userId != null && EventSubManager.this.localUserId != null) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("broadcaster_user_id", userId);
                condition.put("moderator_user_id", EventSubManager.this.localUserId);
                return Helper.makeAddEventSubBody("channel.shield_mode.end", condition, sessionId, "1");
            }
            return null;
        }

        @Override
        public int getExpectedCost() {
            return 0;
        }

        @Override
        public Topic copy() {
            return new ShieldEnd(this.stream);
        }
    }

    private class ShoutoutCreate
    extends StreamTopic {
        ShoutoutCreate(String stream) {
            super(stream);
        }

        @Override
        public String make(String sessionId) {
            String userId = EventSubManager.this.getUserId(this.stream);
            if (userId != null && EventSubManager.this.localUserId != null) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("broadcaster_user_id", userId);
                condition.put("moderator_user_id", EventSubManager.this.localUserId);
                return Helper.makeAddEventSubBody("channel.shoutout.create", condition, sessionId, "1");
            }
            return null;
        }

        @Override
        public int getExpectedCost() {
            return 0;
        }

        @Override
        public Topic copy() {
            return new ShoutoutCreate(this.stream);
        }
    }

    private class ChannelModerate
    extends StreamTopic {
        ChannelModerate(String stream) {
            super(stream);
        }

        @Override
        public String make(String sessionId) {
            String userId = EventSubManager.this.getUserId(this.stream);
            if (userId != null && EventSubManager.this.localUserId != null) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("broadcaster_user_id", userId);
                condition.put("moderator_user_id", EventSubManager.this.localUserId);
                return Helper.makeAddEventSubBody("channel.moderate", condition, sessionId, "2");
            }
            return null;
        }

        @Override
        public int getExpectedCost() {
            return 0;
        }

        @Override
        public Topic copy() {
            return new ChannelModerate(this.stream);
        }
    }

    private class AutoModMessageHold
    extends StreamTopic {
        AutoModMessageHold(String stream) {
            super(stream);
        }

        @Override
        public String make(String sessionId) {
            String userId = EventSubManager.this.getUserId(this.stream);
            if (userId != null && EventSubManager.this.localUserId != null) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("broadcaster_user_id", userId);
                condition.put("moderator_user_id", EventSubManager.this.localUserId);
                return Helper.makeAddEventSubBody("automod.message.hold", condition, sessionId, "2");
            }
            return null;
        }

        @Override
        public int getExpectedCost() {
            return 0;
        }

        @Override
        public Topic copy() {
            return new AutoModMessageHold(this.stream);
        }
    }

    private class AutoModMessageUpdate
    extends StreamTopic {
        AutoModMessageUpdate(String stream) {
            super(stream);
        }

        @Override
        public String make(String sessionId) {
            String userId = EventSubManager.this.getUserId(this.stream);
            if (userId != null && EventSubManager.this.localUserId != null) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("broadcaster_user_id", userId);
                condition.put("moderator_user_id", EventSubManager.this.localUserId);
                return Helper.makeAddEventSubBody("automod.message.update", condition, sessionId, "2");
            }
            return null;
        }

        @Override
        public int getExpectedCost() {
            return 0;
        }

        @Override
        public Topic copy() {
            return new AutoModMessageUpdate(this.stream);
        }
    }

    private class SuspiciousMessage
    extends StreamTopic {
        SuspiciousMessage(String stream) {
            super(stream);
        }

        @Override
        public String make(String sessionId) {
            String userId = EventSubManager.this.getUserId(this.stream);
            if (userId != null && EventSubManager.this.localUserId != null) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("broadcaster_user_id", userId);
                condition.put("moderator_user_id", EventSubManager.this.localUserId);
                return Helper.makeAddEventSubBody("channel.suspicious_user.message", condition, sessionId, "1");
            }
            return null;
        }

        @Override
        public int getExpectedCost() {
            return 0;
        }

        @Override
        public Topic copy() {
            return new SuspiciousMessage(this.stream);
        }
    }

    private class SuspiciousUpdate
    extends StreamTopic {
        SuspiciousUpdate(String stream) {
            super(stream);
        }

        @Override
        public String make(String sessionId) {
            String userId = EventSubManager.this.getUserId(this.stream);
            if (userId != null && EventSubManager.this.localUserId != null) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("broadcaster_user_id", userId);
                condition.put("moderator_user_id", EventSubManager.this.localUserId);
                return Helper.makeAddEventSubBody("channel.suspicious_user.update", condition, sessionId, "1");
            }
            return null;
        }

        @Override
        public int getExpectedCost() {
            return 0;
        }

        @Override
        public Topic copy() {
            return new SuspiciousUpdate(this.stream);
        }
    }

    private class WarningAcknowledge
    extends StreamTopic {
        WarningAcknowledge(String stream) {
            super(stream);
        }

        @Override
        public String make(String sessionId) {
            String userId = EventSubManager.this.getUserId(this.stream);
            if (userId != null && EventSubManager.this.localUserId != null) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("broadcaster_user_id", userId);
                condition.put("moderator_user_id", EventSubManager.this.localUserId);
                return Helper.makeAddEventSubBody("channel.warning.acknowledge", condition, sessionId, "1");
            }
            return null;
        }

        @Override
        public int getExpectedCost() {
            return 0;
        }

        @Override
        public Topic copy() {
            return new WarningAcknowledge(this.stream);
        }
    }

    private class UserMessageUpdate
    extends StreamTopic {
        UserMessageUpdate(String stream) {
            super(stream);
        }

        @Override
        public String make(String sessionId) {
            String userId = EventSubManager.this.getUserId(this.stream);
            if (userId != null && EventSubManager.this.localUserId != null) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("broadcaster_user_id", userId);
                condition.put("user_id", EventSubManager.this.localUserId);
                return Helper.makeAddEventSubBody("channel.chat.user_message_update", condition, sessionId, "1");
            }
            return null;
        }

        @Override
        public int getExpectedCost() {
            return 0;
        }

        @Override
        public Topic copy() {
            return new UserMessageUpdate(this.stream);
        }
    }

    private class ChannelPointsRedemption
    extends StreamTopic {
        ChannelPointsRedemption(String stream) {
            super(stream);
        }

        @Override
        public String make(String sessionId) {
            String userId = EventSubManager.this.getUserId(this.stream);
            if (userId != null) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("broadcaster_user_id", userId);
                return Helper.makeAddEventSubBody("channel.channel_points_custom_reward_redemption.add", condition, sessionId, "1");
            }
            return null;
        }

        @Override
        public int getExpectedCost() {
            return 0;
        }

        @Override
        public Topic copy() {
            return new ChannelPointsRedemption(this.stream);
        }
    }

    private class ChannelPointsRedemptionUpdate
    extends StreamTopic {
        ChannelPointsRedemptionUpdate(String stream) {
            super(stream);
        }

        @Override
        public String make(String sessionId) {
            String userId = EventSubManager.this.getUserId(this.stream);
            if (userId != null) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("broadcaster_user_id", userId);
                return Helper.makeAddEventSubBody("channel.channel_points_custom_reward_redemption.update", condition, sessionId, "1");
            }
            return null;
        }

        @Override
        public int getExpectedCost() {
            return 0;
        }

        @Override
        public Topic copy() {
            return new ChannelPointsRedemptionUpdate(this.stream);
        }
    }

    private abstract class StreamTopic
    extends Topic {
        protected final String stream;

        StreamTopic(String stream) {
            this.stream = stream;
        }

        @Override
        public void request() {
            EventSubManager.this.requestUserId(this.stream);
        }

        @Override
        public boolean isReady() {
            return EventSubManager.this.getUserId(this.stream) != null;
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + Objects.hashCode(this.stream);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StreamTopic other = (StreamTopic)obj;
            return Objects.equals(this.stream, other.stream);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this.stream;
        }
    }

    private class UserMessageHeld
    extends StreamTopic {
        UserMessageHeld(String stream) {
            super(stream);
        }

        @Override
        public String make(String sessionId) {
            String userId = EventSubManager.this.getUserId(this.stream);
            if (userId != null && EventSubManager.this.localUserId != null) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("broadcaster_user_id", userId);
                condition.put("user_id", EventSubManager.this.localUserId);
                return Helper.makeAddEventSubBody("channel.chat.user_message_hold", condition, sessionId, "1");
            }
            return null;
        }

        @Override
        public int getExpectedCost() {
            return 0;
        }

        @Override
        public Topic copy() {
            return new UserMessageHeld(this.stream);
        }
    }
}

