/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api.eventsub;

import chatty.util.JSONUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class EventSubSubs {
    private static final Logger LOGGER = Logger.getLogger(EventSubSubs.class.getName());
    public final int total;
    public final int totalCost;
    public final int maxTotalCost;
    public final List<Sub> subs;

    public EventSubSubs(int total, int totalCost, int maxTotalCost, List<Sub> subs) {
        this.total = total;
        this.totalCost = totalCost;
        this.maxTotalCost = maxTotalCost;
        this.subs = subs;
    }

    public void addResult(EventSubSubs subs) {
        this.subs.addAll(subs.subs);
    }

    public static EventSubSubs decode(String json) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            int total = JSONUtil.getInteger(root, "total", -1);
            int totalCost = JSONUtil.getInteger(root, "total_cost", -1);
            int maxTotalCost = JSONUtil.getInteger(root, "max_total_cost", -1);
            ArrayList<Sub> subs = new ArrayList<Sub>();
            JSONArray data = (JSONArray)root.get("data");
            for (Object o : data) {
                JSONObject entry = (JSONObject)o;
                subs.add(new Sub(entry));
            }
            return new EventSubSubs(total, totalCost, maxTotalCost, subs);
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing EventSub subs: " + ex);
            return null;
        }
    }

    public Map<String, List<Sub>> getBySession() {
        HashMap<String, List<Sub>> result = new HashMap<String, List<Sub>>();
        HashSet<String> ids = new HashSet<String>();
        for (Sub sub : this.subs) {
            if (!ids.add(sub.id)) {
                System.out.println("Duped id: " + sub.id);
                continue;
            }
            if (!result.containsKey(sub.sessionId)) {
                result.put(sub.sessionId, new ArrayList());
            }
            ((List)result.get(sub.sessionId)).add(sub);
        }
        return result;
    }

    public Map<String, Integer> getCountBySession() {
        Map<String, List<Sub>> bySession = this.getBySession();
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        for (Map.Entry<String, List<Sub>> entry : bySession.entrySet()) {
            count.put(entry.getKey(), entry.getValue().size());
        }
        return count;
    }

    public String toString() {
        Map<String, List<Sub>> bySession = this.getBySession();
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, List<Sub>> entry : bySession.entrySet()) {
            b.append("\n[").append(entry.getKey()).append("]").append("\n");
            ArrayList sorted = new ArrayList();
            sorted.addAll(entry.getValue());
            Collections.sort(sorted, (o1, o2) -> {
                if (o1.broadcasterId == o2.broadcasterId) {
                    return 0;
                }
                if (o1.broadcasterId == null && o2.broadcasterId != null) {
                    return -1;
                }
                if (o2.broadcasterId == null) {
                    return 1;
                }
                return o1.broadcasterId.compareTo(o2.broadcasterId);
            });
            String currentId = null;
            int count = 0;
            for (Sub sub : sorted) {
                if (currentId != null && !currentId.equals(sub.broadcasterId)) {
                    b.append(count);
                    count = 0;
                    b.append("\n---\n");
                }
                ++count;
                currentId = sub.broadcasterId;
                b.append(sub.broadcasterId).append(" ");
                b.append(sub.type);
                b.append("\n");
            }
        }
        return b.toString();
    }

    private static class Sub {
        public final String id;
        public final String status;
        public final String type;
        public final String version;
        public final String broadcasterId;
        public final String createdAt;
        public final String method;
        public final String sessionId;
        public final int cost;

        public Sub(JSONObject data) {
            this.id = JSONUtil.getString(data, "id");
            this.status = JSONUtil.getString(data, "status");
            this.type = JSONUtil.getString(data, "type");
            JSONObject condition = (JSONObject)data.get("condition");
            this.broadcasterId = JSONUtil.getString(condition, "broadcaster_user_id");
            this.version = JSONUtil.getString(data, "version");
            JSONObject transport = (JSONObject)data.get("transport");
            this.method = JSONUtil.getString(transport, "method", "");
            this.sessionId = this.method.equals("websocket") ? JSONUtil.getString(transport, "session_id") : null;
            this.createdAt = JSONUtil.getString(data, "created_at");
            this.cost = JSONUtil.getInteger(data, "cost", -1);
        }
    }
}

