/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api.eventsub;

import chatty.util.Debugging;
import chatty.util.JSONUtil;
import chatty.util.api.eventsub.Payload;
import java.util.Objects;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Message {
    private static final Logger LOGGER = Logger.getLogger(Message.class.getName());
    public final String id;
    public final String type;
    public final String subType;
    public final String subVersion;
    public final long timestamp;
    public final Payload data;

    public Message(String type, String id, String subType, String subVersion, long timestamp, Payload data) {
        this.type = type;
        this.id = id;
        this.data = data;
        this.subType = subType;
        this.subVersion = subVersion;
        this.timestamp = timestamp;
    }

    public static Message fromJson(String json) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            JSONObject metadata = (JSONObject)root.get("metadata");
            JSONObject payload = (JSONObject)root.get("payload");
            String type = JSONUtil.getString(metadata, "message_type");
            String id = JSONUtil.getString(metadata, "message_id");
            long timestamp = JSONUtil.getDatetime(metadata, "message_timestamp", 0L);
            String subType = JSONUtil.getString(metadata, "subscription_type");
            String subVersion = JSONUtil.getString(metadata, "subscription_version");
            Payload data = Payload.decode(payload, type, subType);
            return new Message(type, id, subType, subVersion, timestamp, data);
        }
        catch (Exception ex) {
            LOGGER.warning(String.format("[EventSub] Error parsing message: %s %s", Debugging.getStacktraceFilteredFlat(ex), json));
            return null;
        }
    }

    public String toString() {
        return this.type + "[" + this.id + "//" + this.data + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return Objects.equals(this.data, other.data);
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + Objects.hashCode(this.type);
        hash = 61 * hash + Objects.hashCode(this.id);
        hash = 61 * hash + Objects.hashCode(this.data);
        return hash;
    }
}

