/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api.eventsub;

import chatty.util.api.StreamInfo;
import chatty.util.api.TwitchApi;
import chatty.util.api.eventsub.EventSubManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class RaidTopicManager {
    private static final int UPDATE_DELAY = 30000;
    private final EventSubManager eventSub;
    private final TwitchApi api;
    private final Object LOCK = new Object();
    private final Set<String> usernames;
    private final Set<String> listenedUsernames;
    private final List<Runnable> actionQueue;

    public RaidTopicManager(EventSubManager eventSub, TwitchApi api) {
        this.eventSub = eventSub;
        this.api = api;
        this.usernames = new HashSet<String>();
        this.listenedUsernames = new HashSet<String>();
        this.actionQueue = new ArrayList<Runnable>();
        Timer timer = new Timer("RaidTopicManager", true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                RaidTopicManager.this.update();
            }
        }, 30000L, 30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listen(String username, boolean isLocalUser) {
        Object object = this.LOCK;
        synchronized (object) {
            if (isLocalUser) {
                this.actionQueue.add(() -> this.eventSub.listenRaidInternal(username));
            } else {
                this.usernames.add(username);
            }
        }
        this.runQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlisten(String username) {
        Object object = this.LOCK;
        synchronized (object) {
            this.usernames.remove(username);
            this.listenedUsernames.remove(username);
            this.actionQueue.add(() -> this.eventSub.unlistenRaidInternal(username));
        }
        this.runQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        Object object = this.LOCK;
        synchronized (object) {
            for (String username : this.usernames) {
                if (!this.listenedUsernames.contains(username)) {
                    if (!this.isEligible(username)) continue;
                    this.listenedUsernames.add(username);
                    this.actionQueue.add(() -> this.eventSub.listenRaidInternal(username));
                    continue;
                }
                if (this.isEligibleEnough(username)) continue;
                this.listenedUsernames.remove(username);
                this.actionQueue.add(() -> this.eventSub.unlistenRaidInternal(username));
            }
        }
        this.runQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQueue() {
        ArrayList<Runnable> toExecute;
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            if (this.actionQueue.isEmpty()) {
                return;
            }
            toExecute = new ArrayList<Runnable>(this.actionQueue);
            this.actionQueue.clear();
        }
        for (Runnable runnable : toExecute) {
            runnable.run();
        }
    }

    private boolean isEligible(String username) {
        StreamInfo info = this.api.getCachedStreamInfo(username);
        return info != null && info.getLastOnlineAgoSecs() < 600L;
    }

    private boolean isEligibleEnough(String username) {
        StreamInfo info = this.api.getCachedStreamInfo(username);
        return info != null && (!info.isValid() || info.getLastOnlineAgoSecs() < 600L);
    }
}

