/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api.eventsub;

import chatty.util.ElapsedTime;
import java.util.concurrent.ThreadLocalRandom;

public abstract class Topic {
    private int cost = 0;
    private int errorCount = 0;
    private ElapsedTime lastError;
    private String id;

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean shouldRequest() {
        if (this.lastError == null) {
            return true;
        }
        int delaySeconds = Math.min(3600, (int)Math.pow(10.0, this.errorCount)) + ThreadLocalRandom.current().nextInt(10);
        return this.lastError.secondsElapsed(delaySeconds);
    }

    public void increaseErrorCount() {
        ++this.errorCount;
        if (this.lastError == null) {
            this.lastError = new ElapsedTime(true);
        } else {
            this.lastError.set();
        }
    }

    public abstract Topic copy();

    public abstract String make(String var1);

    public abstract boolean isReady();

    public abstract void request();

    public abstract int getExpectedCost();
}

