/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api.eventsub.payloads;

import chatty.Helper;
import chatty.TwitchCommands;
import chatty.util.BatchAction;
import chatty.util.DateTime;
import chatty.util.JSONUtil;
import chatty.util.StringUtil;
import chatty.util.api.eventsub.Payload;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ModActionPayload
extends Payload {
    private static final Logger LOGGER = Logger.getLogger(ModActionPayload.class.getName());
    public final String moderation_action;
    public final String created_by;
    public final ModAction action;
    public final String stream;
    public final String source_stream;
    public final Type type;

    public ModActionPayload(String moderator_action, String created_by, ModAction action, String stream, String source_stream) {
        this.moderation_action = moderator_action;
        this.created_by = created_by;
        if (action == null) {
            action = new Simple(moderator_action);
        }
        this.action = action;
        this.stream = stream;
        this.source_stream = source_stream;
        switch (this.moderation_action) {
            case "automod_filtered": {
                this.type = Type.AUTOMOD_FILTERED;
                break;
            }
            case "approved_automod_message": {
                this.type = Type.AUTOMOD_APPROVED;
                break;
            }
            case "denied_automod_message": {
                this.type = Type.AUTOMOD_DENIED;
                break;
            }
            default: {
                this.type = Type.OTHER;
            }
        }
    }

    public String getPseudoCommandString() {
        return String.format("/%s", this.action.toString());
    }

    public String getPseudoCommandStringNoSlash() {
        return this.action.toString();
    }

    public String getData() {
        return this.action.getEvent();
    }

    public boolean isShared() {
        return !StringUtil.isNullOrEmpty(this.source_stream) && !this.source_stream.equals(this.stream);
    }

    public String getSourceChannel() {
        return this.isShared() ? Helper.toChannel(this.source_stream) : null;
    }

    public static ModActionPayload decode(JSONObject payload) {
        JSONObject event = (JSONObject)payload.get("event");
        if (event != null) {
            ModAction action = ModActionPayload.getAction(payload);
            if (action != null && action.isValid()) {
                return new ModActionPayload(action.action, JSONUtil.getString(event, "moderator_user_login"), action, JSONUtil.getString(event, "broadcaster_user_login"), JSONUtil.getString(event, "source_broadcaster_user_login"));
            }
            LOGGER.warning("Invalid ModAction: " + action);
        }
        return null;
    }

    public static ModActionPayload decodeAutomodHeld(JSONObject payload) {
        AutoModMessageUpdate action;
        JSONObject event = (JSONObject)payload.get("event");
        if (event != null && ((ModAction)(action = new AutoModMessageUpdate(payload))).isValid()) {
            return new ModActionPayload("automod_filtered", "", new AutoModMessageUpdate(payload), JSONUtil.getString(event, "broadcaster_user_login"), JSONUtil.getString(event, "source_broadcaster_user_login"));
        }
        return null;
    }

    public static ModActionPayload decodeAutomodUpdate(JSONObject payload) {
        AutoModMessageUpdate action;
        JSONObject event = (JSONObject)payload.get("event");
        if (event != null && ((ModAction)(action = new AutoModMessageUpdate(payload))).isValid()) {
            return new ModActionPayload(action.action, JSONUtil.getString(event, "moderator_user_login"), action, JSONUtil.getString(event, "broadcaster_user_login"), JSONUtil.getString(event, "source_broadcaster_user_login"));
        }
        return null;
    }

    private static ModAction getAction(JSONObject payload) {
        JSONObject event = (JSONObject)payload.get("event");
        switch (ModAction2.getModAction(payload)) {
            case "mod": {
                return new Mod(payload);
            }
            case "unmod": {
                return new Unmod(payload);
            }
            case "vip": {
                return new Vip(payload);
            }
            case "unvip": {
                return new Unvip(payload);
            }
            case "warn": {
                return new Warn(payload);
            }
            case "followers": {
                return new Followers(payload);
            }
            case "slow": {
                return new Slow(payload);
            }
            case "ban": {
                return new Ban(payload);
            }
            case "unban": {
                return new Unban(payload);
            }
            case "timeout": {
                return new Timeout(payload);
            }
            case "untimeout": {
                return new Untimeout(payload);
            }
            case "raid": {
                return new Raid(payload);
            }
            case "unraid": {
                return new Unraid(payload);
            }
            case "delete": {
                return new Delete(payload);
            }
        }
        if (event.get("automod_terms") instanceof JSONObject) {
            return new Automod_Terms(payload);
        }
        if (event.get("unban_request") instanceof JSONObject) {
            return new Unban_Request(payload);
        }
        return new NoArgsAction(payload);
    }

    public static class Simple
    extends ModAction {
        public Simple(String action) {
            super(action, null);
        }

        public String toString() {
            return this.action;
        }

        @Override
        public boolean isValid() {
            return !StringUtil.isNullOrEmpty(this.action);
        }
    }

    public static abstract class ModAction {
        public final String action;
        public final long eventCreatedAt;
        protected JSONObject event;

        public ModAction(String action, JSONObject payload) {
            this.action = action;
            this.eventCreatedAt = System.currentTimeMillis();
            this.event = payload == null ? null : (JSONObject)payload.get("event");
        }

        public String getEvent() {
            if (this.event != null) {
                return this.event.toString();
            }
            return null;
        }

        public boolean isIndirectAction() {
            return false;
        }

        public abstract boolean isValid();
    }

    public static enum Type {
        AUTOMOD_FILTERED,
        AUTOMOD_APPROVED,
        AUTOMOD_DENIED,
        OTHER,
        UNMODDED;

    }

    public static class AutoModMessageUpdate
    extends ModAction {
        public AutoModMessageUpdate(JSONObject payload) {
            super(AutoModMessageUpdate.getActionFromStatus(payload), payload);
        }

        private static String getActionFromStatus(JSONObject payload) {
            JSONObject event = (JSONObject)payload.get("event");
            String status = JSONUtil.getString(event, "status");
            if (status == null) {
                return "automod_filtered";
            }
            switch (status) {
                case "approved": {
                    return "approved_automod_message";
                }
                case "denied": {
                    return "denied_automod_message";
                }
                case "expired": {
                    return "automod_message_expired";
                }
            }
            return "unkown_automod_status";
        }

        public String toString() {
            return String.format("%s [%s] <%s> %s", this.action, this.getReason(), this.getUsername(), this.getMessage());
        }

        public String getMsgId() {
            return JSONUtil.getString(this.event, "message_id");
        }

        public String getUsername() {
            return JSONUtil.getString(this.event, "user_login");
        }

        public String getMessage() {
            return JSONUtil.getString(JSONUtil.getOrEmpty(this.event, "message"), "text");
        }

        public String getReason() {
            switch (JSONUtil.getString(this.event, "reason")) {
                case "automod": {
                    JSONObject automod = JSONUtil.getOrEmpty(this.event, "automod");
                    String category = JSONUtil.getString(automod, "category");
                    int level = JSONUtil.getInteger(automod, "level", 0);
                    ArrayList<String> fragments = new ArrayList<String>();
                    JSONArray boundaries = (JSONArray)automod.get("boundaries");
                    for (Object boundary : boundaries) {
                        String fragment = this.getFragment((JSONObject)boundary);
                        if (fragment == null) continue;
                        fragments.add(fragment);
                    }
                    return String.format("AutoMod: %s%s/%s", category, level, StringUtil.join(fragments, ", "));
                }
                case "blocked_term": {
                    JSONObject blocked_term = JSONUtil.getOrEmpty(this.event, "blocked_term");
                    JSONArray terms = (JSONArray)blocked_term.get("terms_found");
                    String stream = JSONUtil.getString(this.event, "broadcaster_user_login");
                    ArrayList<String> result = new ArrayList<String>();
                    for (Object o : terms) {
                        JSONObject term = (JSONObject)o;
                        String fragment = this.getFragment((JSONObject)term.get("boundary"));
                        if (fragment == null) continue;
                        String term_stream = JSONUtil.getString(term, "owner_broadcaster_user_login");
                        if (term_stream != null && !term_stream.equals(stream)) {
                            result.add(String.format("%s (from: %s)", fragment, term_stream));
                            continue;
                        }
                        result.add(String.format("%s", fragment));
                    }
                    return String.format("BlockedTerm: %s", StringUtil.join(result, ","));
                }
            }
            return JSONUtil.getString(this.event, "category");
        }

        private String getFragment(JSONObject boundary) {
            int start = JSONUtil.getInteger(boundary, "start_pos", -1);
            int end = JSONUtil.getInteger(boundary, "end_pos", -1);
            if (start > -1 && end > -1) {
                try {
                    return StringUtil.codePointSubstring(this.getMessage(), start, end + 1);
                }
                catch (Exception ex) {
                    BatchAction.queue(this.event, 100L, false, false, () -> LOGGER.warning("[EventSub] Error getting AutoMod reason: " + ex + " [" + this.event + "]"));
                    return "error, check debug log";
                }
            }
            return null;
        }

        @Override
        public boolean isValid() {
            return !StringUtil.isNullOrEmpty(this.getMsgId(), this.getReason(), this.getUsername(), this.action);
        }
    }

    public static abstract class ModAction2
    extends ModAction {
        protected JSONObject actionData;

        public ModAction2(JSONObject payload) {
            super(ModAction2.getModAction(payload), payload);
            this.actionData = (JSONObject)this.event.get(this.action);
            if (this.actionData == null) {
                this.actionData = (JSONObject)this.event.get("shared_chat_" + this.action);
            }
        }

        public static String getModAction(JSONObject payload) {
            JSONObject event = (JSONObject)payload.get("event");
            String action = JSONUtil.getString(event, "action");
            if (action.startsWith("shared_chat_")) {
                action = action.substring("shared_chat_".length());
            }
            return action;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.action);
            for (String key : this.getParamKeys()) {
                String value = this.getStringForKey(key);
                if (StringUtil.isNullOrEmpty(value)) continue;
                if (b.length() > 0) {
                    b.append(" ");
                }
                b.append(value);
            }
            return b.toString();
        }

        private String getStringForKey(String key) {
            String value = this.getParamForKey(key);
            if (value == null) {
                value = JSONUtil.getString(this.actionData, key);
            }
            return value;
        }

        abstract List<String> getParamKeys();

        String getParamForKey(String key) {
            return null;
        }

        final List<String> args(String ... keys) {
            return Arrays.asList(keys);
        }

        @Override
        public boolean isValid() {
            for (String key : this.getParamKeys()) {
                if (this.getStringForKey(key) != null) continue;
                return false;
            }
            return true;
        }
    }

    public static class Mod
    extends ModActionUser {
        public Mod(JSONObject payload) {
            super(payload);
        }

        @Override
        List<String> getParamKeys() {
            return this.args("user_login");
        }
    }

    public static class Unmod
    extends ModActionUser {
        public Unmod(JSONObject payload) {
            super(payload);
        }

        @Override
        List<String> getParamKeys() {
            return this.args("user_login");
        }
    }

    public static class Vip
    extends ModActionUser {
        public Vip(JSONObject payload) {
            super(payload);
        }

        @Override
        List<String> getParamKeys() {
            return this.args("user_login");
        }
    }

    public static class Unvip
    extends ModActionUser {
        public Unvip(JSONObject payload) {
            super(payload);
        }

        @Override
        List<String> getParamKeys() {
            return this.args("user_login");
        }
    }

    public static class Warn
    extends ModActionUser {
        public Warn(JSONObject payload) {
            super(payload);
        }

        @Override
        List<String> getParamKeys() {
            return this.args("user_login", "reason");
        }

        @Override
        String getParamForKey(String key) {
            if (key.equals("reason")) {
                return this.getReason();
            }
            return null;
        }

        public String getReason() {
            String reason = JSONUtil.getString(this.actionData, "reason");
            List<String> rules = JSONUtil.getStringList(this.actionData, "chat_rules_cited");
            StringBuilder b = new StringBuilder();
            if (!StringUtil.isNullOrEmpty(reason)) {
                b.append(reason);
            }
            if (rules != null) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append("Selected rules: ");
                b.append(StringUtil.join(rules, ", "));
            }
            return b.toString();
        }

        @Override
        public boolean isValid() {
            return !StringUtil.isNullOrEmpty(this.getTargetUsername(), this.getReason());
        }
    }

    public static class Followers
    extends ModAction2 {
        public Followers(JSONObject payload) {
            super(payload);
        }

        @Override
        List<String> getParamKeys() {
            return this.args("follow_duration_minutes");
        }

        @Override
        String getParamForKey(String key) {
            if (key.equals("follow_duration_minutes")) {
                int minutes = JSONUtil.getInteger(this.actionData, "follow_duration_minutes", 0);
                return TwitchCommands.formatDuration(minutes * 60);
            }
            return null;
        }
    }

    public static class Slow
    extends ModAction2 {
        public Slow(JSONObject payload) {
            super(payload);
        }

        @Override
        List<String> getParamKeys() {
            return this.args("wait_time_seconds");
        }

        @Override
        String getParamForKey(String key) {
            if (key.equals("wait_time_seconds")) {
                int seconds = JSONUtil.getInteger(this.actionData, "wait_time_seconds", 0);
                return TwitchCommands.formatDuration(seconds);
            }
            return null;
        }
    }

    public static class Ban
    extends ModActionUser {
        public Ban(JSONObject payload) {
            super(payload);
        }

        @Override
        List<String> getParamKeys() {
            return this.args("user_login", "reason");
        }

        public String getReason() {
            return JSONUtil.getString(this.actionData, "reason");
        }
    }

    public static class Unban
    extends ModActionUser {
        public Unban(JSONObject payload) {
            super(payload);
        }

        @Override
        List<String> getParamKeys() {
            return this.args("user_login");
        }
    }

    public static class Timeout
    extends ModActionUser {
        public Timeout(JSONObject payload) {
            super(payload);
        }

        @Override
        List<String> getParamKeys() {
            return this.args("user_login", "expires_at", "reason");
        }

        @Override
        String getParamForKey(String key) {
            if (key.equals("expires_at")) {
                return this.getDuration();
            }
            return null;
        }

        public String getReason() {
            return JSONUtil.getString(this.actionData, "reason");
        }

        public String getDuration() {
            String datetime = JSONUtil.getString(this.actionData, "expires_at");
            long expires = DateTime.parseDatetime(datetime);
            return DateTime.duration(expires - this.eventCreatedAt, new DateTime.Formatting[0]);
        }

        @Override
        public boolean isValid() {
            return !StringUtil.isNullOrEmpty(this.getTargetUsername()) && this.getDuration() != null;
        }
    }

    public static class Untimeout
    extends ModActionUser {
        public Untimeout(JSONObject payload) {
            super(payload);
        }

        @Override
        List<String> getParamKeys() {
            return this.args("user_login");
        }
    }

    public static class Raid
    extends ModActionUser {
        public Raid(JSONObject payload) {
            super(payload);
        }

        @Override
        List<String> getParamKeys() {
            return this.args("user_login");
        }
    }

    public static class Unraid
    extends ModActionUser {
        public Unraid(JSONObject payload) {
            super(payload);
        }

        @Override
        List<String> getParamKeys() {
            return this.args("user_login");
        }
    }

    public static class Delete
    extends ModActionUser {
        public Delete(JSONObject payload) {
            super(payload);
        }

        @Override
        List<String> getParamKeys() {
            return this.args("user_login", "message_body");
        }

        @Override
        String getParamForKey(String key) {
            if (key.equals("message_body")) {
                return this.getMsgText();
            }
            return null;
        }

        public String getMsgId() {
            return JSONUtil.getString(this.actionData, "message_id");
        }

        public String getMsgText() {
            return String.format("(%s)", JSONUtil.getString(this.actionData, "message_body"));
        }

        @Override
        public boolean isValid() {
            return !StringUtil.isNullOrEmpty(this.getTargetUsername(), this.getMsgId(), this.getMsgText());
        }
    }

    public static class Automod_Terms
    extends ModAction2 {
        public Automod_Terms(JSONObject payload) {
            super(payload);
            this.actionData = (JSONObject)this.event.get("automod_terms");
        }

        @Override
        List<String> getParamKeys() {
            return this.args("terms", "from_automod");
        }

        @Override
        String getParamForKey(String key) {
            if (key.equals("terms")) {
                List<String> terms = JSONUtil.getStringList(this.actionData, "terms");
                if (terms != null) {
                    return StringUtil.join(terms, ",");
                }
            } else if (key.equals("from_automod")) {
                return JSONUtil.getBoolean(this.actionData, "from_automod", false) ? "[auto]" : "[manual]";
            }
            return null;
        }

        @Override
        public boolean isIndirectAction() {
            return JSONUtil.getBoolean(this.actionData, "from_automod", false);
        }
    }

    public static class Unban_Request
    extends ModActionUser {
        public Unban_Request(JSONObject payload) {
            super(payload);
            this.actionData = (JSONObject)this.event.get("unban_request");
        }

        @Override
        List<String> getParamKeys() {
            return this.args("user_login", "moderator_message");
        }
    }

    public static class NoArgsAction
    extends ModAction2 {
        public NoArgsAction(JSONObject event) {
            super(event);
        }

        @Override
        List<String> getParamKeys() {
            return this.args(new String[0]);
        }
    }

    public static class SuspiciousUpdate
    extends ModAction {
        public final String treatment;
        public final String target;

        public SuspiciousUpdate(String treatment, String target) {
            super("suspicious_user_" + treatment, null);
            this.treatment = treatment;
            this.target = target;
        }

        public String toString() {
            return String.format("suspicious_user_%s %s", this.treatment, this.target);
        }

        @Override
        public boolean isValid() {
            return !StringUtil.isNullOrEmpty(this.treatment, this.target);
        }
    }

    public static class Shoutout
    extends ModAction {
        public final String target;

        public Shoutout(String target) {
            super("shoutout", null);
            this.target = target;
        }

        public String toString() {
            return "shoutout " + this.target;
        }

        @Override
        public boolean isValid() {
            return !StringUtil.isNullOrEmpty(this.target);
        }
    }

    public static abstract class ModActionUser
    extends ModAction2 {
        public ModActionUser(JSONObject payload) {
            super(payload);
        }

        public String getTargetUsername() {
            return JSONUtil.getString(this.actionData, "user_login");
        }

        @Override
        public boolean isValid() {
            return !StringUtil.isNullOrEmpty(this.getTargetUsername());
        }
    }
}

