/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api.queue;

import chatty.util.api.queue.Request;
import chatty.util.api.queue.ResultListener;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class Entry
implements Comparable<Entry> {
    private static final AtomicLong seq = new AtomicLong();
    public final long entryNum = seq.getAndIncrement();
    public final int priority;
    public final Request request;
    public final ResultListener listener;

    public Entry(int priority, Request request, ResultListener listener) {
        this.priority = priority;
        this.request = request;
        this.listener = listener;
    }

    @Override
    public int compareTo(Entry o) {
        if (this.priority == o.priority) {
            return -Long.compare(this.entryNum, o.entryNum);
        }
        return Integer.compare(this.priority, o.priority);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entry other = (Entry)obj;
        if (this.priority != other.priority) {
            return false;
        }
        return Objects.equals(this.request, other.request);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + this.priority;
        hash = 53 * hash + Objects.hashCode(this.request);
        return hash;
    }
}

