/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api.queue;

import chatty.util.Debugging;
import chatty.util.api.queue.Entry;
import chatty.util.api.queue.Request;
import chatty.util.api.queue.ResultListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.logging.Logger;

public class QueuedApi {
    private static final Logger LOGGER = Logger.getLogger(QueuedApi.class.getName());
    private final PriorityBlockingQueue<Entry> queue;
    private final Set<Entry> requestPending = new HashSet<Entry>();
    private volatile int ratelimitRemaining = -1;
    private final Semaphore activeRequests = new Semaphore(10);

    public QueuedApi() {
        final ExecutorService executor = Executors.newCachedThreadPool();
        this.queue = new PriorityBlockingQueue();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        if (QueuedApi.this.ratelimitRemaining != -1 && QueuedApi.this.ratelimitRemaining < 60) {
                            LOGGER.info("Waiting..");
                            Thread.sleep(10000L);
                        }
                        QueuedApi.this.activeRequests.acquire();
                        Entry entry = (Entry)QueuedApi.this.queue.take();
                        entry.request.setResultListener((result, responseCode, errorResult, ratelimitRemaining) -> {
                            QueuedApi.this.ratelimitRemaining = ratelimitRemaining;
                            QueuedApi.this.activeRequests.release();
                            if (Debugging.isEnabled("requestresponse")) {
                                if (result != null) {
                                    LOGGER.info(result);
                                }
                                if (errorResult != null) {
                                    LOGGER.info("E:" + errorResult);
                                }
                            }
                            entry.listener.result(new ResultListener.Result(result, responseCode, errorResult));
                            QueuedApi.this.removePending(entry);
                        });
                        executor.execute(entry.request);
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.warning("QueuedApi Thread interrupted");
                    return;
                }
            }
        }, "QueuedApi");
        thread.start();
    }

    public void add(String url, String requestMethod, String token, ResultListener listener) {
        Request request = new Request(url);
        request.setToken(token);
        request.setRequestType(requestMethod);
        this.addRequest(1, request, listener);
    }

    public void add(String url, String requestMethod, String jsonData, String token, ResultListener listener) {
        Request request = new Request(url);
        request.setToken(token);
        if (jsonData != null) {
            request.setJSONData(requestMethod, jsonData);
        }
        this.addRequest(1, request, listener);
    }

    public void add(String url, String requestMethod, Map<String, String> data, String token, ResultListener listener) {
        Request request = new Request(url);
        request.setToken(token);
        if (data != null) {
            request.setJSONData(requestMethod, data);
        }
        this.addRequest(1, request, listener);
    }

    private void addRequest(int priority, Request request, ResultListener listener) {
        Entry entry = new Entry(priority, request, listener);
        if (this.checkPending(entry)) {
            this.queue.add(entry);
        } else {
            System.out.println("Duped " + request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPending(Entry entry) {
        Set<Entry> set = this.requestPending;
        synchronized (set) {
            if (!this.requestPending.contains(entry)) {
                this.requestPending.add(entry);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePending(Entry entry) {
        Set<Entry> set = this.requestPending;
        synchronized (set) {
            this.requestPending.remove(entry);
        }
    }

    public static void main(String[] args) {
        QueuedApi api = new QueuedApi();
        ResultListener listener = new ResultListener(){

            @Override
            public void result(ResultListener.Result r) {
                System.out.println("Result: " + r.responseCode + " " + r.text);
            }
        };
    }
}

