/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api.queue;

import chatty.util.api.queue.RequestResultListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;
import org.json.simple.JSONObject;

public class Request
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(Request.class.getName());
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int READ_TIMEOUT = 60000;
    private static final String CLIENT_ID = "spyiu9jqdnfjtwv6l1xjk5zgt8qb91l";
    private String url;
    private RequestResultListener listener;
    private String token;
    private String data = null;
    private String requestMethod = "GET";
    private String contentType = "application/json";

    public Request(String url) {
        this.url = url;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setJSONData(String requestMethod, String data) {
        this.requestMethod = requestMethod;
        this.data = data;
        this.contentType = "application/json";
    }

    public void setJSONData(String requestMethod, Map<String, String> data) {
        this.setJSONData(requestMethod, new JSONObject(data).toJSONString());
    }

    public void setRequestType(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setResultListener(RequestResultListener origin) {
        this.listener = origin;
    }

    @Override
    public void run() {
        if (this.requestMethod.equals("PATCH")) {
            this.apache();
        } else {
            this.regular();
        }
    }

    private void apache() {
        if (this.listener == null) {
            return;
        }
        String responseText = null;
        int responseCode = -1;
        int ratelimitRemaining = -1;
        String responseEncoding = null;
        String requestError = null;
        String errorText = null;
        LOGGER.info(String.format("%s*: %s%s", this.requestMethod, this.url, this.data != null ? " (" + this.data + ")" : ""));
        RequestConfig config = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds(30000L)).setResponseTimeout(30L, TimeUnit.SECONDS).build();
        try (CloseableHttpClient httpclient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();){
            HttpUriRequestBase request = new HttpUriRequestBase(this.requestMethod, new URI(this.url));
            request.addHeader("Client-ID", CLIENT_ID);
            if (this.token != null) {
                request.addHeader("Authorization", "Bearer " + this.token);
            }
            if (this.data != null) {
                StringEntity stringEntity = this.contentType.equals("application/json") ? new StringEntity(this.data, ContentType.APPLICATION_JSON, "UTF-8", false) : new StringEntity(this.data, CHARSET);
                request.setEntity(stringEntity);
            }
            try (CloseableHttpResponse response = httpclient.execute(request);){
                responseCode = response.getCode();
                responseEncoding = Request.getStringHeader(response.getFirstHeader("Content-Encoding"), null);
                ratelimitRemaining = Request.getIntHeader(response.getFirstHeader("Ratelimit-Remaining"), -1);
                HttpEntity responseEntity = response.getEntity();
                if (responseEntity != null) {
                    responseText = EntityUtils.toString(responseEntity, Charset.forName("UTF-8"));
                    EntityUtils.consume(responseEntity);
                    if (!String.valueOf(responseCode).startsWith("2")) {
                        errorText = responseText;
                        responseText = null;
                    }
                }
            }
        }
        catch (IOException | URISyntaxException | ParseException ex) {
            requestError = ex.toString();
        }
        LOGGER.info(String.format(Locale.ROOT, "GOT (%d/%d, %d%s): %s%s", responseCode, ratelimitRemaining, responseText != null ? responseText.length() : -1, responseEncoding != null ? ", " + responseEncoding : "", this.url, Request.makeErrorText(errorText, requestError)));
        this.listener.requestResult(responseText, responseCode, errorText, ratelimitRemaining);
    }

    private static String makeErrorText(String responseErrorText, String requestError) {
        if (responseErrorText != null) {
            return " [" + responseErrorText + "]";
        }
        if (requestError != null) {
            return " [" + requestError + "]";
        }
        return "";
    }

    private static int getIntHeader(Header header, int defaultValue) {
        if (header != null) {
            try {
                return Integer.parseInt(header.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static String getStringHeader(Header header, String defaultValue) {
        if (header != null) {
            return header.getValue();
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regular() {
        if (this.listener == null) {
            return;
        }
        String responseText = null;
        String errorText = null;
        int responseCode = -1;
        int ratelimitRemaining = -1;
        String responseEncoding = null;
        String requestError = null;
        LOGGER.info(String.format("%s: %s%s", this.requestMethod, this.url, this.data != null ? " (" + this.data + ")" : ""));
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(this.url).openConnection();
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(60000);
            connection.setRequestProperty("Accept-Encoding", "gzip");
            connection.setRequestProperty("Client-ID", CLIENT_ID);
            if (this.token != null) {
                connection.setRequestProperty("Authorization", "Bearer " + this.token);
            }
            connection.setRequestMethod(this.requestMethod);
            if (this.data != null) {
                connection.setRequestProperty("Content-Type", this.contentType);
                connection.setDoOutput(true);
                try (OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), CHARSET);){
                    out.write(this.data);
                }
            }
            responseEncoding = connection.getContentEncoding();
            ratelimitRemaining = connection.getHeaderFieldInt("Ratelimit-Remaining", -1);
            InputStream input = Request.checkGZIP(connection.getInputStream(), connection);
            responseText = Request.readText(input);
        }
        catch (SocketTimeoutException ex) {
            requestError = ex.toString();
        }
        catch (IOException ex) {
            requestError = ex.toString();
        }
        finally {
            if (connection != null) {
                try {
                    InputStream errorInput = Request.checkGZIP(connection.getErrorStream(), connection);
                    if (errorInput != null) {
                        errorText = Request.readText(errorInput);
                    }
                    responseCode = connection.getResponseCode();
                }
                catch (IOException errorInput) {}
                connection.disconnect();
            }
        }
        LOGGER.info(String.format(Locale.ROOT, "GOT (%d/%d, %d%s): %s%s", responseCode, ratelimitRemaining, responseText != null ? responseText.length() : -1, responseEncoding != null ? ", " + responseEncoding : "", this.url, Request.makeErrorText(errorText, requestError)));
        this.listener.requestResult(responseText, responseCode, errorText, ratelimitRemaining);
    }

    private static InputStream checkGZIP(InputStream input, HttpURLConnection connection) throws IOException {
        if (input != null && "gzip".equals(connection.getContentEncoding())) {
            return new GZIPInputStream(input);
        }
        return input;
    }

    private static String readText(InputStream input) throws IOException {
        StringBuilder response;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, CHARSET));){
            String line;
            response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        return response.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Request other = (Request)obj;
        if (!Objects.equals(this.url, other.url)) {
            return false;
        }
        if (!Objects.equals(this.token, other.token)) {
            return false;
        }
        if (!Objects.equals(this.data, other.data)) {
            return false;
        }
        if (!Objects.equals(this.requestMethod, other.requestMethod)) {
            return false;
        }
        return Objects.equals(this.contentType, other.contentType);
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Objects.hashCode(this.url);
        hash = 37 * hash + Objects.hashCode(this.token);
        hash = 37 * hash + Objects.hashCode(this.data);
        hash = 37 * hash + Objects.hashCode(this.requestMethod);
        hash = 37 * hash + Objects.hashCode(this.contentType);
        return hash;
    }

    public String toString() {
        return this.url;
    }
}

