/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api.usericons;

import java.util.Objects;

public class BadgeType {
    public final String id;
    public final String version;
    public static final BadgeType EMPTY = new BadgeType(null, null);

    public BadgeType(String id, String version) {
        this.id = id;
        this.version = version;
    }

    public static BadgeType parse(String idVersion) {
        if (idVersion == null) {
            return EMPTY;
        }
        String[] split = idVersion.split("/", 2);
        String id = null;
        String version = null;
        if (!split[0].trim().isEmpty()) {
            id = split[0].trim();
        }
        if (split.length == 2 && !split[1].trim().isEmpty()) {
            version = split[1].trim();
        }
        return new BadgeType(id, version);
    }

    public boolean isEmpty() {
        return this.id == null && this.version == null;
    }

    public int compareTo(BadgeType other) {
        if (this.equals(other)) {
            return 0;
        }
        if (other == null) {
            return -1;
        }
        if (!Objects.equals(this.id, other.id)) {
            return BadgeType.compareString(this.id, other.id);
        }
        if (!Objects.equals(this.version, other.version)) {
            return BadgeType.compareString(this.version, other.version);
        }
        return 0;
    }

    private static int compareString(String a, String b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        return a.compareTo(b);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BadgeType other = (BadgeType)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return Objects.equals(this.version, other.version);
    }

    public boolean equals(String id, String version) {
        return Objects.equals(this.id, id) && Objects.equals(this.version, version);
    }

    public boolean matchesLenient(String id, String version) {
        if (Objects.equals(this.id, id)) {
            if (this.version == null) {
                return true;
            }
            if (Objects.equals(this.version, version)) {
                return true;
            }
        }
        return false;
    }

    public boolean matchesLenient(BadgeType badgeType) {
        return this.matchesLenient(badgeType.id, badgeType.version);
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.id);
        hash = 83 * hash + Objects.hashCode(this.version);
        return hash;
    }

    public String toString() {
        if (this.id != null && this.version != null) {
            return this.id + "/" + this.version;
        }
        if (this.id != null) {
            return this.id;
        }
        return null;
    }
}

