/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api.usericons;

import chatty.Helper;
import chatty.gui.GuiUtil;
import chatty.gui.Highlighter;
import chatty.gui.components.textpane.ChannelTextPane;
import chatty.util.StringUtil;
import chatty.util.api.CachedImage;
import chatty.util.api.CachedImageManager;
import chatty.util.api.usericons.BadgeType;
import chatty.util.api.usericons.UsericonPosition;
import chatty.util.colors.HtmlColors;
import chatty.util.irc.IrcBadges;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;

public class Usericon
implements Comparable {
    private static final Logger LOGGER = Logger.getLogger(Usericon.class.getName());
    public static final int CACHE_TIME = 259200;
    private static final Dimension DEFAULT_ICON_SIZE = new Dimension(18, 18);
    private static final Set<String> statusDef = new HashSet<String>(Arrays.asList("$mod", "$sub", "$admin", "$staff", "$turbo", "$broadcaster", "$bot", "$globalmod", "$anymod", "$vip"));
    public static final int SOURCE_ANY = -1;
    public static final int SOURCE_FALLBACK = 0;
    public static final int SOURCE_TWITCH = 5;
    public static final int SOURCE_TWITCH2 = 6;
    public static final int SOURCE_FFZ = 10;
    public static final int SOURCE_OTHER = 11;
    public static final int SOURCE_CUSTOM = 20;
    public final Type type;
    public final int source;
    public final String channelRestriction;
    public final String channel;
    public final URL url;
    public final URL url2;
    public final Color color;
    public final Dimension baseImageSize;
    public final Dimension targetImageSize;
    public final String restriction;
    public final String fileName;
    public final BadgeType badgeType;
    public final BadgeType badgeTypeRestriction;
    public final boolean removeBadge;
    public final boolean hasRegularImage;
    public final MatchType matchType;
    public final String category;
    public final Highlighter.HighlightItem match;
    public final boolean channelInverse;
    public final Color colorRestriction;
    public final String restrictionValue;
    public final Set<String> usernames;
    public final Set<String> userids;
    public final boolean stop;
    public final boolean first;
    public final String positionValue;
    public final UsericonPosition position;
    public final String metaTitle;
    public final String metaDescription;
    public final String metaUrl;
    private CachedImageManager<Usericon> images;
    private int customScaleMode;

    public Usericon(Builder builder) {
        this.type = builder.type;
        this.fileName = builder.fileName;
        this.source = builder.source;
        this.badgeType = builder.badgeType != null ? builder.badgeType : BadgeType.EMPTY;
        this.metaTitle = builder.metaTitle;
        this.metaDescription = builder.metaDescription;
        this.metaUrl = builder.metaUrl;
        String chan = builder.channel;
        if (chan != null) {
            this.channelRestriction = chan = chan.trim();
            if (chan.startsWith("!")) {
                this.channelInverse = true;
                chan = chan.substring(1);
            } else {
                this.channelInverse = false;
            }
        } else {
            this.channelRestriction = "";
            this.channelInverse = false;
        }
        chan = Helper.toValidChannel(chan);
        if (chan == null) {
            chan = "";
        }
        this.channel = chan;
        this.usernames = builder.usernames;
        this.userids = builder.userids;
        this.url = builder.url;
        this.url2 = builder.url2;
        this.color = builder.color;
        this.targetImageSize = builder.targetImageSize;
        this.baseImageSize = builder.baseImageSize;
        this.removeBadge = builder.url == null;
        this.hasRegularImage = this.fileName == null || !this.fileName.startsWith("$");
        String restrict = builder.restriction;
        if (restrict != null) {
            this.restriction = restrict = restrict.trim();
            if (restrict.contains("$stop")) {
                restrict = restrict.replace("$stop", "").trim();
                this.stop = true;
            } else {
                this.stop = false;
            }
            if (restrict.contains("$first")) {
                restrict = restrict.replace("$first", "").trim();
                this.first = true;
            } else {
                this.first = false;
            }
            Pattern p = Pattern.compile(".*(\\$badge:([^\\s]+)).*");
            Matcher m = p.matcher(restrict);
            if (restrict.contains("$badge:") && m.matches()) {
                restrict = restrict.replace(m.group(1), "").trim();
                this.badgeTypeRestriction = BadgeType.parse(m.group(2));
            } else {
                this.badgeTypeRestriction = BadgeType.EMPTY;
            }
            this.restrictionValue = restrict;
            this.category = restrict.startsWith("$cat:") && restrict.length() > 5 ? restrict.substring(5) : null;
            this.match = restrict.startsWith("$m:") && restrict.length() > "$m:".length() ? new Highlighter.HighlightItem(restrict.substring("$m:".length()), "badge") : null;
            this.colorRestriction = restrict.startsWith("#") && restrict.length() == 7 ? HtmlColors.decode(restrict, null) : (restrict.startsWith("$color:") && restrict.length() > 7 ? HtmlColors.decode(restrict.substring(7), null) : null);
            this.matchType = restrict.startsWith("$cat:") && restrict.length() > 5 ? MatchType.CATEGORY : (this.match != null ? MatchType.MATCH : (this.colorRestriction != null ? MatchType.COLOR : (statusDef.contains(restrict) ? MatchType.STATUS : (Helper.isValidStream(restrict) ? MatchType.NAME : (restrict.equals("$all") || restrict.isEmpty() ? MatchType.ALL : MatchType.UNDEFINED)))));
        } else {
            this.matchType = MatchType.UNDEFINED;
            this.category = null;
            this.match = null;
            this.restriction = null;
            this.restrictionValue = null;
            this.colorRestriction = null;
            this.stop = false;
            this.first = false;
            this.badgeTypeRestriction = BadgeType.EMPTY;
        }
        this.positionValue = builder.position;
        this.position = UsericonPosition.parse(builder.position, this.first);
    }

    public CachedImage<Usericon> getIcon(float scale, int customUsericonScaleMode, CachedImage.CachedImageUser user) {
        return this.getIcon(scale, customUsericonScaleMode, 0, -1.0f, user);
    }

    public CachedImage<Usericon> getIcon(float scale, int customUsericonScaleMode, int maxHeight, float opacity0, CachedImage.CachedImageUser user) {
        float opacity = opacity0 > 0.0f && opacity0 < 1.0f ? opacity0 : -1.0f;
        this.customScaleMode = customUsericonScaleMode;
        if (this.images == null) {
            this.images = new CachedImageManager<Usericon>(this, new CachedImage.CachedImageRequester(){

                @Override
                public String getImageUrl(int scale, CachedImage.ImageType type) {
                    if (scale == 2) {
                        return Usericon.this.url2 != null ? Usericon.this.url2.toString() : null;
                    }
                    if (scale == 1) {
                        return Usericon.this.url.toString();
                    }
                    return null;
                }

                @Override
                public Dimension getBaseSize() {
                    if (Usericon.this.source == 20 && Usericon.this.customScaleMode == 2) {
                        return Usericon.toHeight(Usericon.this.baseImageSize, DEFAULT_ICON_SIZE.height);
                    }
                    if (Usericon.this.baseImageSize != null) {
                        return Usericon.this.baseImageSize;
                    }
                    if (Usericon.this.targetImageSize != null) {
                        return Usericon.this.targetImageSize;
                    }
                    return DEFAULT_ICON_SIZE;
                }

                @Override
                public boolean forceBaseSize() {
                    return true;
                }

                @Override
                public Image modifyImage(ImageIcon icon) {
                    icon = Usericon.this.addColor(icon, Usericon.this.color);
                    icon = Usericon.this.substituteColor(icon);
                    icon = ChannelTextPane.addSpaceToIcon(icon);
                    return icon.getImage();
                }
            }, "usericon");
        }
        if (this.targetImageSize != null) {
            scale = 1.0f;
        }
        Object customKey = null;
        if (this.source == 20) {
            if (customUsericonScaleMode == 0) {
                scale = 1.0f;
            }
            if (customUsericonScaleMode == 2) {
                customKey = 1;
            }
        }
        Function<ImageIcon, Image> imageModifier = null;
        if (opacity != -1.0f) {
            customKey = customKey + "/" + opacity;
            imageModifier = icon -> ChannelTextPane.getIconWithOpacity(icon, opacity).getImage();
        }
        return this.images.getIcon(scale, maxHeight, customKey, CachedImage.ImageType.STATIC, imageModifier, user);
    }

    private static Dimension toHeight(Dimension d, int targetHeight) {
        int width = d.width;
        int height = d.height;
        width /= height / targetHeight;
        height = targetHeight;
        return new Dimension(width, height);
    }

    private ImageIcon addColor(ImageIcon icon, Color color) {
        if (color == null) {
            return icon;
        }
        BufferedImage newImage = new BufferedImage(icon.getIconWidth(), icon.getIconWidth(), 2);
        Graphics g = newImage.getGraphics();
        g.setColor(color);
        g.drawImage(icon.getImage(), 0, 0, color, null);
        g.dispose();
        return new ImageIcon(newImage);
    }

    private ImageIcon substituteColor(ImageIcon icon) {
        Color target;
        Color search;
        if (this.type == Type.OTHER && this.badgeType.id == null) {
            LOGGER.warning("Badge of type OTHER has no id set: " + this);
            return icon;
        }
        if (this.type == Type.OTHER && this.badgeType.id.equals("announcement") && !(search = Color.BLACK).equals(target = HtmlColors.decode(this.badgeType.version))) {
            return GuiUtil.substituteColor(icon, search, target);
        }
        return icon;
    }

    public int compareTo(Object o) {
        if (o instanceof Usericon) {
            Usericon icon = (Usericon)o;
            if (icon.source > this.source) {
                return 1;
            }
            if (icon.source < this.source) {
                return -1;
            }
            if (icon.type != this.type) {
                return icon.type.compareTo(this.type);
            }
            if (!Objects.equals(icon.badgeType, this.badgeType)) {
                return this.badgeType.compareTo(icon.badgeType);
            }
            return icon.channelRestriction.compareTo(this.channelRestriction);
        }
        return 0;
    }

    public String toString() {
        return String.format("%s[%s,%s]/%s/%s/%s(%s)", Usericon.typeToString(this.type), this.badgeType.id, this.badgeType.version, this.source, this.channelRestriction, this.restriction, this.hasRegularImage ? "L" : (this.removeBadge ? "R" : "E"));
    }

    public String readableLenientType() {
        Type type = this.type;
        if (type == Type.TWITCH) {
            type = Usericon.typeFromBadgeId(this.badgeType.id);
        }
        if (type == null) {
            return this.badgeType.id;
        }
        if (type == Type.OTHER) {
            return "Other/" + this.badgeType.id;
        }
        return type.label;
    }

    public static String typeToString(Type type) {
        return type.shortLabel;
    }

    public static Color getColorFromType(Type type) {
        return type.color;
    }

    public String getSymbol() {
        if (this.type.symbol != null) {
            return this.type.symbol;
        }
        if (Usericon.typeFromBadgeId(this.badgeType.id) != null) {
            return Usericon.typeFromBadgeId((String)this.badgeType.id).symbol;
        }
        return "?";
    }

    public String getIdAndVersion() {
        return this.badgeType.toString();
    }

    public static Type typeFromBadgeId(String badgeId) {
        if (badgeId == null) {
            return null;
        }
        for (Type type : Type.values()) {
            if (!badgeId.equals(type.badgeId)) continue;
            return type;
        }
        return null;
    }

    public static String makeBadgeInfo(IrcBadges badgesDef) {
        StringBuilder b = new StringBuilder();
        badgesDef.forEach((id, version) -> {
            Type type = Usericon.typeFromBadgeId(id);
            if (type != null) {
                if (b.length() > 0) {
                    b.append("|");
                }
                b.append(type.shortLabel);
                if (version != null && !version.equals("1")) {
                    b.append("/").append((String)version);
                }
            }
        });
        if (b.length() > 0) {
            b.insert(0, "[");
            b.append("]");
        }
        return b.toString();
    }

    public static class Builder {
        private final Type type;
        private final int source;
        private String channel;
        private URL url;
        private URL url2;
        private Color color;
        private String restriction;
        private String fileName;
        private BadgeType badgeType;
        private String metaTitle = "";
        private String metaDescription = "";
        private String metaUrl = "";
        private Set<String> usernames;
        private Set<String> userids;
        private String position;
        private Dimension baseImageSize;
        private Dimension targetImageSize;

        public Builder(Type type, int source) {
            this.type = type;
            this.source = source;
        }

        public Builder setChannel(String channel) {
            this.channel = channel;
            return this;
        }

        public Builder setUrl(URL url) {
            this.url = url;
            return this;
        }

        public Builder setUrl2(URL url2) {
            this.url2 = url2;
            return this;
        }

        public Builder setColor(Color color) {
            this.color = color;
            return this;
        }

        public Builder setRestriction(String restriction) {
            this.restriction = restriction;
            return this;
        }

        public Builder setFileName(String fileName) {
            this.fileName = StringUtil.trim(fileName);
            return this;
        }

        public Builder setBadgeType(String id, String version) {
            this.badgeType = new BadgeType(id, version);
            return this;
        }

        public Builder setBadgeType(BadgeType badgeType) {
            this.badgeType = badgeType;
            return this;
        }

        public Builder setMetaTitle(String title) {
            if (title == null) {
                title = "";
            }
            this.metaTitle = title.trim();
            return this;
        }

        public Builder setMetaDescription(String description) {
            if (description == null) {
                description = "";
            }
            this.metaDescription = description.trim();
            return this;
        }

        public Builder setMetaUrl(String url) {
            if (url == null) {
                url = "";
            }
            this.metaUrl = url.trim();
            return this;
        }

        public Builder setUsernames(Collection<String> usernames) {
            if (usernames != null) {
                this.usernames = Collections.unmodifiableSet(new HashSet<String>(usernames));
            }
            return this;
        }

        public Builder setUserids(Collection<String> userids) {
            if (userids != null) {
                this.userids = Collections.unmodifiableSet(new HashSet<String>(userids));
            }
            return this;
        }

        public Builder setPosition(String position) {
            this.position = position;
            return this;
        }

        public Builder setBaseImageSize(int width, int height) {
            this.baseImageSize = new Dimension(width, height);
            return this;
        }

        public Builder setTargetImageSize(int width, int height) {
            this.targetImageSize = new Dimension(width, height);
            return this;
        }

        public Usericon build() {
            return new Usericon(this);
        }
    }

    public static enum Type {
        MOD(0, "Moderator", "MOD", "@", "moderator", HtmlColors.decode("#34ae0a")),
        TURBO(1, "Turbo", "TRB", "+", "turbo", HtmlColors.decode("#6441a5")),
        BROADCASTER(2, "Broadcaster", "BRC", "~", "broadcaster", HtmlColors.decode("#e71818")),
        STAFF(3, "Staff", "STA", "&", "staff", HtmlColors.decode("#200f33")),
        ADMIN(4, "Admin", "ADM", "!", "admin", HtmlColors.decode("#faaf19")),
        SUB(5, "Subscriber", "SUB", "%", "subscriber", null),
        ADDON(6, "Addon", "ADD", "'", null, null),
        GLOBAL_MOD(7, "Global Moderator", "GLM", "*", "global_mod", HtmlColors.decode("#0c6f20")),
        BOT(8, "Bot", "BOT", "^", null, null),
        TWITCH(9, "Twitch Badge", "TWB", null, null, null),
        PRIME(10, "Prime", "PRM", "+", "premium", null),
        BITS(11, "Bits", "BIT", "$", "bits", null),
        OTHER(12, "Other", "OTH", "'", null, null),
        VIP(13, "VIP", "VIP", "!", "vip", null),
        HL(14, "Highlighted by channel points", "HL", "'", null, null),
        CHANNEL_LOGO(15, "Channel Logo", "CHL", null, null, null),
        FOUNDER(16, "Founder", "FND", "%", "founder", null),
        ALL(17, "All Types", "ALL", "", null, null),
        FIRSTMSG(18, "First Message in Channel", "FMG", "'", null, null),
        UNDEFINED(-1, "Undefined", "UDF", null, null, null);

        public Color color;
        public String label;
        public String shortLabel;
        public int id;
        public String symbol;
        public String badgeId;

        private Type(int id, String label, String shortLabel, String symbol, String badgeId, Color color) {
            this.color = color;
            this.label = label;
            this.shortLabel = shortLabel;
            this.id = id;
            this.symbol = symbol;
            this.badgeId = badgeId;
        }

        public static Type getTypeFromId(int typeId) {
            for (Type type : Type.values()) {
                if (type.id != typeId) continue;
                return type;
            }
            return UNDEFINED;
        }
    }

    public static enum MatchType {
        CATEGORY,
        UNDEFINED,
        ALL,
        STATUS,
        NAME,
        COLOR,
        MATCH;

    }
}

