/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api.usericons;

import chatty.Chatty;
import chatty.Helper;
import chatty.util.ImageCache;
import chatty.util.api.usericons.BadgeType;
import chatty.util.api.usericons.Usericon;
import chatty.util.colors.HtmlColors;
import java.awt.Color;
import java.awt.Dimension;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.logging.Logger;

public class UsericonFactory {
    private static final Logger LOGGER = Logger.getLogger(UsericonFactory.class.getName());

    public static Usericon createTwitchIcon(Usericon.Type type, String channel, String urlString, String urlString2, String title) {
        return UsericonFactory.createIconFromUrl(type, channel, urlString, urlString2, 5, null, title);
    }

    public static Usericon createTwitchLikeIcon(Usericon.Type type, String channel, String urlString, String urlString2, int source, String title) {
        return UsericonFactory.createIconFromUrl(type, channel, urlString, urlString2, source, Usericon.getColorFromType(type), title);
    }

    public static Usericon createIconFromUrl(Usericon.Type type, String channel, String urlString, String url2String, int source, Color color, String title) {
        try {
            URL url = new URL(Helper.checkHttpUrl(urlString));
            URL url2 = Helper.createUrlNoError(Helper.checkHttpUrl(url2String));
            Usericon.Builder b = new Usericon.Builder(type, source);
            b.setChannel(channel);
            b.setUrl(url);
            b.setUrl2(url2);
            b.setColor(color);
            b.setMetaTitle(title);
            return b.build();
        }
        catch (MalformedURLException ex) {
            LOGGER.warning("Invalid icon url: " + urlString);
            return null;
        }
    }

    public static Usericon createTwitchBadge(String id, String version, String urlString, String url2String, String channel, String title, String description, String clickUrl) {
        try {
            URL url = new URL(Helper.checkHttpUrl(urlString));
            URL url2 = Helper.createUrlNoError(Helper.checkHttpUrl(url2String));
            Usericon.Builder b = new Usericon.Builder(Usericon.Type.TWITCH, 6);
            b.setChannel(channel);
            b.setBadgeType(id, version);
            b.setUrl(url);
            b.setUrl2(url2);
            b.setMetaTitle(title);
            b.setMetaDescription(description);
            b.setMetaUrl(clickUrl);
            return b.build();
        }
        catch (MalformedURLException ex) {
            LOGGER.warning("Invalid icon url: " + urlString);
            return null;
        }
    }

    public static Usericon createThirdParty(String id, String version, String urlString, String url2String, String title, String clickUrl, String color, Set<String> usernames, Set<String> userids, String position) {
        try {
            URL url = new URL(Helper.checkHttpUrl(urlString));
            URL url2 = Helper.createUrlNoError(Helper.checkHttpUrl(url2String));
            Usericon.Builder b = new Usericon.Builder(Usericon.Type.OTHER, 11);
            b.setBadgeType(id, version);
            b.setUrl(url);
            b.setUrl2(url2);
            b.setMetaTitle(title);
            b.setMetaUrl(clickUrl);
            b.setUsernames(usernames);
            b.setUserids(userids);
            b.setPosition(position);
            if (color != null) {
                b.setColor(HtmlColors.decode(color));
            }
            return b.build();
        }
        catch (MalformedURLException ex) {
            LOGGER.warning("Invalid icon url: " + urlString);
            return null;
        }
    }

    public static Usericon createChannelLogo(String channel, String url, int size) {
        try {
            Usericon.Builder b = new Usericon.Builder(Usericon.Type.CHANNEL_LOGO, 11);
            b.setChannel(channel);
            b.setUrl(new URL(url));
            b.setTargetImageSize(size, size);
            return b.build();
        }
        catch (MalformedURLException ex) {
            LOGGER.warning("Invalid icon url: " + url);
            return null;
        }
    }

    public static Usericon createCustomIcon(Usericon.Type type, String idVersion, String restriction, String fileName, String channel, String position) {
        try {
            URL url = null;
            if (fileName != null) {
                if (fileName.startsWith("http")) {
                    url = new URL(fileName);
                } else if (!fileName.trim().isEmpty()) {
                    Path path = Chatty.getPathCreate(Chatty.PathType.IMAGE).resolve(Paths.get(fileName, new String[0]));
                    url = path.toUri().toURL();
                }
            }
            Usericon.Builder b = new Usericon.Builder(type, 20);
            b.setChannel(channel);
            b.setUrl(url);
            b.setRestriction(restriction);
            b.setFileName(fileName);
            b.setBadgeType(BadgeType.parse(idVersion));
            b.setPosition(position);
            if (url != null && !fileName.startsWith("$")) {
                Dimension size = UsericonFactory.getSize(url);
                if (size == null) {
                    LOGGER.warning("Invalid icon file (size): " + fileName);
                    return null;
                }
                b.setBaseImageSize(size.width, size.height);
            }
            return b.build();
        }
        catch (MalformedURLException | InvalidPathException ex) {
            LOGGER.warning("Invalid icon file: " + fileName);
            return null;
        }
    }

    public static Usericon createFallbackIcon(Usericon.Type type, URL url) {
        Usericon.Builder b = new Usericon.Builder(type, 0);
        b.setUrl(url);
        b.setColor(Usericon.getColorFromType(type));
        Dimension size = UsericonFactory.getSize(url);
        if (size != null) {
            b.setBaseImageSize(size.width, size.height);
        }
        return b.build();
    }

    public static Usericon createSpecialOtherIcon(String id, String version, URL url, URL url2, String metatitle) {
        Usericon.Builder b = new Usericon.Builder(Usericon.Type.OTHER, 11);
        b.setUrl(url);
        b.setUrl2(url2);
        b.setBadgeType(id, version);
        b.setMetaTitle(metatitle);
        Dimension size = UsericonFactory.getSize(url);
        if (size != null) {
            b.setBaseImageSize(size.width, size.height);
        }
        return b.build();
    }

    private static Dimension getSize(URL url) {
        ImageCache.ImageResult result = ImageCache.getImage(new ImageCache.ImageRequest(url), "usericon", 259200);
        if (result != null && result.isValidImage()) {
            return result.actualBaseSize;
        }
        return null;
    }
}

