/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api.usericons;

import chatty.Helper;
import chatty.User;
import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.util.Pair;
import chatty.util.api.usericons.Usericon;
import chatty.util.api.usericons.UsericonFactory;
import chatty.util.irc.IrcBadges;
import chatty.util.irc.MsgTags;
import chatty.util.settings.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

public class UsericonManager {
    private static final Logger LOGGER = Logger.getLogger(UsericonManager.class.getName());
    private static final String SETTING_NAME = "customUsericons";
    private static final String SETTING_NAME_HIDDEN_BADGES = "hiddenUsericons";
    private final TreeSet<Usericon> defaultIcons = new TreeSet();
    private final List<Usericon> customIcons = new ArrayList<Usericon>();
    private final List<Usericon> hiddenBadges = new ArrayList<Usericon>();
    private final List<Usericon> thirdParty = new ArrayList<Usericon>();
    private final Map<Pair<String, Integer>, Usericon> channelLogos = new HashMap<Pair<String, Integer>, Usericon>();
    private final Map<String, String> channelLogoUrls = new HashMap<String, String>();
    private final Settings settings;

    public UsericonManager(Settings settings) {
        this.settings = settings;
    }

    public synchronized void addDefaultIcons(List<Usericon> icons) {
        for (Usericon icon : icons) {
            this.addDefaultIcon(icon);
        }
    }

    public synchronized void addDefaultIcon(Usericon icon) {
        if (icon != null) {
            if (this.defaultIcons.contains(icon)) {
                this.defaultIcons.remove(icon);
            }
            this.defaultIcons.add(icon);
        }
    }

    public synchronized void setThirdPartyIcons(List<Usericon> icons) {
        LOGGER.info(String.format(Locale.ROOT, "Added %d third-party badges", icons.size()));
        this.thirdParty.clear();
        this.thirdParty.addAll(icons);
    }

    public synchronized void addChannelLogoUrl(String channel, String url) {
        this.channelLogoUrls.put(channel, url);
    }

    private synchronized Usericon getChannelLogo(String channel, int size) {
        Pair<String, Integer> key = new Pair<String, Integer>(channel, size);
        Usericon icon = this.channelLogos.get(key);
        String url = this.channelLogoUrls.get(channel);
        if (icon == null && url != null && (icon = UsericonFactory.createChannelLogo(channel, url, size)) != null) {
            LOGGER.info("Added StreamChat channel logo: " + icon);
            this.channelLogos.put(key, icon);
        }
        return icon;
    }

    public void init() {
        GuiUtil.edt(() -> {
            this.addFallbackIcons();
            this.loadFromSettings();
            this.loadHiddenBadgesFromSettings();
        });
    }

    private synchronized void addFallbackIcons() {
        this.addFallbackIcon(Usericon.Type.MOD, "icon_mod.png");
        this.addFallbackIcon(Usericon.Type.ADMIN, "icon_admin.png");
        this.addFallbackIcon(Usericon.Type.STAFF, "icon_staff.png");
        this.addFallbackIcon(Usericon.Type.BROADCASTER, "icon_broadcaster.png");
        this.addFallbackIcon(Usericon.Type.SUB, "icon_sub.png");
        this.addFallbackIcon(Usericon.Type.TURBO, "icon_turbo.png");
        this.addFallbackIcon(Usericon.Type.GLOBAL_MOD, "icon_globalmod.png");
        this.addFallbackIcon(Usericon.Type.BOT, "icon_bot.png");
        this.addFallbackIcon(Usericon.Type.HL, "icon_hl.png");
        this.addFallbackIcon(Usericon.Type.FIRSTMSG, "icon_firstmsg.png");
    }

    private void addFallbackIcon(Usericon.Type type, String fileName) {
        this.defaultIcons.add(UsericonFactory.createFallbackIcon(type, MainGui.class.getResource(fileName)));
    }

    public synchronized List<Usericon> getCustomData() {
        return new ArrayList<Usericon>(this.customIcons);
    }

    public synchronized List<Usericon> getHiddenBadgesData() {
        return new ArrayList<Usericon>(this.hiddenBadges);
    }

    public synchronized void setCustomData(List<Usericon> data) {
        this.customIcons.clear();
        this.customIcons.addAll(data);
        this.saveToSettings();
    }

    public synchronized void setHiddenBadgesData(List<Usericon> data) {
        this.hiddenBadges.clear();
        this.hiddenBadges.addAll(data);
        this.saveHiddenBadgesToSettings();
    }

    public synchronized Set<String> getTwitchBadgeTypes() {
        TreeSet<String> result = new TreeSet<String>();
        for (Usericon icon : this.defaultIcons) {
            if (icon.type != Usericon.Type.TWITCH) continue;
            result.add(icon.badgeType.id);
            result.add(icon.badgeType.toString());
        }
        return result;
    }

    public synchronized List<Usericon> getBadges(IrcBadges badgesDef, User user, User localUser, boolean botBadgeEnabled, MsgTags tags, int channelLogoSize) {
        Usericon channelIcon;
        Usericon icon;
        List<Usericon> icons = this.getTwitchBadges(badgesDef, user, tags);
        if (user.isBot() && botBadgeEnabled && (icon = this.getIcon(Usericon.Type.BOT, null, null, user, tags)) != null) {
            icons.add(icon);
        }
        this.addThirdPartyIcons(icons, user, tags);
        this.addAddonIcons(icons, user, tags);
        if (tags != null && tags.isHighlightedMessage() && (icon = this.getIcon(Usericon.Type.HL, null, null, user, tags)) != null) {
            icons.add(0, icon);
        }
        if (tags != null && tags.isTrue("first-msg") && localUser != null && localUser.hasChannelModeratorRights() && (icon = this.getIcon(Usericon.Type.FIRSTMSG, null, null, user, tags)) != null) {
            icons.add(0, icon);
        }
        if ((channelIcon = this.getChannelIcon(user.getChannel(), channelLogoSize)) != null) {
            icons.add(0, channelIcon);
        }
        return icons;
    }

    public synchronized Usericon getChannelIcon(String channel, int channelLogoSize) {
        if (channelLogoSize > 0) {
            return this.getChannelLogo(channel, channelLogoSize);
        }
        return null;
    }

    public synchronized Usericon getSourceChannelIcon(String channel, String msgId, int size) {
        if (size > 0) {
            return this.getChannelLogo(channel, size);
        }
        return null;
    }

    private List<Usericon> getTwitchBadges(IrcBadges badgesDef, User user, MsgTags tags) {
        if (badgesDef == null || badgesDef.isEmpty()) {
            return new ArrayList<Usericon>();
        }
        ArrayList<Usericon> result = new ArrayList<Usericon>();
        for (int i = 0; i < badgesDef.size(); ++i) {
            String value;
            String id = badgesDef.getId(i);
            Usericon icon = this.getIcon(Usericon.Type.TWITCH, id, value = badgesDef.getVersion(i), user, tags);
            if (icon == null) continue;
            result.add(icon);
        }
        return result;
    }

    public synchronized Usericon getIcon(Usericon.Type type, String id, String version, User user, MsgTags tags) {
        if (this.customUsericonsEnabled()) {
            for (Usericon icon : this.customIcons) {
                Usericon refIcon;
                if (!this.iconsMatchesAdvancedType(icon, type, id, version) || !this.iconMatchesUser(icon, user, tags)) continue;
                if (icon.removeBadge) {
                    return icon;
                }
                if (icon.hasRegularImage) {
                    return icon;
                }
                if (!(icon.fileName.equalsIgnoreCase("$ffz") ? (refIcon = this.getDefaultIcon(type, id, version, user, 10)) != null : (icon.fileName.equalsIgnoreCase("$twitch") ? (refIcon = this.getDefaultIcon(type, id, version, user, 6)) != null : icon.fileName.equalsIgnoreCase("$default") && (refIcon = this.getDefaultIcon(type, id, version, user, -1)) != null))) continue;
                return refIcon;
            }
        }
        for (Usericon icon : this.hiddenBadges) {
            if (!this.iconsMatchesAdvancedType(icon, type, id, version)) continue;
            return icon;
        }
        return this.getDefaultIcon(type, id, version, user, -1);
    }

    private Usericon getDefaultIcon(Usericon.Type type, String id, String version, User user, int source) {
        Usericon checked;
        for (Usericon icon : this.defaultIcons) {
            checked = this.checkIcon(icon, type, id, version, user, source);
            if (checked == null) continue;
            return checked;
        }
        for (Usericon icon : this.thirdParty) {
            checked = this.checkIcon(icon, type, id, version, user, source);
            if (checked == null) continue;
            return checked;
        }
        return null;
    }

    private Usericon checkIcon(Usericon icon, Usericon.Type type, String id, String version, User user, int source) {
        if (this.iconsMatchesAdvancedType(icon, type, id, version) && this.iconMatchesUser(icon, user, null) && (source == -1 || icon.source == source)) {
            if (icon.source == 10 && !this.settings.getBoolean("ffzModIcon")) {
                return null;
            }
            return icon;
        }
        return null;
    }

    private boolean customUsericonsEnabled() {
        return this.settings.getBoolean("customUsericonsEnabled");
    }

    private void addAddonIcons(List<Usericon> icons, User user, MsgTags tags) {
        if (this.customUsericonsEnabled()) {
            for (Usericon icon : this.customIcons) {
                if (icon.type != Usericon.Type.ADDON || !this.iconMatchesUser(icon, user, tags) || !icon.hasRegularImage) continue;
                this.insert(icons, icon);
                if (!icon.stop) continue;
                break;
            }
        }
    }

    private void addThirdPartyIcons(List<Usericon> icons, User user, MsgTags tags) {
        for (Usericon icon : this.thirdParty) {
            Usericon transformed;
            if (!this.iconMatchesUser(icon, user, tags) || (transformed = this.getIcon(Usericon.Type.OTHER, icon.badgeType.id, icon.badgeType.version, user, tags)) == null) continue;
            this.insert(icons, transformed);
        }
    }

    private void insert(List<Usericon> icons, Usericon icon) {
        if (icon.position == null) {
            icons.add(icon);
        } else {
            int insertIndex = -1;
            for (int i = 0; i < icons.size(); ++i) {
                if (!icon.position.insertHere(icons.get(i))) continue;
                insertIndex = i;
                break;
            }
            if (insertIndex != -1) {
                icons.add(insertIndex, icon);
            } else {
                icons.add(icon);
            }
        }
    }

    private boolean iconMatchesUser(Usericon icon, User user, MsgTags tags) {
        boolean useridR;
        if (icon.badgeTypeRestriction.id != null) {
            IrcBadges badges = user.getTwitchBadges();
            String id = icon.badgeTypeRestriction.id;
            String version = icon.badgeTypeRestriction.version;
            if (badges == null) {
                return false;
            }
            if (!badges.hasId(id)) {
                return false;
            }
            if (version != null && !badges.get(id).equals(version)) {
                return false;
            }
        }
        if (!icon.channel.isEmpty() && (icon.channel.equalsIgnoreCase(user.getOwnerChannel()) ? icon.channelInverse : !icon.channelInverse)) {
            return false;
        }
        boolean usernameR = icon.usernames == null || user.getName() != null && icon.usernames.contains(user.getName());
        boolean bl = useridR = icon.userids == null || user.getId() != null && icon.userids.contains(user.getId());
        if (icon.usernames != null && icon.userids != null ? !usernameR && !useridR : !usernameR || !useridR) {
            return false;
        }
        if (icon.restriction == null) {
            return true;
        }
        if (icon.matchType == Usericon.MatchType.ALL) {
            return true;
        }
        return icon.matchType == Usericon.MatchType.NAME ? icon.restrictionValue.equalsIgnoreCase(user.getName()) : (icon.matchType == Usericon.MatchType.CATEGORY ? user.hasCategory(icon.category) : (icon.matchType == Usericon.MatchType.MATCH ? icon.match.matches(user, tags) : (icon.matchType == Usericon.MatchType.STATUS ? Helper.matchUserStatus(icon.restrictionValue, user) : icon.matchType == Usericon.MatchType.COLOR && user.getColor().equals(icon.colorRestriction))));
    }

    private boolean iconsMatchesAdvancedType(Usericon icon, Usericon.Type requestedType, String id, String version) {
        if (icon.type == Usericon.Type.ALL) {
            return true;
        }
        return icon.type == requestedType ? icon.badgeType.matchesLenient(id, version) : requestedType == Usericon.Type.TWITCH && icon.type.badgeId != null && icon.type == Usericon.typeFromBadgeId(id) && icon.badgeType.equals(null, null);
    }

    private synchronized void loadFromSettings() {
        List entriesToLoad = this.settings.getList(SETTING_NAME);
        this.customIcons.clear();
        int count = 0;
        for (List entryToLoad : entriesToLoad) {
            Usericon icon = this.listToEntry(entryToLoad);
            if (icon != null) {
                this.customIcons.add(icon);
                ++count;
                continue;
            }
            LOGGER.warning("Usericons: Couldn't load entry " + entryToLoad);
        }
        LOGGER.info("Usericons: Loaded " + count + "/" + entriesToLoad.size());
    }

    private synchronized void loadHiddenBadgesFromSettings() {
        List entriesToLoad = this.settings.getList(SETTING_NAME_HIDDEN_BADGES);
        this.hiddenBadges.clear();
        int count = 0;
        for (List entryToLoad : entriesToLoad) {
            Usericon icon = this.listToEntryHiddenBadges(entryToLoad);
            if (icon != null) {
                this.hiddenBadges.add(icon);
                ++count;
                continue;
            }
            LOGGER.warning("Hidden Usericons: Couldn't load entry " + entryToLoad);
        }
        LOGGER.info("Hidden Usericons: Loaded " + count + "/" + entriesToLoad.size());
    }

    private synchronized void saveToSettings() {
        ArrayList<List> entriesToSave = new ArrayList<List>();
        for (Usericon iconToSave : this.customIcons) {
            entriesToSave.add(this.entryToList(iconToSave));
        }
        this.settings.putList(SETTING_NAME, entriesToSave);
    }

    private synchronized void saveHiddenBadgesToSettings() {
        ArrayList<List> entriesToSave = new ArrayList<List>();
        for (Usericon iconToSave : this.hiddenBadges) {
            entriesToSave.add(this.entryToListHiddenBadges(iconToSave));
        }
        this.settings.putList(SETTING_NAME_HIDDEN_BADGES, entriesToSave);
    }

    private List entryToList(Usericon icon) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(icon.type.id);
        list.add(icon.restriction);
        list.add(icon.fileName);
        list.add(icon.channelRestriction);
        list.add(icon.getIdAndVersion());
        list.add(icon.positionValue);
        return list;
    }

    private List entryToListHiddenBadges(Usericon icon) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(icon.type.id);
        list.add(icon.getIdAndVersion());
        return list;
    }

    private Usericon listToEntry(List list) {
        try {
            Usericon.Type type = Usericon.Type.getTypeFromId(((Number)list.get(0)).intValue());
            String restriction = (String)list.get(1);
            String fileName = (String)list.get(2);
            String channel = (String)list.get(3);
            String idVersion = null;
            if (list.size() > 4) {
                idVersion = (String)list.get(4);
            }
            String position = null;
            if (list.size() > 5) {
                position = (String)list.get(5);
            }
            return UsericonFactory.createCustomIcon(type, idVersion, restriction, fileName, channel, position);
        }
        catch (ClassCastException | IndexOutOfBoundsException ex) {
            return null;
        }
    }

    private Usericon listToEntryHiddenBadges(List list) {
        Usericon.Type type = Usericon.Type.getTypeFromId(((Number)list.get(0)).intValue());
        String idVersion = (String)list.get(1);
        return UsericonFactory.createCustomIcon(type, idVersion, "", "", "", "");
    }

    public synchronized void debug() {
        LOGGER.info(String.format(Locale.ROOT, "Default usericons (%d): %s", this.defaultIcons.size(), this.defaultIcons));
        LOGGER.info(String.format(Locale.ROOT, "Custom usericons (%d): %s", this.customIcons.size(), this.customIcons));
    }

    public synchronized boolean hideBadge(Usericon usericon) {
        boolean alreadyHidden = false;
        for (Usericon icon : this.hiddenBadges) {
            if (!this.iconsMatchesAdvancedType(icon, usericon.type, usericon.badgeType.id, usericon.badgeType.version)) continue;
            alreadyHidden = true;
        }
        if (!alreadyHidden) {
            Usericon customUsericon = UsericonFactory.createCustomIcon(usericon.type, usericon.badgeType.id, "", "", "", "");
            this.hiddenBadges.add(0, customUsericon);
            this.saveHiddenBadgesToSettings();
            return true;
        }
        return false;
    }
}

