/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api.usericons;

import chatty.util.api.usericons.BadgeType;
import chatty.util.api.usericons.Usericon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;

public class UsericonPosition {
    private static final Ref[] modStuff = new Ref[]{Ref.create("moderator"), Ref.create("lead_moderator"), Ref.create("staff"), Ref.create("admin"), Ref.create("global_mod"), Ref.create("broadcaster"), Ref.create("vip")};
    private static final Ref[] subscriber = new Ref[]{Ref.create("subscriber")};
    private static final Ref[] other = new Ref[]{Ref.create(Usericon.Type.OTHER, null)};
    private static final Ref[] bot = new Ref[]{Ref.create(Usericon.Type.BOT, null)};
    private final Collection<Ref> data;

    public static UsericonPosition parse(String input, boolean first) {
        String[] split;
        if (first) {
            return new UsericonPosition(new ArrayList<Ref>());
        }
        if (input == null || input.isEmpty()) {
            return null;
        }
        HashSet<Ref> result = new HashSet<Ref>();
        for (String part : split = input.split(",")) {
            if ((part = part.trim()).equals("$start")) continue;
            if (part.equals("$mod")) {
                result.addAll(Arrays.asList(modStuff));
                continue;
            }
            if (part.equals("$sub")) {
                result.addAll(Arrays.asList(modStuff));
                result.addAll(Arrays.asList(subscriber));
                continue;
            }
            if (part.equals("$end")) {
                return null;
            }
            if (part.equals("$bot")) {
                result.addAll(Arrays.asList(modStuff));
                result.addAll(Arrays.asList(subscriber));
                result.addAll(Arrays.asList(bot));
                continue;
            }
            if (part.startsWith("$other:")) {
                String[] split2 = part.split(":");
                if (split2.length != 2) continue;
                result.add(Ref.create(Usericon.Type.OTHER, split2[1]));
                continue;
            }
            if (part.equals("$other")) {
                result.addAll(Arrays.asList(other));
                continue;
            }
            result.add(Ref.create(part));
        }
        return new UsericonPosition(result);
    }

    private UsericonPosition(Collection<Ref> data) {
        this.data = data;
    }

    public boolean insertHere(Usericon icon) {
        for (Ref ref : this.data) {
            if (!ref.continueSearching(icon)) continue;
            return false;
        }
        return true;
    }

    private static class Ref {
        private final Usericon.Type reqType;
        private final BadgeType reqBadgeType;

        public static Ref create(String badgeType) {
            return new Ref(Usericon.Type.TWITCH, BadgeType.parse(badgeType));
        }

        public static Ref create(Usericon.Type type, String badgeType) {
            return new Ref(type, BadgeType.parse(badgeType));
        }

        private Ref(Usericon.Type type, BadgeType badgeType) {
            this.reqType = type;
            this.reqBadgeType = badgeType;
        }

        public boolean continueSearching(Usericon icon) {
            if (icon.type == Usericon.Type.ADDON) {
                return true;
            }
            if (this.reqBadgeType.isEmpty()) {
                return icon.type == this.reqType;
            }
            if (icon.badgeType.isEmpty()) {
                return icon.type == Usericon.typeFromBadgeId(this.reqBadgeType.id);
            }
            if (icon.type == Usericon.Type.TWITCH || icon.type == Usericon.Type.OTHER) {
                return this.reqType == icon.type && this.reqBadgeType.matchesLenient(icon.badgeType);
            }
            return false;
        }

        public String toString() {
            return (Object)((Object)this.reqType) + " " + this.reqBadgeType;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Ref other = (Ref)obj;
            if (this.reqType != other.reqType) {
                return false;
            }
            return Objects.equals(this.reqBadgeType, other.reqBadgeType);
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode((Object)this.reqType);
            hash = 97 * hash + Objects.hashCode(this.reqBadgeType);
            return hash;
        }
    }
}

