/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.chatlog;

import chatty.Chatty;
import chatty.Helper;
import chatty.Room;
import chatty.User;
import chatty.util.DateTime;
import chatty.util.Timestamp;
import chatty.util.api.StreamInfo;
import chatty.util.api.UserInfo;
import chatty.util.api.eventsub.payloads.ModActionPayload;
import chatty.util.chatlog.LogManager;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Parameters;
import chatty.util.settings.Settings;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;

public class ChatLog {
    private static final Logger LOGGER = Logger.getLogger(ChatLog.class.getName());
    private Timestamp timestamp;
    private final CustomCommand messageTemplate;
    private final Map<String, Compact> compactForChannels;
    private final Settings settings;
    private final Path path;
    private final LogManager log;

    public ChatLog(Settings settings) {
        this.settings = settings;
        this.path = this.createPath();
        if (this.path == null) {
            this.log = null;
        } else {
            String logSplit = settings.getString("logSplit");
            boolean logSubdirectories = settings.getBoolean("logSubdirectories");
            boolean lockFiles = settings.getBoolean("logLockFiles");
            this.log = new LogManager(this.path, logSplit, logSubdirectories, lockFiles);
        }
        this.compactForChannels = new HashMap<String, Compact>();
        try {
            String timestampValue = settings.getString("logTimestamp");
            if (!timestampValue.equals("off")) {
                this.timestamp = new Timestamp(timestampValue, "");
            }
        }
        catch (IllegalArgumentException ex) {
            this.timestamp = null;
        }
        CustomCommand c = CustomCommand.parse(settings.getString("logMessageTemplate"));
        if (c.hasError()) {
            LOGGER.warning("Error in logMessageTemplate: " + c.getSingleLineError());
            c = CustomCommand.parse(settings.getStringDefault("logMessageTemplate"));
        }
        this.messageTemplate = c;
    }

    private Path createPath() {
        String invalidPath = Chatty.getInvalidCustomPath(Chatty.PathType.LOGS);
        if (invalidPath != null) {
            LOGGER.warning("Invalid path for chatlog: " + invalidPath);
            return null;
        }
        return Chatty.getPath(Chatty.PathType.LOGS);
    }

    public Path getPath() {
        return this.path;
    }

    public void start() {
        if (this.log != null) {
            this.log.start();
        }
    }

    public void bits(String channel, User user, int amount) {
        if (amount <= 0) {
            return;
        }
        if (this.isSettingEnabled("logBits") && this.isChanEnabled(channel)) {
            this.writeLine(channel, String.format(Locale.ROOT, "%sBITS: %s (%d)", this.timestamp(), user.getRegularDisplayNick(), amount));
        }
    }

    public void message(String channel, User user, String message, boolean action, String includedChannel) {
        Parameters param;
        String line;
        if (this.isSettingEnabled("logMessage") && this.isChanEnabled(channel) && (line = this.messageTemplate.replace(param = ChatLog.messageParam(user, message, action, this.settings, this.timestamp(user.getRoom(), includedChannel, false)))) != null && !line.isEmpty()) {
            this.writeLine(channel, line);
        }
    }

    public static Parameters messageParam(User user, String message, boolean action, Settings settings, String timestamp) {
        Parameters p = Parameters.create("");
        Helper.addUserParameters(user, null, null, p);
        p.put("msg", message);
        if (action) {
            p.put("action", "true");
        }
        p.put("timestamp", timestamp);
        p.putObject("settings", settings);
        return p;
    }

    public void info(String channel, String message, String includedChannel) {
        if (this.isSettingEnabled("logInfo") && this.isChanEnabled(channel)) {
            this.writeLine(channel, this.timestamp(null, includedChannel, true) + message);
        }
    }

    public void modAction(ModActionPayload data) {
        if (!Helper.isValidStream(data.stream)) {
            return;
        }
        String channel = Helper.toChannel(data.stream);
        if (this.isSettingEnabled("logModAction") && this.isChanEnabled(channel)) {
            this.writeLine(channel, this.timestamp() + String.format("MOD_ACTION: %s (%s)", data.created_by, data.getPseudoCommandStringNoSlash()));
        }
    }

    public void viewerstats(String channel, StreamInfo.ViewerStats stats) {
        if (this.isSettingEnabled("logViewerstats") && this.isChanEnabled(channel) && stats != null && stats.isValid()) {
            this.writeLine(channel, this.timestamp() + stats);
        }
    }

    public void viewercount(String channel, int viewercount) {
        if (this.isSettingEnabled("logViewercount") && this.isChanEnabled(channel)) {
            this.writeLine(channel, this.timestamp() + "VIEWERS: " + Helper.formatViewerCount(viewercount));
        }
    }

    public void system(String channel, String message) {
        if (this.isSettingEnabled("logSystem") && this.isChanEnabled(channel)) {
            this.writeLine(channel, this.timestamp() + message);
        }
    }

    private void writeLine(String channel, String message) {
        if (this.log != null) {
            this.compactClose(channel);
            this.log.writeLine(channel, message);
        }
    }

    public void userBanned(String channel, String nick, long duration, String reason, UserInfo info) {
        String text = nick;
        if (duration > 0L) {
            text = text + " (" + duration + "s)";
        }
        if (reason != null && !reason.isEmpty()) {
            text = text + " [" + reason + "]";
        }
        if (info != null) {
            text = text + " {" + DateTime.formatAccountAge(info.createdAt, DateTime.Formatting.COMPACT) + "}";
        }
        this.compact(channel, "BAN", text);
    }

    public void msgDeleted(User user, String msg) {
        this.compact(user.getRoom().getFilename(), "DELETED", user.getRegularDisplayNick() + " (" + msg + ")");
    }

    public void compact(String channel, String type, String info) {
        if (this.isChanEnabled(channel) && ((type.equals("MOD") || type.equals("UNMOD")) && this.isSettingEnabled("logMod") || (type.equals("JOIN") || type.equals("PART")) && this.isSettingEnabled("logJoinPart") || type.equals("BAN") && this.isSettingEnabled("logBan") || type.equals("DELETED") && this.isSettingEnabled("logDeleted"))) {
            this.compactAdd(channel, type, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactAdd(String channel, String type, String info) {
        Map<String, Compact> map = this.compactForChannels;
        synchronized (map) {
            this.getCompact(channel).add(type, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactClose(String channel) {
        Map<String, Compact> map = this.compactForChannels;
        synchronized (map) {
            if (channel != null) {
                this.getCompact(channel).close();
            } else {
                for (Compact c : this.compactForChannels.values()) {
                    c.close();
                }
            }
        }
    }

    private Compact getCompact(String channel) {
        Compact c = this.compactForChannels.get(channel);
        if (c == null) {
            c = new Compact(channel);
            this.compactForChannels.put(channel, c);
        }
        return c;
    }

    private String timestamp() {
        return this.timestamp(null, null, true);
    }

    private String timestamp(Room room, String includedChannel, boolean appendSpace) {
        String space;
        String string = space = appendSpace ? " " : "";
        if (includedChannel != null) {
            if (this.timestamp != null) {
                return this.timestamp.make(-1L, room) + "[" + includedChannel + "]" + space;
            }
            return "[" + includedChannel + "]" + space;
        }
        if (this.timestamp != null) {
            return this.timestamp.make(-1L, room) + space;
        }
        return "";
    }

    public void close() {
        if (this.log != null) {
            this.compactClose(null);
            this.log.close();
        }
    }

    public void closeChannel(String channel) {
        if (this.log != null) {
            this.compactClose(channel);
            this.log.writeLine(channel, null);
        }
    }

    private boolean isChanEnabled(String channel) {
        if (this.log == null) {
            return false;
        }
        if (channel == null || channel.isEmpty()) {
            return false;
        }
        if (channel.equals("highlighted")) {
            return this.settings.getBoolean("logHighlighted2");
        }
        if (channel.equals("ignored")) {
            return this.settings.getBoolean("logIgnored2");
        }
        if (channel.startsWith("customTab-")) {
            return true;
        }
        String mode = this.settings.getString("logMode");
        if (mode.equals("off")) {
            return false;
        }
        if (mode.equals("always")) {
            return true;
        }
        if (mode.equals("blacklist")) {
            if (!this.settings.listContains("logBlacklist", channel)) {
                return true;
            }
            if (channel.startsWith("$") && !this.settings.listContains("logBlacklist", "$_whisper_")) {
                return true;
            }
        } else if (mode.equals("whitelist")) {
            if (this.settings.listContains("logWhitelist", channel)) {
                return true;
            }
            if (channel.startsWith("$") && this.settings.listContains("logWhitelist", "$_whisper_")) {
                return true;
            }
        }
        return false;
    }

    private boolean isSettingEnabled(String setting) {
        return this.settings.getBoolean(setting);
    }

    private class Compact {
        private static final String SEPERATOR = ", ";
        private static final int MAX_LENGTH = 10;
        private static final int MAX_TIME = 2000;
        private final String channel;
        private StringBuilder text;
        private int length;
        private long start;
        private String mode;

        public Compact(String channel) {
            this.channel = channel;
        }

        protected void add(String type, String info) {
            String seperator = SEPERATOR;
            if (this.start(type)) {
                this.text = new StringBuilder();
                this.text.append(ChatLog.this.timestamp());
                this.text.append(type);
                this.text.append(": ");
                seperator = "";
            }
            this.text.append(seperator);
            this.text.append(info);
            ++this.length;
            if (this.length >= 10) {
                this.close();
            }
        }

        private boolean start(String type) {
            long timePassed = System.currentTimeMillis() - this.start;
            if (timePassed > 2000L) {
                this.close();
            }
            if (!type.equals(this.mode)) {
                this.close();
            }
            if (this.mode == null) {
                this.mode = type;
                this.start = System.currentTimeMillis();
                this.length = 0;
                return true;
            }
            return false;
        }

        protected void close() {
            if (this.mode != null && ChatLog.this.log != null) {
                ChatLog.this.log.writeLine(this.channel, this.text.toString());
                this.mode = null;
            }
        }
    }
}

