/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.chatlog;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.logging.Logger;

public class LogFile {
    private static final Logger LOGGER = Logger.getLogger(LogFile.class.getName());
    private static final String CHARSET = "UTF-8";
    private static final int MAX_ATTEMPTS = 3;
    private BufferedWriter writer;
    private boolean valid;
    private Path file;
    private Calendar currentTime;
    private boolean lockFile = true;

    private LogFile(Path path, String name, boolean lockFile) {
        this.lockFile = lockFile;
        this.currentTime = Calendar.getInstance();
        name = name.replace("*", "_");
        for (int i = 0; i < 3; ++i) {
            String fileName = i == 0 ? name + ".log" : name + "-" + i + ".log";
            this.file = path.resolve(fileName);
            if (this.tryFile(this.file.toFile())) break;
        }
    }

    public static LogFile get(Path path, String name, boolean lockFile) {
        LogFile file = new LogFile(path, name, lockFile);
        if (file.valid) {
            return file;
        }
        return null;
    }

    public boolean write(String line) {
        if (!this.valid) {
            LOGGER.warning("Log: Tried writing to invalid file " + this.file + "");
            return false;
        }
        try {
            this.writer.write(line);
            this.writer.newLine();
            this.writer.flush();
            return true;
        }
        catch (IOException ex) {
            LOGGER.warning("Log: Error writing to " + this.file + " (" + ex.getLocalizedMessage() + ")");
            this.close();
            return false;
        }
    }

    public void close() {
        this.closeResources();
        this.valid = false;
        LOGGER.info("Log: Closed file " + this.file.toAbsolutePath());
    }

    private void closeResources() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException ex) {
            LOGGER.warning("Log: Could not close " + this.file.toAbsolutePath() + " (" + ex.getLocalizedMessage() + ")");
        }
    }

    private boolean tryFile(File file) {
        block4: {
            try {
                LOGGER.info("Log: Trying to open " + file.getAbsolutePath());
                RandomAccessFile raf = new RandomAccessFile(file, "rw");
                raf.seek(raf.length());
                FileChannel channel = raf.getChannel();
                if (this.lockFile) {
                    FileLock lock = channel.tryLock();
                    if (lock != null) {
                        this.writer = new BufferedWriter(Channels.newWriter((WritableByteChannel)channel, CHARSET));
                        this.valid = true;
                        return true;
                    }
                    break block4;
                }
                this.writer = new BufferedWriter(Channels.newWriter((WritableByteChannel)channel, CHARSET));
                this.valid = true;
                return true;
            }
            catch (IOException ex) {
                LOGGER.warning("Log: Lock failed (" + file + " / " + ex + ")");
            }
        }
        LOGGER.warning("Log: Lock failed (" + file + ")");
        return false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isLocked() {
        return this.lockFile && this.valid;
    }

    public Path getPath() {
        return this.file;
    }

    public Calendar getDate() {
        return this.currentTime;
    }
}

