/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.chatlog;

import chatty.util.chatlog.LogWriter;
import java.nio.file.Path;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class LogManager {
    private static final Logger LOGGER = Logger.getLogger(LogManager.class.getName());
    private static final int QUEUE_CAPACITY = 100;
    private static final int MAX_WAIT = 10000;
    private final AtomicInteger errors = new AtomicInteger();
    private final BlockingQueue<LogWriter.LogItem> queue;
    private final Thread writerThread;

    public LogManager(Path path, String splitLogs, boolean useSubdirectories, boolean lockFiles) {
        path.toFile().mkdirs();
        if (!path.toFile().exists()) {
            LOGGER.warning("Log: Failed to create path: " + path);
        }
        this.queue = new LinkedBlockingQueue<LogWriter.LogItem>(100);
        this.writerThread = new Thread((Runnable)new LogWriter(this.queue, path, splitLogs, useSubdirectories, lockFiles), "LogWriter");
    }

    public void start() {
        this.writerThread.start();
    }

    public void close() {
        try {
            boolean added = this.queue.offer(new LogWriter.LogItem(null, null), 10000L, TimeUnit.MILLISECONDS);
            if (added) {
                this.writerThread.join(10000L);
            } else {
                LOGGER.warning("Log: Could not close Log (Queue full)");
            }
        }
        catch (InterruptedException ex) {
            LOGGER.warning("Log: Interrupted when waiting for Log to finish..");
            Thread.currentThread().interrupt();
        }
    }

    public void writeLine(String channel, String line) {
        int current;
        boolean added = this.queue.offer(new LogWriter.LogItem(channel, line));
        if (!added && (current = this.errors.incrementAndGet()) % 20 == 0) {
            LOGGER.warning("Log: Failed writing " + this.errors + " lines (queue full)");
        }
    }
}

