/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.chatlog;

import chatty.util.chatlog.LogFile;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;

public class LogWriter
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(LogWriter.class.getName());
    private static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZ");
    private static final int STATS_INTERVAL = 25000;
    private static final int STATS_TIME_INTERVAL = 900000;
    private final Map<String, LogFile> files = new HashMap<String, LogFile>();
    private final Set<String> errors = new HashSet<String>();
    private final BlockingQueue<LogItem> queue;
    private final Path path;
    private final String splitLogs;
    private final boolean useSubdirectories;
    private final boolean lockFiles;
    private long addedQueueSize;
    private int addedQueueSizeCount;
    private int errorCount;
    private long lastStatsTime;
    private int maxQueueSize;
    private int totalLines;

    public LogWriter(BlockingQueue<LogItem> queue, Path path, String splitLogs, boolean useSubdirectories, boolean lockFiles) {
        this.queue = queue;
        this.path = path;
        this.splitLogs = splitLogs;
        this.useSubdirectories = useSubdirectories;
        this.lockFiles = lockFiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        boolean run = true;
        try {
            block2: while (run) {
                LogItem item = this.queue.take();
                this.stats(this.queue.size());
                if (item.channel == null) {
                    if (item.message == null) {
                        this.outputStats();
                        run = false;
                        this.closeAllFiles();
                        continue;
                    }
                    Iterator<String> iterator = this.files.keySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        String channel = iterator.next();
                        this.handleMessage(channel, item.message);
                    }
                }
                this.handleMessage(item.channel, item.message);
            }
            return;
        }
        catch (InterruptedException ex) {
            System.out.println("Interrupted");
            this.closeAllFiles();
            Thread.currentThread().interrupt();
        }
    }

    private void closeAllFiles() {
        for (String channel : this.files.keySet()) {
            LogFile file = this.files.get(channel);
            this.closeFile(file);
        }
        this.files.clear();
    }

    private void handleMessage(String channel, String message) {
        if (message == null) {
            this.closeFileForChannel(channel);
        } else {
            this.writeLine(channel, message);
        }
    }

    private void writeLine(String channel, String line) {
        LogFile file = this.getFile(channel);
        if (file == null || !file.write(line)) {
            this.fileError(channel);
        }
    }

    private LogFile getFile(String channel) {
        LogFile file = this.files.get(channel);
        String datePrefix = "";
        if (!this.splitLogs.equals("never")) {
            datePrefix = this.getDatePrefix() + "_";
        }
        if (file != null && file.isValid()) {
            if (!datePrefix.isEmpty() && this.shouldSplitLog(file.getDate())) {
                file.close();
                return this.addFile(channel, datePrefix);
            }
            return file;
        }
        if (this.errors.contains(channel)) {
            return null;
        }
        return this.addFile(channel, datePrefix);
    }

    private String getDatePrefix() {
        Calendar date = Calendar.getInstance();
        if (this.splitLogs.equals("daily")) {
            date.set(11, 0);
            date.clear(12);
            date.clear(13);
            date.clear(14);
            return new SimpleDateFormat("yyyy-MM-dd").format(date.getTime());
        }
        if (this.splitLogs.equals("weekly")) {
            date.set(7, date.getFirstDayOfWeek());
            return new SimpleDateFormat("yyyy-MM-dd").format(date.getTime());
        }
        if (this.splitLogs.equals("monthly")) {
            date.set(5, 1);
            return new SimpleDateFormat("yyyy-MM-dd").format(date.getTime());
        }
        return "";
    }

    private boolean shouldSplitLog(Calendar fileDate) {
        Calendar date = Calendar.getInstance();
        return this.splitLogs.equals("daily") ? fileDate.get(6) != date.get(6) : (this.splitLogs.equals("weekly") ? fileDate.get(3) != date.get(3) : this.splitLogs.equals("monthly") && fileDate.get(2) != date.get(2));
    }

    private LogFile addFile(String channel, String datePrefix) {
        LogFile file;
        Path channelPath = this.path;
        if (this.useSubdirectories) {
            channelPath = channelPath.resolve(channel);
            channelPath.toFile().mkdirs();
            if (!channelPath.toFile().exists()) {
                LOGGER.warning("Log: Failed to create path: " + channelPath);
            }
        }
        if ((file = LogFile.get(channelPath, datePrefix + channel, this.lockFiles)) == null) {
            this.errors.add(channel);
        } else {
            this.files.put(channel, file);
            file.write("# Log started: " + this.getDateTime());
            LOGGER.info("Log: Opened file " + file.getPath() + (file.isLocked() ? " (locked)" : ""));
        }
        return file;
    }

    private void fileError(String channel) {
        this.files.remove(channel);
        this.errors.add(channel);
        ++this.errorCount;
    }

    private void closeFileForChannel(String channel) {
        LogFile file = this.files.get(channel);
        this.closeFile(file);
        this.files.remove(channel);
    }

    private void closeFile(LogFile file) {
        if (file != null && file.isValid()) {
            file.write("# Log closed: " + this.getDateTime());
            file.write("-");
            file.close();
        }
    }

    private String getDateTime() {
        Calendar cal = Calendar.getInstance();
        return dateTimeFormat.format(cal.getTime());
    }

    private void stats(int size) {
        this.addedQueueSize += (long)size;
        ++this.addedQueueSizeCount;
        ++this.totalLines;
        if (this.maxQueueSize < size) {
            this.maxQueueSize = size;
        }
        long lastStatsAgo = System.currentTimeMillis() - this.lastStatsTime;
        if (this.addedQueueSizeCount > 25000 || lastStatsAgo > 900000L) {
            this.outputStats();
        }
    }

    private void outputStats() {
        long avg = this.addedQueueSizeCount > 0 ? this.addedQueueSize / (long)this.addedQueueSizeCount : 0L;
        LOGGER.info("Log: total: " + this.totalLines + " / queue size (avg: " + avg + ", max: " + this.maxQueueSize + ") / errors: " + this.errorCount);
        this.addedQueueSize = 0L;
        this.addedQueueSizeCount = 0;
        this.errorCount = 0;
        this.maxQueueSize = 0;
        this.lastStatsTime = System.currentTimeMillis();
    }

    public static class LogItem {
        public final String channel;
        public final String message;

        public LogItem(String channel, String message) {
            this.channel = channel;
            this.message = message;
        }
    }
}

