/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.colors;

import java.awt.Color;

public class ColorCorrection {
    public static int getBrightness(Color color) {
        return (color.getRed() * 299 + color.getGreen() * 587 + color.getBlue() * 114) / 1000;
    }

    public static boolean isDarkColor(Color color) {
        return ColorCorrection.getBrightness(color) < 128;
    }

    public static boolean isLightColor(Color color) {
        return ColorCorrection.getBrightness(color) >= 128;
    }

    public static int getBrightnessDifference(Color c1, Color c2) {
        int b1 = ColorCorrection.getBrightness(c1);
        int b2 = ColorCorrection.getBrightness(c2);
        return b1 - b2;
    }

    public static Color correctReadability(Color foreground, Color background) {
        int bd = ColorCorrection.getBrightnessDifference(foreground, background);
        if (Math.abs(bd) < 50) {
            foreground = ColorCorrection.getBrightness(background) > 180 ? ColorCorrection.makeDarker(foreground, 0.5f) : ColorCorrection.makeBrighter(foreground, 0.5f);
        }
        return foreground;
    }

    public static Color makeBrighter(Color color, float factor) {
        int blue;
        int green;
        int red = color.getRed();
        float[] hsb = Color.RGBtoHSB(red, green = color.getGreen(), blue = color.getBlue(), null);
        if (hsb[2] == 1.0f) {
            red += 150;
            green += 150;
            if ((blue += 150) > 255) {
                blue = 255;
            }
            if (red > 255) {
                red = 255;
            }
            if (green > 255) {
                green = 255;
            }
            hsb = Color.RGBtoHSB(red, green, blue, null);
        }
        return Color.getHSBColor(hsb[0], hsb[1], factor * (1.0f + hsb[2]));
    }

    public static Color makeDarker(Color color, float factor) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(hsb[0], hsb[1], factor * hsb[2]);
    }
}

