/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.colors;

import java.awt.Color;

public class ColorCorrectionNew {
    public static int getLightness(Color c) {
        return (int)((double)c.getRed() * 0.2126 + (double)c.getGreen() * 0.7152 + (double)c.getBlue() * 0.0722);
    }

    public static int getLightnessDifference(Color c1, Color c2) {
        int b1 = ColorCorrectionNew.getLightness(c1);
        int b2 = ColorCorrectionNew.getLightness(c2);
        return b1 - b2;
    }

    public static int getLightnessDifferenceAbs(Color c1, Color c2) {
        return Math.abs(ColorCorrectionNew.getLightnessDifference(c1, c2));
    }

    public static Color correctReadability(Color foreground, Color background, int threshold) {
        boolean darkBg = ColorCorrectionNew.getLightness(background) < 180;
        int diff = ColorCorrectionNew.getLightnessDifference(foreground, background);
        if (!darkBg) {
            diff *= -1;
            threshold += 10;
        }
        if ((diff = Math.max(0, diff)) < threshold) {
            float factor = (1.0f - (float)diff / (float)threshold) / 2.0f;
            foreground = !darkBg ? ColorCorrectionNew.makeDarker(foreground, 1.0f - factor) : ColorCorrectionNew.makeBrighter(foreground, factor);
        }
        return foreground;
    }

    public static Color makeBrighter(Color c, float factor) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int rr = 255 - r;
        int rg = 255 - g;
        int rb = 255 - b;
        int cr = r + (int)((float)rr * factor);
        int cg = g + (int)((float)rg * factor);
        int cb = b + (int)((float)rb * factor);
        return new Color(cr, cg, cb);
    }

    public static Color makeDarker(Color c, float factor) {
        return new Color((int)((float)c.getRed() * factor), (int)((float)c.getGreen() * factor), (int)((float)c.getBlue() * factor));
    }

    public static Color offset(Color c, float factor) {
        if (ColorCorrectionNew.getLightness(c) < 180) {
            return ColorCorrectionNew.makeBrighter(c, 1.0f - factor);
        }
        return ColorCorrectionNew.makeDarker(c, factor);
    }

    public static Color toLightness(Color c, int target) {
        float current = ColorCorrectionNew.getLightness(c);
        if ((float)target == current) {
            return c;
        }
        if ((float)target > current) {
            float factor = ((float)target - current) / (255.0f - current);
            return ColorCorrectionNew.makeBrighter(c, factor);
        }
        return ColorCorrectionNew.makeDarker(c, (float)target / current);
    }

    public static Color matchLightness(Color toModify, Color reference, float factor) {
        if (factor == 0.0f) {
            return toModify;
        }
        int lightness = ColorCorrectionNew.getLightness(toModify);
        int lightnessRef = ColorCorrectionNew.getLightness(reference);
        int diff = (int)((float)(lightness - lightnessRef) * factor);
        return ColorCorrectionNew.toLightness(toModify, lightness -= diff);
    }

    public static void main(String[] args) {
    }
}

