/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.colors;

import chatty.util.colors.ColorCorrection;
import chatty.util.colors.ColorCorrectionNew;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class ColorCorrector {
    public static final Map<String, ColorCorrector> TYPES = new LinkedHashMap<String, ColorCorrector>();
    public static final List<String> ACTIVE_TYPES = new ArrayList<String>();

    public abstract Color correctColor(Color var1, Color var2);

    public static ColorCorrector get(String type) {
        if (!TYPES.containsKey(type)) {
            type = "normal";
        }
        return TYPES.get(type);
    }

    static {
        TYPES.put("normal", new ColorCorrector(){

            @Override
            public Color correctColor(Color foreground, Color background) {
                return ColorCorrectionNew.correctReadability(foreground, background, 60);
            }
        });
        TYPES.put("strong", new ColorCorrector(){

            @Override
            public Color correctColor(Color foreground, Color background) {
                return ColorCorrectionNew.correctReadability(foreground, background, 140);
            }
        });
        TYPES.put("old", new ColorCorrector(){

            @Override
            public Color correctColor(Color foreground, Color background) {
                return ColorCorrection.correctReadability(foreground, background);
            }
        });
        TYPES.put("gray", new ColorCorrector(){

            @Override
            public Color correctColor(Color foreground, Color background) {
                foreground = ColorCorrectionNew.correctReadability(foreground, background, 80);
                int brightness = ColorCorrection.getBrightness(foreground);
                return new Color(brightness, brightness, brightness);
            }
        });
        TYPES.put("off", new ColorCorrector(){

            @Override
            public Color correctColor(Color foreground, Color background) {
                return foreground;
            }
        });
        TYPES.keySet().forEach(type -> {
            if (!type.equals("off")) {
                ACTIVE_TYPES.add((String)type);
            }
        });
    }
}

