/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.colors;

import chatty.gui.NamedColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class HtmlColors {
    private static volatile Color defaultColor = Color.BLACK;
    private static final ArrayList<NamedColor> colors = new ArrayList();

    public static String getNamedColorString(Color color) {
        return HtmlColors.getNamedColorString(color, false);
    }

    public static String getNamedColorString(Color color, boolean verbose) {
        if (color == null) {
            return null;
        }
        for (NamedColor c : colors) {
            if (!c.equals(color)) continue;
            if (verbose) {
                return String.format("%s (%s)", c.getName(), HtmlColors.getColorString(color));
            }
            return c.getName();
        }
        return HtmlColors.getColorString(color);
    }

    private static void add(String name, int r, int g, int b) {
        colors.add(new NamedColor(name, r, g, b));
    }

    private static void add(int r, int g, int b, String ... names) {
        colors.add(new NamedColor(names, r, g, b));
    }

    public static NamedColor getNamedColor(String name) {
        for (NamedColor color : colors) {
            if (!color.hasName(name)) continue;
            return color;
        }
        return null;
    }

    public static List<NamedColor> getNamedColors() {
        return new ArrayList<NamedColor>(colors);
    }

    public static Color decode(String color, Color defaultColor) {
        if (color == null) {
            return defaultColor;
        }
        Color c = HtmlColors.getNamedColor(color);
        if (c == null) {
            try {
                c = Color.decode(color);
            }
            catch (NumberFormatException ex) {
                return defaultColor;
            }
        }
        return c;
    }

    public static Color decode(String color) {
        return HtmlColors.decode(color, defaultColor);
    }

    public static void setDefaultColor(Color color) {
        defaultColor = color;
    }

    public static String getColorString(Color color) {
        if (color == null) {
            return null;
        }
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()).toUpperCase();
    }

    static {
        HtmlColors.add("White", 255, 255, 255);
        HtmlColors.add("Silver", 192, 192, 192);
        HtmlColors.add(128, 128, 128, "Grey", " Gray");
        HtmlColors.add("Black", 0, 0, 0);
        HtmlColors.add("Red", 255, 0, 0);
        HtmlColors.add("Maroon", 128, 0, 0);
        HtmlColors.add("Yellow", 255, 255, 0);
        HtmlColors.add("Olive", 128, 128, 0);
        HtmlColors.add("Lime", 0, 255, 0);
        HtmlColors.add("Green", 0, 128, 0);
        HtmlColors.add(0, 255, 255, "Aqua", "Cyan");
        HtmlColors.add("Teal", 0, 128, 128);
        HtmlColors.add("Blue", 0, 0, 255);
        HtmlColors.add("Navy", 0, 0, 128);
        HtmlColors.add(255, 0, 255, "Fuchsia", "Magenta");
        HtmlColors.add("Purple", 128, 0, 128);
        HtmlColors.add("Pink", 255, 192, 203);
        HtmlColors.add("LightPink", 255, 182, 193);
        HtmlColors.add("HotPink", 255, 105, 180);
        HtmlColors.add("DeepPink", 255, 20, 147);
        HtmlColors.add("PaleVioletRed", 219, 112, 147);
        HtmlColors.add("MediumVioletRed", 199, 21, 133);
        HtmlColors.add("LightSalmon", 255, 160, 122);
        HtmlColors.add("Salmon", 250, 128, 114);
        HtmlColors.add("DarkSalmon", 233, 150, 122);
        HtmlColors.add("LightCoral", 240, 128, 128);
        HtmlColors.add("IndianRed", 205, 92, 92);
        HtmlColors.add("Crimson", 220, 20, 60);
        HtmlColors.add("Firebrick", 178, 34, 34);
        HtmlColors.add("DarkRed", 139, 0, 0);
        HtmlColors.add("Red", 255, 0, 0);
        HtmlColors.add("OrangeRed", 255, 69, 0);
        HtmlColors.add("Tomato", 255, 99, 71);
        HtmlColors.add("Coral", 255, 127, 80);
        HtmlColors.add("DarkOrange", 255, 140, 0);
        HtmlColors.add("Orange", 255, 165, 0);
        HtmlColors.add("Gold", 255, 215, 0);
        HtmlColors.add("LightYellow", 255, 255, 224);
        HtmlColors.add("LemonChiffon", 255, 250, 205);
        HtmlColors.add("LightGoldenrodYellow", 250, 250, 210);
        HtmlColors.add("PapayaWhip", 255, 239, 213);
        HtmlColors.add("Moccasin", 255, 228, 181);
        HtmlColors.add("PeachPuff", 255, 218, 185);
        HtmlColors.add("PaleGoldenrod", 238, 232, 170);
        HtmlColors.add("Khaki", 240, 230, 140);
        HtmlColors.add("DarkKahki", 189, 183, 107);
        HtmlColors.add("Cornsilk", 255, 248, 220);
        HtmlColors.add("BlanchedAlmond", 255, 235, 205);
        HtmlColors.add("Bisque", 255, 228, 196);
        HtmlColors.add("NavajoWhite", 255, 222, 173);
        HtmlColors.add("Wheat", 245, 222, 179);
        HtmlColors.add("BurlyWood", 222, 184, 135);
        HtmlColors.add("Tan", 210, 180, 140);
        HtmlColors.add("Rosybrown", 188, 143, 143);
        HtmlColors.add("SandyBrown", 244, 164, 96);
        HtmlColors.add("Goldenrod", 218, 165, 32);
        HtmlColors.add("DarkGoldenrod", 184, 134, 11);
        HtmlColors.add("Peru", 205, 133, 63);
        HtmlColors.add("Chocolate", 210, 105, 30);
        HtmlColors.add("SaddleBrown", 139, 69, 19);
        HtmlColors.add("Sienna", 160, 82, 45);
        HtmlColors.add("Brown", 165, 42, 42);
        HtmlColors.add("Maroon", 128, 0, 0);
        HtmlColors.add("DarkOliveGreen", 85, 107, 47);
        HtmlColors.add("OlveDrab", 107, 142, 35);
        HtmlColors.add("YellowGreen", 154, 205, 50);
        HtmlColors.add("LimeGreen", 50, 205, 50);
        HtmlColors.add("LawnGreen", 124, 252, 0);
        HtmlColors.add("Chartreuse", 127, 255, 0);
        HtmlColors.add("GreenYellow", 173, 255, 47);
        HtmlColors.add("SpringGreen", 0, 255, 127);
        HtmlColors.add("MediumSpringGreen", 0, 250, 154);
        HtmlColors.add("LightGreen", 144, 238, 144);
        HtmlColors.add("PaleGreen", 152, 251, 152);
        HtmlColors.add("DarkSeaGreen", 143, 188, 143);
        HtmlColors.add("MediumSeaGreen", 60, 179, 113);
        HtmlColors.add("SeaGreen", 46, 139, 87);
        HtmlColors.add("ForestGreen", 34, 139, 34);
        HtmlColors.add("DarkGreen", 0, 100, 0);
        HtmlColors.add("MediumAquamarine", 102, 205, 170);
        HtmlColors.add("Cyan", 0, 255, 255);
        HtmlColors.add("LightCyan", 224, 255, 255);
        HtmlColors.add("PaleTurquoise", 175, 238, 238);
        HtmlColors.add("Aquamarine", 127, 255, 212);
        HtmlColors.add("Turquoise", 64, 224, 208);
        HtmlColors.add("MediumTurquoise", 72, 209, 204);
        HtmlColors.add("DarkTurquoise", 0, 206, 209);
        HtmlColors.add("LightSeaGreen", 32, 178, 170);
        HtmlColors.add("CadetBlue", 95, 158, 160);
        HtmlColors.add("DarkCyan", 0, 139, 139);
        HtmlColors.add("LightSteelBlue", 176, 196, 222);
        HtmlColors.add("PowderBlue", 176, 224, 230);
        HtmlColors.add("LightBlue", 173, 216, 230);
        HtmlColors.add("SkyBlue", 135, 206, 235);
        HtmlColors.add("LightSkyBlue", 135, 206, 250);
        HtmlColors.add("DeepSkyBlue", 0, 191, 255);
        HtmlColors.add("DodgerBlue", 30, 144, 255);
        HtmlColors.add("CornflowerBlue", 100, 149, 237);
        HtmlColors.add("SteelBlue", 70, 130, 180);
        HtmlColors.add("RoyalBlue", 65, 105, 225);
        HtmlColors.add("MediumBlue", 0, 0, 205);
        HtmlColors.add("DarkBlue", 0, 0, 139);
        HtmlColors.add("MidnightBlue", 25, 25, 112);
        HtmlColors.add("Lavender", 230, 230, 250);
        HtmlColors.add("Thistle", 216, 191, 216);
        HtmlColors.add("Plum", 221, 160, 221);
        HtmlColors.add("Violet", 238, 130, 238);
        HtmlColors.add("Orchid", 218, 112, 214);
        HtmlColors.add("Magenta", 255, 0, 255);
        HtmlColors.add("MediumOrchid", 186, 85, 211);
        HtmlColors.add("MediumPurple", 147, 112, 219);
        HtmlColors.add("BlueViolet", 138, 43, 226);
        HtmlColors.add("DarkViolet", 148, 0, 211);
        HtmlColors.add("DarkMagenta", 139, 0, 139);
        HtmlColors.add("Indigo", 75, 0, 130);
        HtmlColors.add("DarkSlateBlue", 72, 61, 139);
        HtmlColors.add("SlateBlue", 106, 90, 205);
        HtmlColors.add("MediumSlateBlue", 123, 104, 238);
        HtmlColors.add("Snow", 255, 250, 250);
        HtmlColors.add("Honeydew", 240, 255, 240);
        HtmlColors.add("MintCream", 245, 255, 250);
        HtmlColors.add("Azure", 240, 255, 255);
        HtmlColors.add("AliceBlue", 240, 248, 255);
        HtmlColors.add("GhostWhite", 248, 248, 255);
        HtmlColors.add("WhiteSmoke", 245, 245, 245);
        HtmlColors.add("Seashell", 255, 245, 238);
        HtmlColors.add("Beige", 245, 245, 220);
        HtmlColors.add("OldLace", 253, 245, 230);
        HtmlColors.add("FloralWhite", 255, 250, 240);
        HtmlColors.add("Ivory", 255, 255, 240);
        HtmlColors.add("AntiqueWhite", 250, 235, 215);
        HtmlColors.add("Linen", 250, 240, 230);
        HtmlColors.add("LavenderBlush", 255, 240, 245);
        HtmlColors.add("MistyRose", 255, 228, 225);
        HtmlColors.add("Gainsboro", 220, 220, 220);
        HtmlColors.add(211, 211, 211, "LightGrey", "LightGray");
        HtmlColors.add(169, 169, 169, "DarkGrey", "DarkGray");
        HtmlColors.add(105, 105, 105, "DimGrey", "DimGray");
        HtmlColors.add(119, 136, 153, "LightSlateGrey", "LightSlateGray");
        HtmlColors.add(112, 128, 144, "SlateGrey", "SlateGray");
        HtmlColors.add(47, 79, 79, "DarkSlateGrey", "DarkSlateGray");
    }
}

