/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.StringUtil;
import chatty.util.commands.Item;
import chatty.util.commands.Items;
import chatty.util.commands.Literal;
import chatty.util.commands.Parameters;
import chatty.util.commands.Parser;
import java.text.ParseException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class CustomCommand {
    private final String name;
    private final String chan;
    private final Items items;
    private final String raw;
    private final String error;
    private final String singleLineError;

    private CustomCommand(String name, String chan, Items items, String raw) {
        this.items = items;
        this.error = null;
        this.singleLineError = null;
        this.name = name;
        this.chan = chan;
        this.raw = raw;
    }

    private CustomCommand(String name, String chan, String error, String singleLineError, String raw) {
        this.items = null;
        this.error = error;
        this.singleLineError = singleLineError;
        this.name = name;
        this.chan = chan;
        this.raw = raw;
    }

    public String replace(Parameters parameters) {
        return this.items.replace(parameters);
    }

    public String getRaw() {
        return this.raw;
    }

    public String toString() {
        if (this.items != null) {
            return this.items.toString();
        }
        return this.error;
    }

    public String getError() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String getSingleLineError() {
        return this.singleLineError;
    }

    public boolean hasName() {
        return !StringUtil.isNullOrEmpty(this.name);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasChan() {
        return !StringUtil.isNullOrEmpty(this.chan);
    }

    public String getChan() {
        return this.chan;
    }

    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return this.items.getIdentifiersWithPrefix(prefix);
    }

    public Set<String> getRequiredIdentifiers() {
        return this.items.getRequiredIdentifiers();
    }

    public String getCommandName() {
        String text;
        Item firstToken;
        if (this.items != null && !this.items.isEmpty() && (firstToken = this.items.getItem(0)) instanceof Literal && (text = ((Literal)firstToken).getLiteral()).startsWith("/")) {
            if (text.contains(" ")) {
                return text.substring(1, text.indexOf(" "));
            }
            return text.substring(1);
        }
        return null;
    }

    public static CustomCommand parse(String input) {
        return CustomCommand.parseCustom(null, null, input, "$", "\\");
    }

    public static CustomCommand parseCustom(String input, String special, String escape) {
        return CustomCommand.parseCustom(null, null, input, special, escape);
    }

    public static CustomCommand parse(String name, String chan, String input) {
        return CustomCommand.parseCustom(name, chan, input, "$", "\\");
    }

    public static CustomCommand parseCustom(String name, String chan, String input, String special, String escape) {
        if (special == null) {
            special = "$";
        }
        if (escape == null) {
            escape = "\\";
        }
        Parser parser = new Parser(input, special, escape);
        try {
            return new CustomCommand(name, chan, parser.parse(), input);
        }
        catch (ParseException ex) {
            return new CustomCommand(name, chan, CustomCommand.makeErrorMessage(ex.getLocalizedMessage(), ex.getErrorOffset(), input, false), CustomCommand.makeErrorMessage(ex.getLocalizedMessage(), ex.getErrorOffset(), input, true), input);
        }
    }

    public static String makeErrorMessage(String error, int pos, String input, boolean singleLine) {
        if (pos == -1) {
            return error;
        }
        int before = 30;
        int after = 20;
        String dotdot = "[..]";
        int start = pos > 30 + "[..]".length() ? pos - 30 : 0;
        int end = input.length() > pos + 20 + "[..]".length() ? pos + 20 : input.length();
        int displayPos = pos - start;
        String excerpt = input.substring(start, end);
        if (start > 0) {
            excerpt = "[..]" + excerpt;
            displayPos += "[..]".length();
        }
        if (end < input.length()) {
            excerpt = excerpt + "[..]";
        }
        if (singleLine) {
            String excerpt1 = excerpt.substring(0, displayPos);
            int endExcerptStart = displayPos + 1;
            if (endExcerptStart > excerpt.length()) {
                endExcerptStart = excerpt.length();
            }
            String excerpt2 = excerpt.substring(displayPos, endExcerptStart);
            String excerpt3 = excerpt.substring(endExcerptStart);
            return String.format("%s at pos %s (\"%s%s<<<%s\")", error, pos + 1, excerpt1, excerpt2, excerpt3);
        }
        return String.format("%s at pos %s\n %s\n %s^", error, pos + 1, excerpt, String.join((CharSequence)"", Collections.nCopies(displayPos, " ")));
    }

    public static CustomCommand createDefault(String commandName) {
        return CustomCommand.parse(commandName + " $1-");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomCommand other = (CustomCommand)obj;
        if (!Objects.equals(this.items, other.items)) {
            return false;
        }
        return Objects.equals(this.error, other.error);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.items);
        hash = 73 * hash + Objects.hashCode(this.error);
        return hash;
    }

    public static void main(String[] args) {
        CustomCommand command = CustomCommand.parse("$lower(abc) $$1- $$(blah) fewaf $afwe");
        System.out.println(command.error);
        System.out.println(command.getRequiredIdentifiers());
    }
}

