/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.Commands;
import chatty.Helper;
import chatty.Room;
import chatty.TwitchClient;
import chatty.TwitchCommands;
import chatty.gui.components.eventlog.EventLog;
import chatty.util.StringUtil;
import chatty.util.api.StreamInfo;
import chatty.util.api.TwitchApi;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Parameters;
import chatty.util.settings.Settings;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class CustomCommands {
    private static final Logger LOGGER = Logger.getLogger(CustomCommands.class.getName());
    private final Map<String, Map<String, CustomCommand>> commands = new HashMap<String, Map<String, CustomCommand>>();
    private final Map<String, Map<String, CustomCommand>> replacements = new HashMap<String, Map<String, CustomCommand>>();
    private final Settings settings;
    private final TwitchApi api;
    private final TwitchClient client;

    public CustomCommands(Settings settings, TwitchApi api, TwitchClient client) {
        this.settings = settings;
        this.api = api;
        this.client = client;
    }

    public void command(String commandName, Parameters parameters, Room room, Consumer<String> result) {
        CustomCommand command = CustomCommands.getCommand(this.commands, commandName, room.getOwnerChannel());
        if (command != null) {
            this.command(command, parameters, room, result);
        } else {
            result.accept(null);
        }
    }

    public void command(CustomCommand command, Parameters parameters, Room room, Consumer<String> result) {
        Map<String, CustomCommand> customIdentifiersCommands;
        String stream;
        StreamInfo streamInfo;
        CustomCommands.addChans(room, parameters);
        HashSet chans = new HashSet();
        this.client.getOpenChannels().forEach(chan -> {
            if (Helper.isRegularChannelStrict(chan)) {
                chans.add(Helper.toStream(chan));
            }
        });
        parameters.put("chans", StringUtil.join(chans, " "));
        parameters.putObject("localUser", this.client.getLocalUser(room.getChannel()));
        parameters.putObject("settings", this.client.settings);
        if (!command.getIdentifiersWithPrefix("stream").isEmpty() && (streamInfo = this.api.getStreamInfo(stream = Helper.toValidStream(room.getStream()), null)).isValid()) {
            parameters.putObject("streamInfo", streamInfo);
        }
        parameters.put("chain-test", "| /echo Test || Message");
        parameters.put("allow-request", "true");
        if (command.getRaw() != null && command.getRaw().startsWith("/chain ")) {
            parameters.put(Helper.ESCAPE_FOR_CHAIN_COMMAND, "true");
        } else {
            parameters.remove(Helper.ESCAPE_FOR_CHAIN_COMMAND);
        }
        if (command.getRaw() != null && command.getRaw().startsWith("/foreach ")) {
            parameters.put(Helper.ESCAPE_FOR_FOREACH_COMMAND, "true");
        } else {
            parameters.remove(Helper.ESCAPE_FOR_FOREACH_COMMAND);
        }
        parameters.put("nested-custom-commands", String.valueOf(CustomCommands.getCustomCommandCount(parameters) + 1));
        boolean performAsync = false;
        if (CustomCommands.shouldPerformAsyncReplacement(command)) {
            performAsync = true;
        }
        if (this.containsAsyncReplacement((customIdentifiersCommands = this.getCustomIdentifierCommands(command, room.getOwnerChannel())).values())) {
            performAsync = true;
        }
        if (performAsync) {
            new Thread(() -> {
                CustomCommands.addCustomIdentifiers(customIdentifiersCommands, parameters);
                result.accept(command.replace(parameters));
            }, "CustomCommand").start();
        } else {
            CustomCommands.addCustomIdentifiers(customIdentifiersCommands, parameters);
            result.accept(command.replace(parameters));
        }
    }

    public void addCustomIdentifierParametersForCommand(CustomCommand command, Parameters parameters) {
        Map<String, CustomCommand> customIdentifiersCommands = this.getCustomIdentifierCommands(command, null);
        CustomCommands.addCustomIdentifiers(customIdentifiersCommands, parameters);
        Room room = (Room)parameters.getObject("room");
        if (room != null) {
            parameters.putObject("localUser", this.client.getLocalUser(room.getChannel()));
            CustomCommands.addChans(room, parameters);
        }
    }

    private Map<String, CustomCommand> getCustomIdentifierCommands(CustomCommand command, String channel) {
        HashMap<String, CustomCommand> customIdentifiersCommands = new HashMap<String, CustomCommand>();
        for (String identifier : command.getIdentifiersWithPrefix("_")) {
            CustomCommand identifierCommand = CustomCommands.getCommand(this.replacements, identifier, channel);
            if (identifierCommand == null) continue;
            customIdentifiersCommands.put(identifier, identifierCommand);
        }
        return customIdentifiersCommands;
    }

    private static void addCustomIdentifiers(Map<String, CustomCommand> commands, Parameters parameters) {
        for (Map.Entry<String, CustomCommand> entry : commands.entrySet()) {
            parameters.putObject(entry.getKey(), entry.getValue());
        }
    }

    private boolean containsAsyncReplacement(Collection<CustomCommand> commands) {
        for (CustomCommand command : commands) {
            if (!CustomCommands.shouldPerformAsyncReplacement(command)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldPerformAsyncReplacement(CustomCommand command) {
        return !command.getIdentifiersWithPrefix("-async-").isEmpty();
    }

    public static void addChans(Room room, Parameters parameters) {
        parameters.put("chan", Helper.toStream(room.getChannel()));
        parameters.put("stream", room.getStream());
    }

    public synchronized boolean containsCommand(String command, Room room) {
        return CustomCommands.getCommand(this.commands, command, room.getOwnerChannel()) != null;
    }

    public void update(Commands regularCommands) {
        this.loadFromSettings();
        HashSet<String> nameCollisions = new HashSet<String>();
        for (String customCommandName : this.getCommandNames()) {
            if (!regularCommands.isCommand(customCommandName) && !TwitchCommands.isCommand(customCommandName)) continue;
            nameCollisions.add(customCommandName);
        }
        EventLog.removeSystemEvent("session.settings.customCommandNameCollsision");
        if (!nameCollisions.isEmpty()) {
            EventLog.addSystemEvent("session.settings.customCommandNameCollsision", StringUtil.join(nameCollisions, ", ", s -> "/" + s));
        }
    }

    public synchronized void loadFromSettings() {
        List commandsToLoad = this.settings.getList("commands");
        this.commands.clear();
        this.replacements.clear();
        for (String entry : commandsToLoad) {
            CustomCommand command = CustomCommands.parseCommandWithName(entry);
            if (command == null) continue;
            if (!command.hasError()) {
                String commandName = command.getName();
                String chan = command.getChan();
                if (commandName.startsWith("_") && commandName.length() > 1) {
                    CustomCommands.addCommand(this.replacements, commandName, chan, command);
                    continue;
                }
                CustomCommands.addCommand(this.commands, commandName, chan, command);
                continue;
            }
            LOGGER.warning("Error parsing custom command: " + command.getError());
        }
    }

    public static CustomCommand parseCommandWithName(String c) {
        String[] split;
        if (c != null && !c.isEmpty() && (split = (c = c.trim()).split(" ", 2)).length == 2) {
            String commandName = split[0];
            if (commandName.startsWith("/")) {
                commandName = commandName.substring(1);
            }
            commandName = StringUtil.toLowerCase(commandName.trim());
            String chan = null;
            if (commandName.contains("#")) {
                String[] splitChan = commandName.split("#", 2);
                commandName = splitChan[0];
                chan = splitChan[1];
            }
            String commandValue = split[1].trim();
            if (!commandName.isEmpty()) {
                return CustomCommand.parse(commandName, chan, commandValue);
            }
        }
        return null;
    }

    public synchronized Collection<String> getCommandNames() {
        return new HashSet<String>(this.commands.keySet());
    }

    private static synchronized CustomCommand getCommand(Map<String, Map<String, CustomCommand>> commands, String commandName, String channel) {
        commandName = StringUtil.toLowerCase(commandName);
        channel = StringUtil.toLowerCase(Helper.toStream(channel));
        if (!commands.containsKey(commandName)) {
            return null;
        }
        Map<String, CustomCommand> variations = commands.get(commandName);
        if (variations.containsKey(channel)) {
            return variations.get(channel);
        }
        return variations.get(null);
    }

    private static void addCommand(Map<String, Map<String, CustomCommand>> commands, String commandName, String channel, CustomCommand parsedCommand) {
        if (!commands.containsKey(commandName)) {
            commands.put(commandName, new HashMap());
        }
        commands.get(commandName).put(channel, parsedCommand);
    }

    public static int getCustomCommandCount(Parameters parameters) {
        String countString = parameters.get("nested-custom-commands");
        return countString == null ? 0 : Integer.parseInt(countString);
    }
}

