/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class DateTime
implements Item {
    private static final Map<String, DateTimeFormatter> predefinedFormats = new HashMap<String, DateTimeFormatter>();
    private final Item format;
    private final Item zone;
    private final Item locale;
    private final Item timestamp;
    private final boolean isRequired;

    public DateTime(Item format, Item zone, Item locale, Item timestamp, boolean isRequired) {
        this.format = format;
        this.zone = zone;
        this.locale = locale;
        this.timestamp = timestamp;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        String formatString = "";
        if (this.format != null) {
            formatString = this.format.replace(parameters);
        }
        String zoneString = "";
        if (this.zone != null) {
            zoneString = this.zone.replace(parameters);
        }
        String localeString = "";
        if (this.locale != null) {
            localeString = this.locale.replace(parameters);
        }
        String timestampString = "";
        if (this.timestamp != null) {
            timestampString = this.timestamp.replace(parameters);
        }
        if (!Item.checkReq(this.isRequired, formatString, zoneString, localeString, timestampString)) {
            return null;
        }
        zoneString = zoneString.trim();
        localeString = localeString.trim();
        timestampString = timestampString.trim();
        DateTimeFormatter formatter = this.getPredefined(formatString);
        if (formatter == null) {
            if (!formatString.isEmpty()) {
                try {
                    formatter = DateTimeFormatter.ofPattern(formatString);
                }
                catch (Exception ex) {
                    return "Invalid time format (" + ex.getLocalizedMessage() + ")";
                }
            } else {
                formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL);
            }
        }
        ZoneId zoneId = ZoneId.systemDefault();
        if (!zoneString.isEmpty()) {
            try {
                zoneId = ZoneId.of(zoneString);
            }
            catch (Exception ex) {
                try {
                    zoneId = ZoneId.of(this.findZoneId(zoneString));
                }
                catch (Exception ex2) {
                    return "Invalid timezone";
                }
            }
        }
        if (!localeString.isEmpty()) {
            formatter = formatter.withLocale(Locale.forLanguageTag(localeString));
        }
        long parsedTimestamp = -1L;
        if (!timestampString.isEmpty()) {
            try {
                parsedTimestamp = Long.parseLong(timestampString);
            }
            catch (NumberFormatException ex) {
                return "Invalid timestamp";
            }
        }
        try {
            if (parsedTimestamp != -1L) {
                return ZonedDateTime.ofInstant(Instant.ofEpochMilli(parsedTimestamp), zoneId).format(formatter);
            }
            return ZonedDateTime.now(zoneId).format(formatter);
        }
        catch (Exception ex) {
            return "Time format error";
        }
    }

    private String findZoneId(String search) {
        search = search.replace(" ", "_").toLowerCase(Locale.ENGLISH);
        String someMatch = null;
        for (String zoneId : ZoneId.getAvailableZoneIds()) {
            if (zoneId.equalsIgnoreCase(search)) {
                return zoneId;
            }
            if (!zoneId.toLowerCase(Locale.ENGLISH).contains(search)) continue;
            someMatch = zoneId;
        }
        return someMatch;
    }

    private DateTimeFormatter getPredefined(String input) {
        for (String key : predefinedFormats.keySet()) {
            if (!input.equals(key)) continue;
            return predefinedFormats.get(key);
        }
        return null;
    }

    public String toString() {
        return "Time (" + this.format + "," + this.zone + "," + this.locale + ")";
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.format, this.zone, this.locale);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.format, this.zone, this.locale);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTime other = (DateTime)obj;
        if (!Objects.equals(this.format, other.format)) {
            return false;
        }
        if (!Objects.equals(this.zone, other.zone)) {
            return false;
        }
        if (!Objects.equals(this.locale, other.locale)) {
            return false;
        }
        return this.isRequired == other.isRequired;
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + Objects.hashCode(this.format);
        hash = 71 * hash + Objects.hashCode(this.zone);
        hash = 71 * hash + Objects.hashCode(this.locale);
        hash = 71 * hash + (this.isRequired ? 1 : 0);
        return hash;
    }

    static {
        predefinedFormats.put("date", DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        predefinedFormats.put("date2", DateTimeFormatter.ofPattern("yyyy-MM-dd z 'GMT'xx"));
        predefinedFormats.put("datetime", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        predefinedFormats.put("datetime2", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z 'GMT'xx"));
        predefinedFormats.put("time", DateTimeFormatter.ofPattern("HH:mm:ss"));
        predefinedFormats.put("time2", DateTimeFormatter.ofPattern("HH:mm:ss z 'GMT'xx"));
        predefinedFormats.put("time_short", DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT));
        predefinedFormats.put("time_medium", DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM));
        predefinedFormats.put("time_long", DateTimeFormatter.ofLocalizedTime(FormatStyle.LONG));
        predefinedFormats.put("time_full", DateTimeFormatter.ofLocalizedTime(FormatStyle.FULL));
        predefinedFormats.put("date_short", DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT));
        predefinedFormats.put("date_medium", DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM));
        predefinedFormats.put("date_long", DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG));
        predefinedFormats.put("date_full", DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL));
        predefinedFormats.put("datetime_short", DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT));
        predefinedFormats.put("datetime_medium", DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM));
        predefinedFormats.put("datetime_long", DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG));
        predefinedFormats.put("datetime_full", DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL));
    }
}

