/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.Helper;
import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.util.Objects;
import java.util.Set;

public class Escape
implements Item {
    private final Item item;
    private final boolean isRequired;
    private final Type type;

    public Escape(Item item, Type type, boolean isRequired) {
        this.item = item;
        this.type = type;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        String value = this.item.replace(parameters);
        if (!Item.checkReq(this.isRequired, value)) {
            return null;
        }
        switch (this.type) {
            case CHAIN: {
                if (parameters.get(Helper.ESCAPE_FOR_CHAIN_COMMAND) != null) break;
                return Helper.escapeForChainCommand(value);
            }
            case FOREACH: {
                if (parameters.get(Helper.ESCAPE_FOR_FOREACH_COMMAND) != null) break;
                return Helper.escapeForForeachCommand(value);
            }
        }
        return value;
    }

    public String toString() {
        return String.format("Escape(%s) %s", new Object[]{this.type, this.item});
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.item);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.item);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Escape other = (Escape)obj;
        if (this.isRequired != other.isRequired) {
            return false;
        }
        if (!Objects.equals(this.item, other.item)) {
            return false;
        }
        return this.type == other.type;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.item);
        hash = 29 * hash + (this.isRequired ? 1 : 0);
        hash = 29 * hash + Objects.hashCode((Object)this.type);
        return hash;
    }

    public static enum Type {
        CHAIN,
        FOREACH;

    }
}

