/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import chatty.util.settings.Settings;
import java.util.Objects;
import java.util.Set;

class Get
implements Item {
    private final Item item;
    private final Item sub;
    private final boolean isRequired;

    public Get(Item item, Item sub, boolean isRequired) {
        this.item = item;
        this.sub = sub;
        this.isRequired = isRequired;
    }

    @Override
    public String replace(Parameters parameters) {
        String value = this.item.replace(parameters);
        if (!Item.checkReq(this.isRequired, value)) {
            return null;
        }
        Settings settings = (Settings)parameters.getObject("settings");
        if (settings == null) {
            return this.isRequired ? null : "";
        }
        String result = null;
        if (settings.isStringSetting(value)) {
            result = settings.getString(value);
        }
        if (settings.isBooleanSetting(value)) {
            String string = result = settings.getBoolean(value) ? "true" : "";
        }
        if (settings.isLongSetting(value)) {
            result = String.valueOf(settings.getLong(value));
        }
        if (settings.isMapSetting(value)) {
            if (this.sub != null) {
                String value2 = this.sub.replace(parameters);
                if (!Item.checkReq(this.isRequired, value2)) {
                    return null;
                }
                Object o = settings.mapGet(value, value2);
                result = o != null ? String.valueOf(o) : "";
            } else {
                result = String.valueOf(settings.getMap(value));
            }
        }
        if (settings.isListSetting(value)) {
            result = String.valueOf(settings.getList(value));
        }
        return Item.checkReq(this.isRequired, result) ? result : null;
    }

    public String toString() {
        return "Get " + this.item + "[" + this.sub + "]";
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.item, this.sub);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.item, this.sub);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Get other = (Get)obj;
        if (!Objects.equals(this.item, other.item)) {
            return false;
        }
        if (!Objects.equals(this.sub, other.sub)) {
            return false;
        }
        return this.isRequired == other.isRequired;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.item);
        hash = 59 * hash + Objects.hashCode(this.sub);
        hash = 59 * hash + (this.isRequired ? 1 : 0);
        return hash;
    }
}

