/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.StringUtil;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Item;
import chatty.util.commands.Parameters;
import java.util.Objects;
import java.util.Set;

class Identifier
implements Item {
    private final String name;

    public Identifier(String name) {
        this.name = StringUtil.toLowerCase(name);
    }

    @Override
    public String replace(Parameters parameters) {
        String value = parameters.get(this.name);
        if (value == null && this.name.startsWith("_") || parameters.hasKey("-presets-")) {
            Object o = parameters.getObject(this.name);
            CustomCommand command = null;
            if (o instanceof CustomCommand) {
                command = (CustomCommand)o;
            }
            String checkKey = "-" + this.name + "-";
            if (command != null) {
                if (parameters.get(checkKey) == null) {
                    Parameters subParameters = parameters.copy();
                    subParameters.put(checkKey, "true");
                    value = command.replace(subParameters);
                } else {
                    value = "[recursion not allowed]";
                }
            }
        }
        return value != null ? value : "";
    }

    public String toString() {
        return "$" + this.name;
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.name);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getIdentifiersWithPrefix("", this.name);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identifier other = (Identifier)obj;
        return Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + Objects.hashCode(this.name);
        return hash;
    }
}

