/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.commands.Item;
import chatty.util.commands.Items;
import chatty.util.commands.Parameters;
import java.util.Objects;
import java.util.Set;

class If
implements Item {
    private final boolean isRequired;
    private final Item identifier;
    private final Items output1;
    private final Items output2;

    public If(Item name, boolean isRequired, Items output1, Items output2) {
        this.isRequired = isRequired;
        this.identifier = name;
        this.output1 = output1;
        this.output2 = output2;
    }

    @Override
    public String replace(Parameters parameters) {
        String value = this.identifier.replace(parameters);
        if (value == null) {
            return null;
        }
        String output = "";
        if (!value.isEmpty()) {
            output = this.output1.replace(parameters);
        } else if (this.output2 != null) {
            output = this.output2.replace(parameters);
        }
        if (!Item.checkReq(this.isRequired, output)) {
            return null;
        }
        return output;
    }

    public String toString() {
        return "If " + this.identifier + " ? " + this.output1 + " : " + this.output2;
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.identifier, this.output1, this.output2);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.identifier, this.output1, this.output2);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        If other = (If)obj;
        if (this.isRequired != other.isRequired) {
            return false;
        }
        if (!Objects.equals(this.identifier, other.identifier)) {
            return false;
        }
        if (!Objects.equals(this.output1, other.output1)) {
            return false;
        }
        return Objects.equals(this.output2, other.output2);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.isRequired ? 1 : 0);
        hash = 97 * hash + Objects.hashCode(this.identifier);
        hash = 97 * hash + Objects.hashCode(this.output1);
        hash = 97 * hash + Objects.hashCode(this.output2);
        return hash;
    }
}

