/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.commands;

import chatty.util.commands.Item;
import chatty.util.commands.Items;
import chatty.util.commands.Parameters;
import java.util.Objects;
import java.util.Set;

class IfEq
implements Item {
    private final boolean isRequired;
    private final Item identifier;
    private final Items compare;
    private final Items output1;
    private final Items output2;

    public IfEq(Item identifier, boolean isRequired, Items compare, Items output1, Items output2) {
        this.identifier = identifier;
        this.isRequired = isRequired;
        this.compare = compare;
        this.output1 = output1;
        this.output2 = output2;
    }

    @Override
    public String replace(Parameters parameters) {
        String value = this.identifier.replace(parameters);
        String compareTo = this.compare.replace(parameters);
        if (value == null || compareTo == null) {
            return null;
        }
        String output = "";
        if (Objects.equals(value, compareTo)) {
            output = this.output1.replace(parameters);
        } else if (this.output2 != null) {
            output = this.output2.replace(parameters);
        }
        if (!Item.checkReq(this.isRequired, output)) {
            return null;
        }
        return output;
    }

    public String toString() {
        return "IfEq " + this.identifier + " == " + this.compare + " ? " + this.output1 + " : " + this.output2;
    }

    @Override
    public Set<String> getIdentifiersWithPrefix(String prefix) {
        return Item.getIdentifiersWithPrefix(prefix, this.identifier, this.compare, this.output1, this.output2);
    }

    @Override
    public Set<String> getRequiredIdentifiers() {
        return Item.getRequiredIdentifiers(this.isRequired, this.identifier, this.compare, this.output1, this.output2);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IfEq other = (IfEq)obj;
        if (this.isRequired != other.isRequired) {
            return false;
        }
        if (Objects.equals(this.identifier, other.identifier)) {
            return false;
        }
        if (Objects.equals(this.compare, other.compare)) {
            return false;
        }
        if (Objects.equals(this.output1, other.output1)) {
            return false;
        }
        return !Objects.equals(this.output2, other.output2);
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + (this.isRequired ? 1 : 0);
        hash = 59 * hash + Objects.hashCode(this.identifier);
        hash = 59 * hash + Objects.hashCode(this.compare);
        hash = 59 * hash + Objects.hashCode(this.output1);
        hash = 59 * hash + Objects.hashCode(this.output2);
        return hash;
    }
}

